# การปรับปรุง Logic การประเมิน - กรองเฉพาะคำถาม yes_no ที่ใช้ในการประเมิน

## สรุปการเปลี่ยนแปลง

ระบบได้รับการปรับปรุงให้กรองเฉพาะคำถามที่มี `use_in_evaluation = true` และ `question_type = 'yes_no'` เท่านั้นในการคิดตาม logic AND/OR

## การเปลี่ยนแปลงหลัก

### 1. ใน `AssessmentHelper.php`

#### ฟังก์ชัน `evaluateQuestion()`
- เพิ่มการกรองคำถามย่อยที่ใช้ในการประเมินและเป็น yes_no: 
  ```php
  $evaluableChildren = $question->children
      ->where('use_in_evaluation', true)
      ->where('question_type', 'yes_no');
  ```
- ตรวจสอบว่ามีคำถามย่อยที่ใช้ในการประเมินและเป็น yes_no หรือไม่
- กรองเฉพาะผลลัพธ์ที่ไม่ใช่ null (คำถามที่มีการตอบ)

#### ฟังก์ชัน `evaluateSingleQuestion()`
- ประเมินเฉพาะคำถามประเภท yes_no เท่านั้น
- คำถามประเภทอื่นๆ (text, multiple_choice) จะคืนค่า null (ไม่นำมาคำนวณ)

#### ฟังก์ชัน `getEvaluationResults()`
- ดึงเฉพาะคำถามระดับบนสุดที่ใช้ในการประเมิน
- ดึงเฉพาะคำถามย่อยที่ใช้ในการประเมินและเป็น yes_no เท่านั้น

#### ฟังก์ชัน `calculateSummary()`
- นับเฉพาะคำถามย่อยที่ใช้ในการประเมินและเป็น yes_no เท่านั้น
- นับเฉพาะคำถามเดี่ยวที่เป็น yes_no และใช้ในการประเมิน

#### ฟังก์ชันใหม่
- `getEvaluationQuestions()`: ดึงคำถามทั้งหมดที่ใช้ในการประเมินและเป็น yes_no
- `isQuestionUsedInEvaluation()`: ตรวจสอบว่าคำถามใช้ในการประเมินและเป็น yes_no หรือไม่
- `getEvaluableChildren()`: ดึงคำถามย่อยที่ใช้ในการประเมินและเป็น yes_no เท่านั้น

## ผลกระทบ

### 1. การประเมินผล
- คำถามที่มี `use_in_evaluation = false` จะไม่ถูกนำมาคำนวณ
- คำถามที่มี `question_type != 'yes_no'` จะไม่ถูกนำมาคำนวณ
- คำถามแม่ที่ไม่มี `question_type` จะไม่ถูกประเมินโดยตรง
- ระบบจะแสดงผลเฉพาะคำถาม yes_no ที่ใช้ในการประเมินเท่านั้น

### 2. การแสดงผล
- ในหน้า report จะแสดงเฉพาะคำถามที่ใช้ในการประเมิน
- จำนวนคำถามที่ประเมินจะนับเฉพาะคำถามที่ `use_in_evaluation = true` และ `question_type = 'yes_no'`

### 3. การคำนวณเปอร์เซ็นต์
- เปอร์เซ็นต์การผ่านจะคำนวณจากคำถาม yes_no ที่ใช้ในการประเมินเท่านั้น

## ตัวอย่างการทำงาน

### กรณีที่ 1: คำถามแม่มี logic AND
```
คำถามแม่: "ข้อกำหนดทั่วไป" (use_in_evaluation = true, logic = AND)
├── คำถามย่อย 1: "มีเอกสาร" (use_in_evaluation = true, yes_no) → ตอบ "ใช่"
├── คำถามย่อย 2: "มีการจัดเก็บ" (use_in_evaluation = true, yes_no) → ตอบ "ใช่"
├── คำถามย่อย 3: "หมายเหตุ" (use_in_evaluation = false, text) → ตอบ "มีหมายเหตุ"
└── คำถามย่อย 4: "เลือกตัวเลือก" (use_in_evaluation = true, multiple_choice) → ตอบ "ตัวเลือก A"

ผลลัพธ์: ผ่าน (เพราะคำถามย่อย 1 และ 2 ตอบ "ใช่" ทั้งคู่)
คำถามที่นำมาคำนวณ: 2 ข้อ (เฉพาะ yes_no ที่ใช้ในการประเมิน)
```

### กรณีที่ 2: คำถามแม่มี logic OR
```
คำถามแม่: "ข้อกำหนดทั่วไป" (use_in_evaluation = true, logic = OR)
├── คำถามย่อย 1: "มีเอกสาร" (use_in_evaluation = true, yes_no) → ตอบ "ไม่ใช่"
├── คำถามย่อย 2: "มีการจัดเก็บ" (use_in_evaluation = true, yes_no) → ตอบ "ใช่"
├── คำถามย่อย 3: "หมายเหตุ" (use_in_evaluation = false, text) → ตอบ "มีหมายเหตุ"
└── คำถามย่อย 4: "เลือกตัวเลือก" (use_in_evaluation = true, multiple_choice) → ตอบ "ตัวเลือก A"

ผลลัพธ์: ผ่าน (เพราะคำถามย่อย 2 ตอบ "ใช่")
คำถามที่นำมาคำนวณ: 2 ข้อ (เฉพาะ yes_no ที่ใช้ในการประเมิน)
```

## การทดสอบ

ไฟล์ `test_assessment_logic.php` ถูกสร้างขึ้นเพื่อทดสอบการทำงานของ logic ใหม่

### กรณีทดสอบ
1. คำถามย่อย yes_no ทั้งหมดตอบ "ใช่" (AND ควรเป็น true)
2. คำถามย่อยหนึ่งตอบ "ไม่ใช่" (AND ควรเป็น false)
3. เปลี่ยนเป็น OR
4. ไม่มีคำตอบ
5. ทดสอบคำถามเดี่ยวที่เป็น yes_no

## ข้อควรระวัง

1. คำถามที่มี `use_in_evaluation = false` จะไม่ถูกนำมาคำนวณ
2. คำถามที่มี `question_type != 'yes_no'` จะไม่ถูกนำมาคำนวณ
3. คำถามแม่ที่ไม่มี `question_type` จะไม่ถูกประเมินโดยตรง
4. ระบบจะแสดงผลเฉพาะคำถาม yes_no ที่ใช้ในการประเมินเท่านั้น
5. การคำนวณเปอร์เซ็นต์จะนับเฉพาะคำถาม yes_no ที่ใช้ในการประเมิน

## การใช้งาน

การเปลี่ยนแปลงนี้จะทำงานอัตโนมัติเมื่อ:
- เรียกใช้ `AssessmentHelper::getEvaluationResults()`
- เรียกใช้ `AssessmentHelper::calculateSummary()`
- แสดงผลในหน้า report

ไม่จำเป็นต้องเปลี่ยนแปลงโค้ดในส่วนอื่นๆ เพราะการเปลี่ยนแปลงอยู่ใน `AssessmentHelper` เท่านั้น

## ประเภทคำถามที่รองรับ

### ✅ รองรับ (นำมาคำนวณ)
- `yes_no`: คำถามใช่/ไม่ใช่

### ❌ ไม่รองรับ (ไม่นำมาคำนวณ)
- `text`: คำถามข้อความ
- `multiple_choice`: คำถามเลือกตัวเลือก
- คำถามประเภทอื่นๆ 