<?php 
session_start();
require_once 'config/db.php';

// ตรวจสอบเซสชันที่ใช้งานอยู่และเปลี่ยนหน้าไปตามระดับการเข้าสู่ระบบ
if (isset($_SESSION['admin_login'])) {
    unset($_SESSION['error']);
    unset($_SESSION['register_success']);
    header("location: index.php");
    exit();
} elseif (isset($_SESSION['superadmin_login'])) {
    unset($_SESSION['error']);
    unset($_SESSION['register_success']);
    header("location: index.php");
    exit();
} elseif (isset($_SESSION['consult_login'])) {
    unset($_SESSION['error']);
    unset($_SESSION['register_success']);
    header("location: indexUser.php");
    exit();
} elseif (isset($_SESSION['user_login'])) {
    unset($_SESSION['error']);
    unset($_SESSION['register_success']);
    header("location: indexUser.php");
    exit();
}

if (isset($_POST['signin'])) {
    $Email = $_POST['Email'];
    $Password = $_POST['Password'];

    if (empty($Email)) {
        $_SESSION['error'] = 'กรุณากรอกชื่อผู้ใช้งาน';
        header("location: login.php");
    } else if (empty($Password)) {
        $_SESSION['error'] = 'กรุณากรอกรหัสผ่าน';
        header("location: login.php");
    } else if (strlen($_POST['Password']) > 20 || strlen($_POST['Password']) < 8) {
        $_SESSION['error'] = 'รหัสผ่านต้องมีความขนาดระหว่าง 8-20 ตัวอักษร';
        header("location: login.php");
    } else {
        try {
            $chack_data = $conn->prepare("SELECT * FROM customer WHERE Email = :Email");
            $chack_data->bindParam(":Email", $Email);
            $chack_data->execute();
            $row = $chack_data->fetch(PDO::FETCH_ASSOC);

            if ($chack_data->rowCount() > 0) {
                if ($Email == $row['Email']) {
                    if (password_verify($Password, $row['Password'])) {
                        if ($row['Level'] == 'Admin') {
                            $_SESSION['admin_login'] = $row['Customer_ID'];
                            $_SESSION['success'] = 'เข้าสู่ระบบสำเร็จ';
                            header("location: index.php");
                        } else if ($row['Level'] == 'SuperAdmin') {
                            $_SESSION['superadmin_login'] = $row['Customer_ID'];
                            $_SESSION['success'] = 'เข้าสู่ระบบสำเร็จ';
                            header("location: index.php");
                        } else {
                            $_SESSION['user_login'] = $row['Customer_ID'];
                            $_SESSION['success'] = 'เข้าสู่ระบบสำเร็จ';
                            header("location: indexUser.php");
                        }
                    } else {
                        $_SESSION['error'] = 'รหัสผ่านผิด';
                        header("location: login.php");
                    }
                } else {
                    $_SESSION['error'] = 'อีเมลไม่ถูกต้อง';
                    header("location: login.php");
                }
            } else {
                $_SESSION['error'] = "ไม่มีข้อมูลในระบบ";
                header("location: login.php");
            }
        } catch (PDOException $e) {
            echo $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<title><?php  require_once 'Title.php';?></title>
	<meta charset="UTF-8">
	 <meta name="viewport" content="width=1200">
	<link href="assets/img/favicon.ico" rel="icon">
  	<link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
	<!--===============================================================================================-->	
	<link rel="icon" type="image/png" href="images/icons/favicon.ico"/>
	<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/bootstrap.min.css">
	<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">
	<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/animate/animate.css">
	<!--===============================================================================================-->	
	<link rel="stylesheet" type="text/css" href="vendor/css-hamburgers/hamburgers.min.css">
	<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/select2/select2.min.css">
	<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="css/util.css">
	<link rel="stylesheet" type="text/css" href="css/main.css">
	<!--===============================================================================================-->
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

	 <!-- Template Main CSS File -->
	 <link href="assets/css/style.css" rel="stylesheet">

<!-- Datatable libraries -->
<link rel="stylesheet" href="http://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">

<!-- SweetAlert2 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<link rel="stylesheet" href="http://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
  <!-- Font Awesome for Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<style>
    body, html {
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: -100px;
    }
    
    .wrap-login100 {
        background: #fff;
        border-radius: 8px;
        padding: 70px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .login100-form-title {
        margin-bottom: -30px;
        margin-top: 80px;
    }

    .wrap-input100 {
        margin-top: 5px;
    }
    
    .login100-pic {
        margin-top: 85px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        width: 100%;
        max-width: 400px;
        overflow: visible;
        margin-top: 100px;
    }

    .login100-pic img {
        width: 100%;
        height: auto;
        display: block !important;
        visibility: visible !important;
    }

    .version-text {
        position: absolute;
        bottom: 5;
        left: 0;
        font-size: 12px;
        color: #999;
        margin-left: 350px;
        top: 670px;
    }
    
    .version-text-under-logo {
        font-size: 14px;
        color: #999;
        text-align: center;
        margin-top: 120px;
        width: 100%;
        display: block;
    }
    
    #footer {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        padding: 20px;
    }

    #footer .copyright, #footer .credits {
        text-align: center;
        padding-left: 650px;
        padding-right: 0;
    }

    #footer a {
        text-decoration: none;
        color: inherit;
    }

    /* ปรับสำหรับหน้าจอเล็ก */
    @media (max-width: 768px) {
        .login100-pic {
            margin-top: 0;
        }

        .login100-pic img {
            width: 90%;
            margin: 0 auto;
        }
        
        #footer {
            align-items: center;
        }

        #footer .copyright, #footer .credits {
            text-align: center;
            padding-left: 0;
            padding-right: 0;
        }
        
        .version-text {
            display: block;
            margin-top: 350px;
            text-align: left;
            margin-left: 30px;
        }

        .text-center {
            margin-bottom: 20px;
        }
    }
</style>
</head>

<body>
	<div class="limiter">
		<div class="container-login100">
			<div class="wrap-login100">
			    <h1><span style="left; margin-left: 75px;font-size: 20px; font-weight: bold; color: #333333; ">ระบบติดตามสถานะการให้บริการทดสอบซอฟต์แวร์ SQUAT Servtrack</span></h1>
			
			    <div class="login100-pic">
                    <img src="images/Logo SQUAT_vertical.png" alt="Login Image">
                    <div class="version-text-under-logo">SQUAT Servtrack Version 1.0</div>
                </div>

				<form class="login100-form validate-form" action="LoginAdd.php" method="POST">
					<span class="login100-form-title">
						เข้าสู่ระบบ
					</span>

					<!-- Input fields -->
					<div class="wrap-input100 validate-input" data-validate="Valid Email is required: ex@abc.xyz">
						<input class="input100" type="text" name="Email" placeholder="Email">
						<span class="focus-input100"></span>
						<span class="symbol-input100">
							<i class="fa fa-envelope" aria-hidden="true"></i>
						</span>
					</div>

					<div class="wrap-input100 validate-input" data-validate="Password is required">
						<input class="input100" type="Password" name="Password" placeholder="Password">
						<span class="focus-input100"></span>
						<span class="symbol-input100">
							<i class="fa fa-lock" aria-hidden="true"></i>
						</span>
					</div>

					<div class="container-login100-form-btn" data-wow-delay="300ms">
						<button type="submit" name="signin" class="login100-form-btn">ยืนยัน</button>
					</div>

					<div class="text-center p-t-12">
						<a class="txt2" href="registerForm.php">
							ลงทะเบียน
						</a>/
						<a class="txt2" href="forgotPassword.php">
							ลืมรหัสผ่าน
						</a>
					</div>

					<div class="text-center p-t-136">
                        <a class="txt2" href="https://www.squat.in.th/">
                            <i class="fa fa-long-arrow-left m-l-5" aria-hidden="true"></i> Back
                        </a>
                    </div>

                   
				</form>
			</div>
		</div>
	</div>
	<footer id="footer" class="footer">
        <div class="copyright">
            &copy; All Rights Reserved <a href="https://www.squat.in.th/">ห้องปฏิบัติการทดสอบซอฟต์เเวร์ (SQUAT)</a>
        </div>
        <div class="credits">
            <span>ศูนย์เทคโนโลยีอิเล็กทรอนิกส์และคอมพิวเตอร์แห่งชาติ (NECTEC)</span>
        </div>
    </footer><!-- End Footer -->

	<!--===============================================================================================-->	
	<script src="vendor/jquery/jquery-3.2.1.min.js"></script>
	<!--===============================================================================================-->
	<script src="vendor/bootstrap/js/popper.js"></script>
	<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
	<!--===============================================================================================-->
	<script src="vendor/select2/select2.min.js"></script>
	<!--===============================================================================================-->
	<script src="vendor/tilt/tilt.jquery.min.js"></script>
	<script>
	$('.js-tilt').tilt({
		scale: 1.1
	})

	// SweetAlert2 handling for login error
	<?php if (isset($_SESSION['error'])) { ?>
		Swal.fire({
			icon: 'error',
			title: 'เข้าสู่ระบบผิดพลาด',
			text: '<?php echo $_SESSION['error']; ?>',
			didClose: () => { <?php unset($_SESSION['error']); ?> }
		});
	<?php } ?>

	// SweetAlert2 handling for register success
	<?php if (isset($_SESSION['register_success'])) { ?>
		Swal.fire({
			icon: 'success',
			title: 'ลงทะเบียนเสร็จสิ้น',
			text: '<?php echo $_SESSION['register_success']; ?>',
			didClose: () => { <?php unset($_SESSION['register_success']); ?> }
		});
	<?php } ?>
</script>

	<script src="js/main.js"></script>
</body>
</html>