<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckUserStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // ตรวจสอบว่าผู้ใช้ล็อกอินแล้วหรือไม่
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        $user = Auth::user();

        // ตรวจสอบสถานะผู้ใช้ (On_Off_Customer)
        if ($user->On_Off_Customer === 'Off') {
            // ล็อกเอาท์ผู้ใช้
            Auth::logout();
            
            // ล้าง session
            Session::flush();
            
            // redirect ไปหน้า login พร้อมข้อความแจ้งเตือน
            return redirect()->route('login')
                ->with('error', 'บัญชีของคุณถูกปิดใช้งานโดยผู้ดูแลระบบ กรุณาติดต่อผู้ดูแลระบบเพื่อขอความช่วยเหลือ');
        }

        return $next($request);
    }
} 