<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Customer extends Authenticatable
{
    use Notifiable;

    protected $table = 'customer';
    protected $primaryKey = 'Customer_ID';
    public $timestamps = false;

    protected $fillable = [
        'Customer_Name',
        'Mobile_Number',
        'Email',
        'Password',
        'Level',
        'Agency_ID',
        'CusIns_ID',
        'CusUdp_ID',
        'On_Off_Customer',
        'Edit_Customer',
        'New_Customer',
        'email_verified_at',
        'remember_token',
    ];

    protected $hidden = [
        'Password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'DtmIns' => 'datetime',
        'DtmUdp' => 'datetime',
    ];

    /**
     * บอก Laravel ว่าฟิลด์รหัสผ่านชื่ออะไร (ของเราชื่อ Password)
     */
    public function getAuthPassword()
    {
        return $this->Password;
    }

    // -----------------------
    // Relationships
    // -----------------------
    public function agency()
    {
        return $this->belongsTo(Agency::class, 'Agency_ID');
    }

    public function agencies()
    {
        return $this->belongsToMany(Agency::class, 'agency_customer', 'Customer_ID', 'Agency_ID');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'user_id', 'Customer_ID');
    }

    public function assessments()
    {
        return $this->hasMany(Assessment::class, 'user_id', 'Customer_ID');
    }

    // -----------------------
    // Accessors (aliases)
    // -----------------------
    public function getNameAttribute()
    {
        return $this->attributes['Customer_Name'] ?? null;
    }

    public function getRoleAttribute()
    {
        return $this->attributes['Level'] ?? null;
    }

    public function getCompanyIdAttribute()
    {
        return $this->attributes['Agency_ID'] ?? null;
    }

    // -----------------------
    // Mutators (aliases)
    // -----------------------
    public function setNameAttribute($value)
    {
        $this->attributes['Customer_Name'] = $value;
    }

    public function setRoleAttribute($value)
    {
        $this->attributes['Level'] = $value;
    }

    public function setCompanyIdAttribute($value)
    {
        $this->attributes['Agency_ID'] = $value;
    }
}
