<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== ตรวจสอบ Foreign Key Constraints ทั้งหมด ===\n\n";

try {
    // ตรวจสอบ foreign key constraints ทั้งหมด
    $foreignKeys = DB::select("
        SELECT 
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME,
            REFERENCED_TABLE_NAME,
            REFERENCED_COLUMN_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND REFERENCED_TABLE_NAME IS NOT NULL
        ORDER BY TABLE_NAME, COLUMN_NAME
    ");

    if (empty($foreignKeys)) {
        echo "ไม่พบ foreign key constraints ใดๆ\n";
    } else {
        echo "พบ Foreign Key Constraints ดังนี้:\n";
        echo str_repeat("-", 80) . "\n";
        printf("%-20s %-20s %-30s %-20s %-20s\n", 
               "TABLE_NAME", "COLUMN_NAME", "CONSTRAINT_NAME", "REFERENCED_TABLE", "REFERENCED_COLUMN");
        echo str_repeat("-", 80) . "\n";
        
        foreach ($foreignKeys as $fk) {
            printf("%-20s %-20s %-30s %-20s %-20s\n", 
                   $fk->TABLE_NAME, 
                   $fk->COLUMN_NAME, 
                   $fk->CONSTRAINT_NAME, 
                   $fk->REFERENCED_TABLE_NAME, 
                   $fk->REFERENCED_COLUMN_NAME);
        }
    }

    echo "\n=== ตรวจสอบ Foreign Keys ที่อ้างอิง users และ companies ===\n\n";
    
    // ตรวจสอบ foreign keys ที่อ้างอิง users
    $usersFK = DB::select("
        SELECT 
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND REFERENCED_TABLE_NAME = 'users'
        ORDER BY TABLE_NAME, COLUMN_NAME
    ");

    if (!empty($usersFK)) {
        echo "Foreign Keys ที่อ้างอิงตาราง 'users':\n";
        foreach ($usersFK as $fk) {
            echo "- {$fk->TABLE_NAME}.{$fk->COLUMN_NAME} (constraint: {$fk->CONSTRAINT_NAME})\n";
        }
    } else {
        echo "ไม่พบ foreign keys ที่อ้างอิงตาราง 'users'\n";
    }

    echo "\n";
    
    // ตรวจสอบ foreign keys ที่อ้างอิง companies
    $companiesFK = DB::select("
        SELECT 
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND REFERENCED_TABLE_NAME = 'companies'
        ORDER BY TABLE_NAME, COLUMN_NAME
    ");

    if (!empty($companiesFK)) {
        echo "Foreign Keys ที่อ้างอิงตาราง 'companies':\n";
        foreach ($companiesFK as $fk) {
            echo "- {$fk->TABLE_NAME}.{$fk->COLUMN_NAME} (constraint: {$fk->CONSTRAINT_NAME})\n";
        }
    } else {
        echo "ไม่พบ foreign keys ที่อ้างอิงตาราง 'companies'\n";
    }

    echo "\n=== ตรวจสอบ Foreign Keys ที่อ้างอิง customer และ agency ===\n\n";
    
    // ตรวจสอบ foreign keys ที่อ้างอิง customer
    $customerFK = DB::select("
        SELECT 
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND REFERENCED_TABLE_NAME = 'customer'
        ORDER BY TABLE_NAME, COLUMN_NAME
    ");

    if (!empty($customerFK)) {
        echo "Foreign Keys ที่อ้างอิงตาราง 'customer':\n";
        foreach ($customerFK as $fk) {
            echo "- {$fk->TABLE_NAME}.{$fk->COLUMN_NAME} (constraint: {$fk->CONSTRAINT_NAME})\n";
        }
    } else {
        echo "ไม่พบ foreign keys ที่อ้างอิงตาราง 'customer'\n";
    }

    echo "\n";
    
    // ตรวจสอบ foreign keys ที่อ้างอิง agency
    $agencyFK = DB::select("
        SELECT 
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND REFERENCED_TABLE_NAME = 'agency'
        ORDER BY TABLE_NAME, COLUMN_NAME
    ");

    if (!empty($agencyFK)) {
        echo "Foreign Keys ที่อ้างอิงตาราง 'agency':\n";
        foreach ($agencyFK as $fk) {
            echo "- {$fk->TABLE_NAME}.{$fk->COLUMN_NAME} (constraint: {$fk->CONSTRAINT_NAME})\n";
        }
    } else {
        echo "ไม่พบ foreign keys ที่อ้างอิงตาราง 'agency'\n";
    }

} catch (Exception $e) {
    echo "เกิดข้อผิดพลาด: " . $e->getMessage() . "\n";
}

echo "\n=== เสร็จสิ้นการตรวจสอบ ===\n"; 