@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-tachometer-alt me-2"></i>
                        Admin Dashboard
                    </h1>
                    <p class="text-muted mb-0">ภาพรวมระบบและการจัดการ</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.users') }}" class="btn btn-outline-primary">
                        <i class="fas fa-users me-1"></i>
                        จัดการผู้ใช้
                    </a>
                    <a href="{{ route('admin.products') }}" class="btn btn-outline-success">
                        <i class="fas fa-boxes me-1"></i>
                        จัดการผลิตภัณฑ์
                    </a>
                    {{-- <a href="{{ route('admin.reports') }}" class="btn btn-outline-info">
                        <i class="fas fa-chart-bar me-1"></i>
                        รายงาน
                    </a> --}}
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                ผู้ใช้ทั้งหมด
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_users']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                ผลิตภัณฑ์ทั้งหมด
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_products']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-boxes fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                การประเมินทั้งหมด
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_assessments']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                ผู้ดูแลระบบ
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['admin_users']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filter Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-search me-2"></i>
                ค้นหาและกรองข้อมูล
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.dashboard') }}" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">ประเภทผลิตภัณฑ์</label>
                    <select name="product_type" class="form-select">
                        <option value="">ทั้งหมด</option>
                        <option value="hw_sw_log_server" {{ request('product_type') == 'hw_sw_log_server' ? 'selected' : '' }}>
                            Hardware + Software Log Server
                        </option>
                        <option value="sw_log_server" {{ request('product_type') == 'sw_log_server' ? 'selected' : '' }}>
                            Software Log Server
                        </option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">บริษัท</label>
                    <select name="agency_id" class="form-select">
                        <option value="">ทั้งหมด</option>
                        @foreach($agencies as $agency)
                            <option value="{{ $agency->Agency_ID }}" {{ request('agency_id') == $agency->Agency_ID ? 'selected' : '' }}>
                                {{ $agency->Agency_Name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">ชื่อลูกค้า</label>
                    <input type="text" name="customer_name" class="form-control" 
                           value="{{ request('customer_name') }}" 
                           placeholder="ค้นหาชื่อลูกค้า">
                </div>
                <div class="col-md-3">
                    <label class="form-label">ชื่อผลิตภัณฑ์/รุ่น</label>
                    <input type="text" name="product_name" class="form-control" 
                           value="{{ request('product_name') }}" 
                           placeholder="ค้นหาชื่อผลิตภัณฑ์หรือรุ่น">
                </div>
                <div class="col-12">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i>
                            ค้นหา
                        </button>
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-1"></i>
                            ล้างตัวกรอง
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Products List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-boxes me-2"></i>
                รายการผลิตภัณฑ์ทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info">{{ $products->total() }} รายการ</span>
            </div>
        </div>
        <div class="card-body p-0">
            @if($products->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th class="text-center">ชื่อผลิตภัณฑ์</th>
                                <th class="text-center">รุ่น</th>
                                <th class="text-center">ประเภท</th>
                                <th class="text-center">วิธีรับข้อมูล</th>
                                <th class="text-center">บริษัท</th>
                                <th class="text-center">วันที่สร้าง</th>
                                <th class="text-center">ชื่อลูกค้า</th>
                                <th class="text-center" style="width: 150px;">รายงานผล/จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $index => $product)
                            <tr class="clickable-row" data-product-id="{{ $product->id }}" style="cursor: pointer;">
                                <td class="text-center text-muted">{{ $index + 1 + (($products->currentPage() - 1) * $products->perPage()) }}</td>
                                <td class="text-center">
                                    <strong>{{ $product->name }}</strong>
                                    @if($product->description)
                                        <br><small class="text-muted">{{ Str::limit($product->description, 50) }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($product->model)
                                        <span class="badge bg-secondary">{{ $product->model }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-info">{{ $product->product_type_label }}</span>
                                </td>
                                <td class="text-center">
                                    <small>{{ $product->log_receive_method_label }}</small>
                                </td>
                                <td class="text-center">
                                    @if($product->user && $product->user->agency)
                                        <div class="d-flex align-items-center justify-content-center">
                                            <i class="fas fa-building me-1 text-muted"></i>
                                            <span>{{ $product->user->agency->Agency_Name }}</span>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <i class="fas fa-calendar-alt me-1 text-muted"></i>
                                    {{ $product->DtmIns->format('d/m/Y') }}
                                </td>
                                <td class="text-center">
                                    @if($product->user)
                                        <div class="d-flex align-items-center justify-content-center">
                                            <i class="fas fa-user me-1 text-muted"></i>
                                            <span>{{ $product->user->Customer_Name }}</span>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($product->user)
                                        <div class="d-flex align-items-center justify-content-center gap-2">
                                            <a href="{{ route('admin.products.report', $product->id) }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-chart-bar me-1"></i>
                                                ดูรายงาน
                                            </a>
                                            <a href="{{ route('admin.products.edit', $product->id) }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="แก้ไข">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" 
                                                    class="btn btn-sm btn-outline-danger delete-btn" 
                                                    data-product-id="{{ $product->id }}"
                                                    data-product-name="{{ $product->name }}"
                                                    title="ลบ">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center py-3">
                    {{ $products->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                    <h4 class="text-muted">ไม่พบข้อมูลผลิตภัณฑ์</h4>
                    <p class="text-muted">ลองปรับเปลี่ยนเงื่อนไขการค้นหา</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">ยืนยันการลบ</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>คุณต้องการลบข้อมูลผลิตภัณฑ์ "<span id="productName"></span>" และผลการประเมินนี้หรือไม่?</p>
                <p class="text-danger"><small>การดำเนินการนี้ไม่สามารถยกเลิกได้</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">ลบ</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.clickable-row {
  cursor: pointer;
  transition: all 0.2s ease;
}

.clickable-row:hover {
  background-color: #f8f9fa !important;
  transform: translateY(-1px);
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.clickable-row td {
  border-color: #dee2e6;
  transition: border-color 0.2s ease;
}

.clickable-row:hover td {
  border-color: #adb5bd;
}

.clickable-row:active {
  transform: translateY(0);
  box-shadow: 0 1px 2px rgba(0,0,0,0.1);
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete confirmation
    const deleteButtons = document.querySelectorAll('.delete-btn');
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    const deleteForm = document.getElementById('deleteForm');
    const productNameSpan = document.getElementById('productName');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function() {
            const productId = this.getAttribute('data-product-id');
            const productName = this.getAttribute('data-product-name');
            
            productNameSpan.textContent = productName;
            deleteForm.action = `/admin/products/${productId}`;
            deleteModal.show();
        });
    });

    // จัดการการคลิกแถวในตาราง
    const clickableRows = document.querySelectorAll('.clickable-row');
    clickableRows.forEach(row => {
        row.addEventListener('click', function(e) {
            // ตรวจสอบว่าคลิกที่ปุ่มหรือลิงก์หรือไม่
            if (e.target.tagName === 'BUTTON' || 
                e.target.tagName === 'A' || 
                e.target.closest('button') || 
                e.target.closest('a') ||
                e.target.closest('form')) {
                return; // ไม่ทำอะไรถ้าคลิกที่ปุ่มหรือลิงก์
            }
            
            // นำทางไปยังหน้ารายงาน
            const productId = this.getAttribute('data-product-id');
            if (productId) {
                window.location.href = `{{ route('admin.products.report', ['product' => ':id']) }}`.replace(':id', productId);
            }
        });
    });
});
</script>
@endsection 