@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-boxes me-2"></i>
                        จัดการผลิตภัณฑ์
                    </h1>
                    <p class="text-muted mb-0">ดูและจัดการผลิตภัณฑ์ทั้งหมดในระบบ</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
                        กลับไป Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Products List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-boxes me-2"></i>
                รายการผลิตภัณฑ์ทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info">{{ $products->total() }} รายการ</span>
            </div>
        </div>
        <div class="card-body p-0">
            @if($products->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th>ชื่อผลิตภัณฑ์</th>
                                <th>รุ่น</th>
                                <th>ประเภท</th>
                                <th>วิธีรับข้อมูล</th>
                                <th>บริษัท</th>
                                <th>ผู้สร้าง</th>
                                <th>วันที่สร้าง</th>
                                <th class="text-center" style="width: 150px;">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $index => $product)
                            <tr>
                                <td class="text-center">{{ $products->firstItem() + $index }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}" 
                                                 alt="{{ $product->name }}" 
                                                 class="rounded me-2" 
                                                 style="width: 40px; height: 40px; object-fit: cover;">
                                        @else
                                            <div class="bg-light rounded d-flex align-items-center justify-content-center me-2" 
                                                 style="width: 40px; height: 40px;">
                                                <i class="fas fa-box text-muted"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <div class="fw-bold">{{ $product->name }}</div>
                                            <small class="text-muted">ID: {{ $product->id }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $product->model ?: '-' }}</td>
                                <td>
                                    @if($product->product_type == 'hw_sw_log_server')
                                        <span class="badge bg-primary">Hardware + Software</span>
                                    @else
                                        <span class="badge bg-success">Software Only</span>
                                    @endif
                                </td>
                                <td>
                                    @switch($product->log_receive_method)
                                        @case('syslog_udp')
                                            <span class="badge bg-info">Syslog UDP</span>
                                            @break
                                        @case('syslog_tcp')
                                            <span class="badge bg-warning">Syslog TCP</span>
                                            @break
                                        @case('syslog_both')
                                            <span class="badge bg-danger">Syslog Both</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">Other</span>
                                    @endswitch
                                </td>
                                <td>
                                    @if($product->user && $product->user->agency)
                                        <span class="badge bg-success">{{ $product->user->agency->Agency_Name }}</span>
                                    @else
                                        <span class="badge bg-secondary">ไม่ระบุ</span>
                                    @endif
                                </td>
                                <td>
                                    @if($product->user)
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-user-circle fa-lg text-gray-400 me-2"></i>
                                            <div>
                                                <div class="fw-bold">{{ $product->user->Customer_Name }}</div>
                                                <small class="text-muted">{{ $product->user->Email }}</small>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted">ไม่ระบุ</span>
                                    @endif
                                </td>
                                <td>{{ $product->DtmIns ? $product->DtmIns->format('d/m/Y H:i') : '-' }}</td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.products.edit', $product->id) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ route('admin.products.report', $product->id) }}" 
                                           class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-chart-bar"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger"
                                                data-product-id="{{ $product->id }}"
                                                onclick="deleteProduct(this.dataset.productId)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="card-footer">
                    {{ $products->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-boxes fa-3x text-gray-300 mb-3"></i>
                    <h5 class="text-gray-500">ไม่พบข้อมูลผลิตภัณฑ์</h5>
                    <p class="text-muted">ยังไม่มีผลิตภัณฑ์ในระบบ</p>
                </div>
            @endif
        </div>
    </div>
</div>

<script>
function deleteProduct(productId) {
    if (confirm('คุณต้องการลบผลิตภัณฑ์นี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้')) {
        // ส่ง AJAX request เพื่อลบผลิตภัณฑ์
        fetch(`/admin/products/${productId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                alert(data.message);
                location.reload();
            } else {
                alert(data.message || 'เกิดข้อผิดพลาดในการลบผลิตภัณฑ์');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('เกิดข้อผิดพลาดในการลบผลิตภัณฑ์: ' + error.message);
        });
    }
}
</script>
@endsection 