@extends('layouts.admin')

@section('content')
<div class="container-fluid px-4 py-4">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-edit me-2"></i>
            แก้ไขกลุ่มคำถาม: {{ $group->name }}
        </h1>
        <div class="d-flex gap-2">
            <!-- ปุ่มพับ/กางทั้งหมด -->
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-outline-secondary btn-sm" id="collapse-all-btn" title="พับคำถามย่อยทั้งหมด">
                    <i class="fas fa-chevron-up me-1"></i>
                    พับทั้งหมด
                </button>
                <button type="button" class="btn btn-outline-secondary btn-sm" id="expand-all-btn" title="กางคำถามย่อยทั้งหมด">
                    <i class="fas fa-chevron-down me-1"></i>
                    กางทั้งหมด
                </button>
            </div>
            
            <a href="{{ route('admin.questions.create', $group) }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i>
                เพิ่มคำถาม
            </a>
            <a href="{{ route('admin.question-groups') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left me-1"></i>
                กลับไปรายการ
            </a>
        </div>
    </div>

    <!-- แจ้งเตือนแอดมิน -->
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <div class="d-flex align-items-center">
            <i class="fas fa-exclamation-triangle me-3 fa-lg text-warning"></i>
            <div>
                <h6 class="alert-heading mb-1">
                    <i class="fas fa-lightbulb me-1"></i>
                    คำแนะนำสำคัญสำหรับแอดมิน
                </h6>
                <p class="mb-0">
                    <strong>หลังจากแก้ไขกลุ่มคำถามหรือกำหนดคำถามแล้ว กรุณาทดสอบการทำงานแบบประเมินทุกครั้ง</strong> เพื่อลดข้อผิดพลาดสำหรับผลการประเมิน
                </p>
                <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>
                    การทดสอบจะช่วยให้มั่นใจว่าระบบทำงานได้ถูกต้องก่อนนำไปใช้งานจริง
                </small>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismissible="alert" aria-label="Close"></button>
    </div>

    <!-- Edit Question Group Form -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-folder-edit me-2"></i>
                ข้อมูลกลุ่มคำถาม
            </h6>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.question-groups.update', $group) }}">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="name" class="form-label">ชื่อกลุ่มคำถาม <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('name') is-invalid @enderror" 
                                   id="name" 
                                   name="name" 
                                   value="{{ old('name', $group->name) }}" 
                                   placeholder="กรอกชื่อกลุ่มคำถาม"
                                   required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">คำอธิบาย</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="4" 
                                      placeholder="กรอกคำอธิบายเกี่ยวกับกลุ่มคำถามนี้">{{ old('description', $group->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $group->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    <strong>เปิดใช้งานในแบบประเมิน</strong>
                                </label>
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    กลุ่มคำถามนี้จะแสดงในแบบประเมินสำหรับผู้ใช้ทั่วไป
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-info-circle me-1"></i>
                                    ข้อมูลเพิ่มเติม
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-question-circle me-1"></i>
                                        จำนวนคำถาม: {{ $questions->count() }} คำถาม
                                    </small>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-calendar me-1"></i>
                                        สร้างเมื่อ: {{ $group->DtmIns->format('d/m/Y H:i') }}
                                    </small>
                                </div>
                                <div class="mb-0">
                                    <small class="text-muted">
                                        <i class="fas fa-arrows-alt me-1"></i>
                                        ลากเพื่อจัดลำดับคำถาม
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>
                        บันทึกการเปลี่ยนแปลง
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Questions List with Drag & Drop -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>
                รายการคำถาม (ลากเพื่อจัดลำดับ)
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info">{{ $questions->count() }} คำถาม</span>
            </div>
        </div>
        
        <!-- คำแนะนำสำหรับการสร้างคำถามย่อย -->
        <div class="card-body bg-light border-bottom">
            <div class="alert alert-info mb-0">
                <i class="fas fa-lightbulb me-2"></i>
                <strong>คำแนะนำ:</strong> 
                <ul class="mb-0 mt-2">
                    <li><strong>การลากคำถามเพื่อสร้างความสัมพันธ์:</strong> ลากคำถามไปวางใต้คำถามอื่นเพื่อสร้างคำถามย่อย</li>
                    <li><strong>Drop Zone จะปรากฏเฉพาะเมื่อลาก:</strong> เมื่อลากคำถาม drop zone จะแสดงขึ้นมาให้เห็น</li>
                    <li><strong>รองรับการสร้างคำถามย่อยหลายระดับ:</strong> คำถาม 1 → 1.1 → 1.1.1 → 1.1.1.1</li>
                    <li>คำถามย่อยจะแสดงตัวเลือก Logic AND/OR เฉพาะเมื่อคำถามแม่มีคำถามย่อยแล้วเท่านั้น</li>
                    <li>แต่ละระดับจะแสดง badge "Level" เพื่อระบุระดับความลึก</li>
                    <li>ใช้ไอคอน grip (⋮⋮) เพื่อลากคำถาม</li>
                </ul>
            </div>
        </div>
        
        <div class="card-body p-0">
            @if($questions->count() > 0)
                <div id="questions-container" class="p-3">
                    @foreach($questions as $question)
                        @include('admin.question-groups.partials.question-item', ['question' => $question, 'level' => 0])
                    @endforeach
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                    <h4 class="text-muted">ไม่พบคำถาม</h4>
                    <p class="text-muted">เริ่มต้นด้วยการเพิ่มคำถามใหม่</p>
                    <a href="{{ route('admin.questions.create', $group) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>
                        เพิ่มคำถามแรก
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Question Confirmation Modal -->
<div class="modal fade" id="deleteQuestionModal" tabindex="-1" aria-labelledby="deleteQuestionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteQuestionModalLabel">ยืนยันการลบ</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>คุณต้องการลบคำถาม "<span id="questionText"></span>" หรือไม่?</p>
                <p class="text-danger"><small>การดำเนินการนี้ไม่สามารถยกเลิกได้</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                <form id="deleteQuestionForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">ลบ</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
/* Override Tailwind conflicts with Bootstrap */
.container-fluid {
    max-width: 100%;
    margin: 0 auto;
}

.d-flex {
    display: flex !important;
}

.align-items-center {
    align-items: center !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.justify-content-end {
    justify-content: flex-end !important;
}

.gap-2 {
    gap: 0.5rem !important;
}

.mb-4 {
    margin-bottom: 1.5rem !important;
}

.mb-3 {
    margin-bottom: 1rem !important;
}

.mb-2 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.me-2 {
    margin-right: 0.5rem !important;
}

.me-1 {
    margin-right: 0.25rem !important;
}

.ms-2 {
    margin-left: 0.5rem !important;
}

.mt-2 {
    margin-top: 0.5rem !important;
}

.py-4 {
    padding-top: 1.5rem !important;
    padding-bottom: 1.5rem !important;
}

.py-3 {
    padding-top: 1rem !important;
    padding-bottom: 1rem !important;
}

.px-4 {
    padding-left: 1.5rem !important;
    padding-right: 1.5rem !important;
}

.p-3 {
    padding: 1rem !important;
}

.p-0 {
    padding: 0 !important;
}

.text-muted {
    color: #6c757d !important;
}

.text-danger {
    color: #dc3545 !important;
}

.text-primary {
    color: #0d6efd !important;
}

.bg-light {
    background-color: #f8f9fa !important;
}

.border-bottom {
    border-bottom: 1px solid #dee2e6 !important;
}

.question-item {
    transition: all 0.3s ease;
}

.question-item.dragging {
    opacity: 0.5;
    transform: rotate(2deg);
}

.question-card {
    transition: all 0.2s ease;
}

.question-card:hover {
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.drag-handle {
    cursor: grab;
    transition: color 0.2s ease;
}

.drag-handle:hover {
    color: #007bff !important;
}

.drag-handle:active {
    cursor: grabbing;
}

.child-questions {
    border-left: 2px solid #e9ecef;
    padding-left: 1rem;
    min-height: 20px;
    transition: all 0.3s ease;
    margin-top: 0.5rem;
}

.child-questions.sortable-ghost {
    background-color: #e3f2fd;
    border: 2px dashed #2196f3;
    border-radius: 4px;
    padding: 1rem;
}

.child-questions.sortable-chosen {
    background-color: #fff3cd;
    border: 2px dashed #ffc107;
    border-radius: 4px;
    padding: 1rem;
}

.drop-zone-indicator {
    transition: all 0.3s ease;
    border: 2px dashed #dee2e6 !important;
    background-color: transparent !important;
    border-radius: 4px;
    min-height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0.5rem 0;
}

.drop-zone-indicator:hover {
    border-color: #007bff !important;
    background-color: #f8f9fa !important;
}

.drop-zone-indicator.active {
    border-color: #007bff !important;
    background-color: #e3f2fd !important;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
    animation: pulse 1s infinite;
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(0, 123, 255, 0.7);
    }
    70% {
        box-shadow: 0 0 0 10px rgba(0, 123, 255, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(0, 123, 255, 0);
    }
}

/* Visual feedback for drag and drop */
.sortable-ghost .question-card {
    opacity: 0.3;
}

.sortable-chosen .question-card {
    box-shadow: 0 0 0 2px #007bff;
}

/* Highlight drop zones when dragging */
.dragging .drop-zone-indicator {
    border-color: #007bff !important;
    background-color: #e3f2fd !important;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
}

/* Better visual separation for nested questions */
.question-item .question-item {
    margin-top: 0.5rem;
}

/* Clear visual hierarchy */
.question-card.border-start {
    border-left-width: 3px !important;
    border-left-color: #007bff !important;
}

/* Move buttons styling */
.move-up-btn, .move-down-btn {
    transition: all 0.2s ease;
}

.move-up-btn:hover, .move-down-btn:hover {
    background-color: #007bff !important;
    border-color: #007bff !important;
    color: white !important;
}

.move-up-btn:disabled, .move-down-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

/* Button group styling */
.btn-group-sm .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
}

/* Collapse toggle button styling */
.collapse-toggle-btn {
    transition: all 0.2s ease;
    border: none;
    background: transparent;
    padding: 0.25rem 0.5rem;
}

.collapse-toggle-btn:hover {
    background-color: #e9ecef !important;
    border-color: #dee2e6 !important;
}

.collapse-toggle-btn:focus {
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.collapse-icon {
    transition: transform 0.2s ease;
}

/* Child questions container */
.child-questions {
    transition: all 0.3s ease;
}

.child-questions.collapsed {
    display: none;
}

/* Visual feedback for collapsed state */
.question-card.collapsed {
    border-left-color: #ffc107 !important;
}

.question-card.collapsed .collapse-toggle-btn {
    color: #ffc107;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Initializing drag and drop functionality...');
    
    // Initialize Sortable for questions with parent-child relationship only
    const questionsContainer = document.getElementById('questions-container');
    if (questionsContainer) {
        console.log('Found questions container, initializing main sortable...');
        
        // Initialize main container
        const mainSortable = new Sortable(questionsContainer, {
            animation: 150,
            handle: '.drag-handle',
            ghostClass: 'dragging',
            group: {
                name: 'questions',
                pull: true,
                put: true
            },
            onStart: function(evt) {
                console.log('Main drag started:', evt.item);
                showDropZones();
            },
            onEnd: function(evt) {
                console.log('Main drag ended:', evt.item);
                hideDropZones();
                updateQuestionParent();
            },
            onMove: function(evt) {
                console.log('Main move event:', evt);
                const draggedItem = evt.dragged;
                const targetItem = evt.related;
                
                if (draggedItem === targetItem || isDescendant(draggedItem, targetItem)) {
                    console.log('Invalid move: cannot drop on self or descendant');
                    return false;
                }
                
                return true;
            },
            onAdd: function(evt) {
                console.log('Item added to main container:', evt);
            }
        });

        // Initialize child containers
        initializeChildContainers();
        
        // Function to reinitialize child containers after DOM changes
        function initializeChildContainers() {
            const childContainers = document.querySelectorAll('.child-questions');
            console.log('Found child containers:', childContainers.length);
            
            childContainers.forEach((container, index) => {
                console.log(`Initializing child container ${index}:`, container);
                
                // Destroy existing Sortable instance if exists
                if (container.sortable) {
                    container.sortable.destroy();
                }
                
                // Create new Sortable instance
                container.sortable = new Sortable(container, {
                    animation: 150,
                    handle: '.drag-handle',
                    ghostClass: 'dragging',
                    group: {
                        name: 'questions',
                        pull: true,
                        put: true
                    },
                    onStart: function(evt) {
                        console.log('Child drag started:', evt.item);
                        showDropZones();
                    },
                    onEnd: function(evt) {
                        console.log('Child drag ended:', evt.item);
                        hideDropZones();
                        updateQuestionParent();
                    },
                    onMove: function(evt) {
                        console.log('Child move event:', evt);
                        const draggedItem = evt.dragged;
                        const targetItem = evt.related;
                        
                        if (draggedItem === targetItem || isDescendant(draggedItem, targetItem)) {
                            console.log('Invalid child move: cannot drop on self or descendant');
                            return false;
                        }
                        
                        return true;
                    },
                    onAdd: function(evt) {
                        console.log('Item added to child container:', evt);
                        // Reinitialize child containers after adding new items
                        setTimeout(() => {
                            initializeChildContainers();
                        }, 100);
                    }
                });
            });
        }
    } else {
        console.error('Questions container not found!');
    }

    // แสดง drop zones เฉพาะเมื่อลาก
    function showDropZones() {
        const dropZones = document.querySelectorAll('.drop-zone-indicator');
        dropZones.forEach(zone => {
            zone.style.display = 'block';
            zone.classList.add('active');
        });
    }

    // ซ่อน drop zones
    function hideDropZones() {
        const dropZones = document.querySelectorAll('.drop-zone-indicator');
        dropZones.forEach(zone => {
            zone.style.display = 'none';
            zone.classList.remove('active');
        });
    }

    // ตรวจสอบว่า element เป็น descendant ของอีก element หรือไม่
    function isDescendant(parent, child) {
        let current = child.parentElement;
        while (current) {
            if (current === parent) {
                return true;
            }
            current = current.parentElement;
        }
        return false;
    }

    // อัปเดต parent-child relationship หลังจากลาก
    function updateQuestionParent() {
        try {
            const questions = [];
            const questionItems = document.querySelectorAll('.question-item');
            
            questionItems.forEach((item, index) => {
                const questionId = item.getAttribute('data-question-id');
                let parentId = null;
                
                // หา parent โดยตรวจสอบว่า item นี้อยู่ใน child-questions container หรือไม่
                const parentContainer = item.closest('.child-questions');
                if (parentContainer) {
                    const parentItem = parentContainer.closest('.question-item');
                    if (parentItem) {
                        parentId = parentItem.getAttribute('data-question-id');
                    }
                }
                
                questions.push({
                    id: questionId,
                    parent_id: parentId
                });
            });

            console.log('Sending data:', questions);

            // ส่ง AJAX request เพื่ออัปเดต parent-child relationship
            fetch('{{ route("admin.questions.update-order") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                },
                body: JSON.stringify({ questions: questions })
            })
            .then(response => {
                console.log('Response status:', response.status);
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                console.log('Response data:', data);
                if (data.success) {
                    // แสดงข้อความสำเร็จ
                    const alert = document.createElement('div');
                    alert.className = 'alert alert-success alert-dismissible fade show';
                    alert.innerHTML = `
                        <i class="fas fa-check-circle me-2"></i>
                        อัปเดตความสัมพันธ์คำถามเรียบร้อยแล้ว
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    `;
                    document.querySelector('main').insertBefore(alert, document.querySelector('main').firstChild);
                    
                    // Auto dismiss หลังจาก 3 วินาที
                    setTimeout(() => {
                        alert.remove();
                    }, 3000);
                    
                    // Reload หน้าเพื่อแสดงโครงสร้างใหม่
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                } else {
                    throw new Error(data.message || 'เกิดข้อผิดพลาด');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('เกิดข้อผิดพลาดในการอัปเดตความสัมพันธ์คำถาม: ' + error.message);
            });
        } catch (error) {
            console.error('Error in updateQuestionParent:', error);
            alert('เกิดข้อผิดพลาดในการอัปเดตความสัมพันธ์คำถาม: ' + error.message);
        }
    }

    // Delete question confirmation
    const deleteButtons = document.querySelectorAll('.delete-question-btn');
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteQuestionModal'));
    const deleteForm = document.getElementById('deleteQuestionForm');
    const questionTextSpan = document.getElementById('questionText');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function() {
            const questionId = this.getAttribute('data-question-id');
            const questionText = this.getAttribute('data-question-text');
            
            questionTextSpan.textContent = questionText;
            deleteForm.action = `/admin/questions/${questionId}`;
            deleteModal.show();
        });
    });

    // Logic operator update
    const updateLogicButtons = document.querySelectorAll('.update-logic-btn');
    updateLogicButtons.forEach(button => {
        button.addEventListener('click', function() {
            const questionId = this.getAttribute('data-question-id');
            const logicSelector = document.querySelector(`.logic-selector[data-question-id="${questionId}"]`);
            const logicDisplay = document.getElementById(`logic-display-${questionId}`);
            const newLogic = logicSelector.value;
            
            // Disable button during update
            this.disabled = true;
            this.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>กำลังบันทึก...';
            
            // Send AJAX request
            fetch(`/admin/questions/${questionId}/update-logic`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                },
                body: JSON.stringify({ logic_operator: newLogic })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update badge display in real-time
                    logicDisplay.textContent = newLogic;
                    
                    // Update badge class based on logic operator
                    logicDisplay.className = `badge ms-2 ${newLogic === 'AND' ? 'bg-info' : 'bg-warning'}`;
                    
                    // Add visual feedback with animation
                    logicDisplay.style.transform = 'scale(1.1)';
                    logicDisplay.style.transition = 'transform 0.2s ease-in-out';
                    
                    setTimeout(() => {
                        logicDisplay.style.transform = 'scale(1)';
                    }, 200);
                    
                    // Show success message
                    const alert = document.createElement('div');
                    alert.className = 'alert alert-success alert-dismissible fade show';
                    alert.innerHTML = `
                        <i class="fas fa-check-circle me-2"></i>
                        อัปเดตเงื่อนไขการเชื่อมต่อเรียบร้อยแล้ว
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    `;
                    document.querySelector('main').insertBefore(alert, document.querySelector('main').firstChild);
                    
                    // Auto dismiss after 3 seconds
                    setTimeout(() => {
                        alert.remove();
                    }, 3000);
                } else {
                    throw new Error(data.message || 'เกิดข้อผิดพลาด');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('เกิดข้อผิดพลาดในการอัปเดตเงื่อนไขการเชื่อมต่อ');
            })
            .finally(() => {
                // Re-enable button
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-save me-1"></i>บันทึก';
            });
        });
    });

    // Move question up/down functionality
    const moveUpButtons = document.querySelectorAll('.move-up-btn');
    const moveDownButtons = document.querySelectorAll('.move-down-btn');

    moveUpButtons.forEach(button => {
        button.addEventListener('click', function() {
            const questionId = this.getAttribute('data-question-id');
            moveQuestion(questionId, 'up');
        });
    });

    moveDownButtons.forEach(button => {
        button.addEventListener('click', function() {
            const questionId = this.getAttribute('data-question-id');
            moveQuestion(questionId, 'down');
        });
    });

    // Collapse/Expand functionality with localStorage persistence
    const collapseToggleButtons = document.querySelectorAll('.collapse-toggle-btn');
    
    // ฟังก์ชันสำหรับจัดการ localStorage
    const COLLAPSE_STATE_KEY = 'question_collapse_states';
    
    function getCollapseStates() {
        const states = localStorage.getItem(COLLAPSE_STATE_KEY);
        return states ? JSON.parse(states) : {};
    }
    
    function saveCollapseState(questionId, isCollapsed) {
        const states = getCollapseStates();
        states[questionId] = isCollapsed;
        localStorage.setItem(COLLAPSE_STATE_KEY, JSON.stringify(states));
    }
    
    function isQuestionCollapsed(questionId) {
        const states = getCollapseStates();
        return states[questionId] === true;
    }
    
    // ตั้งค่าสถานะเริ่มต้นตาม localStorage
    collapseToggleButtons.forEach(button => {
        const questionId = button.getAttribute('data-question-id');
        const childQuestions = document.querySelector(`.child-questions[data-question-id="${questionId}"]`);
        const collapseIcon = button.querySelector('.collapse-icon');
        
        if (childQuestions && isQuestionCollapsed(questionId)) {
            // ถ้าคำถามนี้ถูกพับไว้ ให้พับไว้
            childQuestions.style.display = 'none';
            collapseIcon.className = 'fas fa-chevron-right collapse-icon';
            button.title = 'กางคำถามย่อย';
        } else if (childQuestions) {
            // ถ้าคำถามนี้ถูกกางไว้ ให้กางไว้
            childQuestions.style.display = 'block';
            collapseIcon.className = 'fas fa-chevron-down collapse-icon';
            button.title = 'พับคำถามย่อย';
        }
    });
    
    // เพิ่ม event listeners สำหรับปุ่มพับ/กาง
    collapseToggleButtons.forEach(button => {
        button.addEventListener('click', function() {
            const questionId = this.getAttribute('data-question-id');
            toggleCollapse(questionId, this);
        });
    });

    function toggleCollapse(questionId, button) {
        const childQuestions = document.querySelector(`.child-questions[data-question-id="${questionId}"]`);
        const collapseIcon = button.querySelector('.collapse-icon');
        
        if (childQuestions) {
            if (childQuestions.style.display === 'none') {
                // กางคำถามย่อย
                childQuestions.style.display = 'block';
                collapseIcon.className = 'fas fa-chevron-down collapse-icon';
                button.title = 'พับคำถามย่อย';
                saveCollapseState(questionId, false); // บันทึกสถานะว่าไม่ถูกพับ
            } else {
                // พับคำถามย่อย
                childQuestions.style.display = 'none';
                collapseIcon.className = 'fas fa-chevron-right collapse-icon';
                button.title = 'กางคำถามย่อย';
                saveCollapseState(questionId, true); // บันทึกสถานะว่าถูกพับ
            }
        }
    }

    function moveQuestion(questionId, direction) {
        // Disable button during update
        const button = event.target.closest('button');
        const originalContent = button.innerHTML;
        button.disabled = true;
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        // Send AJAX request
        fetch('/admin/questions/move', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            },
            body: JSON.stringify({ 
                question_id: questionId, 
                direction: direction 
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Reload page to show updated order
                location.reload();
            } else {
                throw new Error(data.message || 'เกิดข้อผิดพลาด');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('เกิดข้อผิดพลาดในการเปลี่ยนตำแหน่งคำถาม: ' + error.message);
        })
        .finally(() => {
            // Re-enable button
            button.disabled = false;
            button.innerHTML = originalContent;
        });
    }

    // Collapse/Expand all questions with localStorage
    const collapseAllBtn = document.getElementById('collapse-all-btn');
    const expandAllBtn = document.getElementById('expand-all-btn');

    collapseAllBtn.addEventListener('click', function() {
        const childQuestions = document.querySelectorAll('.child-questions');
        const states = {};
        
        childQuestions.forEach(container => {
            const questionId = container.getAttribute('data-question-id');
            if (container.style.display !== 'none') {
                container.style.display = 'none';
                const toggleBtn = container.closest('.question-item').querySelector('.collapse-toggle-btn');
                if (toggleBtn) {
                    toggleBtn.querySelector('.collapse-icon').className = 'fas fa-chevron-right collapse-icon';
                    toggleBtn.title = 'กางคำถามย่อย';
                    states[questionId] = true; // บันทึกสถานะว่าถูกพับ
                }
            } else {
                states[questionId] = true; // บันทึกสถานะว่าถูกพับ (อยู่แล้ว)
            }
        });
        
        // บันทึกสถานะทั้งหมด
        localStorage.setItem(COLLAPSE_STATE_KEY, JSON.stringify(states));
    });

    expandAllBtn.addEventListener('click', function() {
        const childQuestions = document.querySelectorAll('.child-questions');
        const states = {};
        
        childQuestions.forEach(container => {
            const questionId = container.getAttribute('data-question-id');
            if (container.style.display === 'none') {
                container.style.display = 'block';
                const toggleBtn = container.closest('.question-item').querySelector('.collapse-toggle-btn');
                if (toggleBtn) {
                    toggleBtn.querySelector('.collapse-icon').className = 'fas fa-chevron-down collapse-icon';
                    toggleBtn.title = 'พับคำถามย่อย';
                    states[questionId] = false; // บันทึกสถานะว่าไม่ถูกพับ
                }
            } else {
                states[questionId] = false; // บันทึกสถานะว่าไม่ถูกพับ (อยู่แล้ว)
            }
        });
        
        // บันทึกสถานะทั้งหมด
        localStorage.setItem(COLLAPSE_STATE_KEY, JSON.stringify(states));
    });
});
</script>
@endsection 