@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-users me-2"></i>
                        จัดการผู้ใช้
                    </h1>
                    <p class="text-muted mb-0">ดูและจัดการผู้ใช้ทั้งหมดในระบบ</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
                        กลับไป Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Users List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-users me-2"></i>
                รายการผู้ใช้ทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info">{{ $users->total() }} รายการ</span>
            </div>
        </div>
        <div class="card-body p-0">
            @if($users->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th>ชื่อผู้ใช้</th>
                                <th>อีเมล</th>
                                <th>เบอร์โทรศัพท์</th>
                                <th>ระดับ</th>
                                <th>บริษัท</th>
                                <th>สถานะ</th>
                                <th>วันที่ลงทะเบียน</th>
                                <th class="text-center" style="width: 120px;">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $index => $user)
                            <tr>
                                <td class="text-center">{{ $users->firstItem() + $index }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm me-2">
                                            <i class="fas fa-user-circle fa-2x text-gray-400"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold">{{ $user->Customer_Name }}</div>
                                            <small class="text-muted">ID: {{ $user->Customer_ID }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $user->Email }}</td>
                                <td>{{ $user->Mobile_Number }}</td>
                                <td>
                                    @if($user->Level == 'admin')
                                        <span class="badge bg-danger">Admin</span>
                                    @else
                                        <span class="badge bg-primary">Client</span>
                                    @endif
                                </td>
                                <td>
                                    @if($user->agency)
                                        <span class="badge bg-success">{{ $user->agency->Agency_Name }}</span>
                                    @else
                                        <span class="badge bg-secondary">ไม่มีบริษัท</span>
                                    @endif
                                </td>
                                <td>
                                    @if($user->On_Off_Customer == 'On')
                                        <span class="badge bg-success">เปิดใช้งาน</span>
                                    @else
                                        <span class="badge bg-danger">ปิดใช้งาน</span>
                                    @endif
                                </td>
                                <td>{{ $user->DtmIns ? $user->DtmIns->format('d/m/Y H:i') : '-' }}</td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-sm btn-outline-primary" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#userModal{{ $user->Customer_ID }}">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        @if($user->Level != 'admin')
                                        <button type="button" class="btn btn-sm btn-outline-warning"
                                                data-user-id="{{ $user->Customer_ID }}"
                                                onclick="toggleUserStatus(this.dataset.userId)">
                                            <i class="fas fa-toggle-on"></i>
                                        </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="card-footer">
                    {{ $users->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-users fa-3x text-gray-300 mb-3"></i>
                    <h5 class="text-gray-500">ไม่พบข้อมูลผู้ใช้</h5>
                    <p class="text-muted">ยังไม่มีผู้ใช้ในระบบ</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- User Detail Modals -->
@foreach($users as $user)
<div class="modal fade" id="userModal{{ $user->Customer_ID }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-user me-2"></i>
                    รายละเอียดผู้ใช้: {{ $user->Customer_Name }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="fw-bold">ข้อมูลส่วนตัว</h6>
                        <table class="table table-sm">
                            <tr>
                                <td><strong>ชื่อ:</strong></td>
                                <td>{{ $user->Customer_Name }}</td>
                            </tr>
                            <tr>
                                <td><strong>อีเมล:</strong></td>
                                <td>{{ $user->Email }}</td>
                            </tr>
                            <tr>
                                <td><strong>เบอร์โทรศัพท์:</strong></td>
                                <td>{{ $user->Mobile_Number }}</td>
                            </tr>
                            <tr>
                                <td><strong>ระดับ:</strong></td>
                                <td>
                                    @if($user->Level == 'admin')
                                        <span class="badge bg-danger">Admin</span>
                                    @else
                                        <span class="badge bg-primary">Client</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold">ข้อมูลบริษัท</h6>
                        @if($user->agency)
                        <table class="table table-sm">
                            <tr>
                                <td><strong>ชื่อบริษัท:</strong></td>
                                <td>{{ $user->agency->Agency_Name }}</td>
                            </tr>
                            <tr>
                                <td><strong>เลขประจำตัวผู้เสียภาษี:</strong></td>
                                <td>{{ $user->agency->Tax_ID }}</td>
                            </tr>
                            <tr>
                                <td><strong>ที่อยู่:</strong></td>
                                <td>{{ $user->agency->Address ?: 'ไม่ระบุ' }}</td>
                            </tr>
                            <tr>
                                <td><strong>สถานะ:</strong></td>
                                <td>
                                    @if($user->agency->active)
                                        <span class="badge bg-success">เปิดใช้งาน</span>
                                    @else
                                        <span class="badge bg-danger">ปิดใช้งาน</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                        @else
                        <p class="text-muted">ไม่มีข้อมูลบริษัท</p>
                        @endif
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-12">
                        <h6 class="fw-bold">สถิติการใช้งาน</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card bg-primary text-white">
                                    <div class="card-body text-center">
                                        <h4>{{ $user->products->count() }}</h4>
                                        <small>ผลิตภัณฑ์</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-success text-white">
                                    <div class="card-body text-center">
                                        <h4>{{ $user->assessments->count() }}</h4>
                                        <small>การประเมิน</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-info text-white">
                                    <div class="card-body text-center">
                                        <h4>{{ $user->DtmIns ? $user->DtmIns->diffForHumans() : '-' }}</h4>
                                        <small>เข้าร่วมระบบ</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ปิด</button>
            </div>
        </div>
    </div>
</div>
@endforeach

<script>
function toggleUserStatus(userId) {
    if (confirm('คุณต้องการเปลี่ยนสถานะผู้ใช้นี้หรือไม่?\n\nหมายเหตุ: หากปิดใช้งานบัญชี ผู้ใช้จะไม่สามารถเข้าสู่ระบบได้')) {
        // แสดง loading
        const button = event.target.closest('button');
        const originalContent = button.innerHTML;
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        button.disabled = true;

        // ส่ง AJAX request เพื่อเปลี่ยนสถานะ
        fetch(`/admin/users/${userId}/toggle-status`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // แสดงข้อความสำเร็จ
                alert(data.message);
                location.reload();
            } else {
                alert('เกิดข้อผิดพลาดในการเปลี่ยนสถานะ: ' + data.message);
                // คืนค่าปุ่ม
                button.innerHTML = originalContent;
                button.disabled = false;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('เกิดข้อผิดพลาดในการเปลี่ยนสถานะ');
            // คืนค่าปุ่ม
            button.innerHTML = originalContent;
            button.disabled = false;
        });
    }
}
</script>
@endsection 