<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/bootstrap.css', 'resources/js/app.js'])
        
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    </head>
    <body class="font-sans antialiased">
        <div class="min-vh-100 bg-light">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @if (isset($header))
                <header class="bg-white shadow-sm">
                    <div class="container py-4">
                        <h1 class="h3 mb-0 text-gray-800">{{ $header }}</h1>
                    </div>
                </header>
            @endif

            <!-- Page Content -->
            <main>
                @yield('content')
            </main>
        </div>
        <style>
        .question-number {
            font-weight: bold;
            color: #fff;
            font-size: 0.9rem;
            line-height: 1;
        }
        
        .parent-question-number {
            font-weight: bold;
            color: #495057;
            font-size: 0.9rem;
        }
        
        .child-question-number {
            font-weight: bold;
            color: #fff;
            font-size: 0.75rem;
            line-height: 1;
        }
        
        .question-label {
            font-weight: 600;
            color: #212529;
        }
        
        .question-number-inline {
            font-weight: bold;
            color: #0d6efd;
            margin-right: 0.5rem;
        }
    </style>
    </body>
</html>
