@php
    $hasChildren = $allQuestions->where('parent_id', $question->id)->whereNotNull('question_type')->count() > 0;
    $isAccordion = is_null($question->question_type) && $hasChildren;
@endphp

<div class="col-12 mb-4">
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="d-flex align-items-start">
                @if($question->question_type !== null)
                    <span class="badge bg-primary me-3 mt-1">{{ $globalQuestionNumber }}</span>
                @endif
                <div class="flex-grow-1">
                    <h6 class="card-title mb-3">{{ $question->question_text }}</h6>
                    
                    @if($question->question_type === 'yes_no')
                        <!-- คำถามแบบ ใช่/ไม่ใช่ -->
                        <div class="mb-3">
                            @php
                                $existingAnswer = isset($assessment) ? $assessment->answers->where('question_id', $question->id)->first() : null;
                                $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                            @endphp
                            
                            <div class="form-check form-check-inline">
                                <input class="form-check-input yes-no-radio" type="radio" 
                                       name="answers[{{ $question->id }}][choice]" 
                                       id="yes_{{ $question->id }}" 
                                       value="yes" 
                                       data-question-id="{{ $question->id }}"
                                       {{ $existingChoice === 'ใช่' ? 'checked' : '' }}
                                       required>
                                <label class="form-check-label" for="yes_{{ $question->id }}">ใช่</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input yes-no-radio" type="radio" 
                                       name="answers[{{ $question->id }}][choice]" 
                                       id="no_{{ $question->id }}" 
                                       value="no" 
                                       data-question-id="{{ $question->id }}"
                                       {{ $existingChoice === 'ไม่ใช่' ? 'checked' : '' }}
                                       required>
                                <label class="form-check-label" for="no_{{ $question->id }}">ไม่ใช่</label>
                            </div>
                        </div>

                        <!-- ข้อความเพิ่มเติม (แสดงเมื่อเลือก ใช่) -->
                        <div class="mb-3 {{ $existingChoice === 'ใช่' ? '' : 'd-none' }}" id="text_field_{{ $question->id }}">
                            <label class="form-label">รายละเอียดเพิ่มเติม (กรณีตอบว่าใช่)</label>
                            <textarea name="answers[{{ $question->id }}][details]" 
                                      class="form-control evaluation-field" 
                                      rows="3">{{ $existingAnswer ? $existingAnswer->comment : '' }}</textarea>
                        </div>
                    @endif

                    @if($question->question_type === 'text')
                        <!-- คำถามแบบข้อความ -->
                        <div class="mb-3">
                            @php
                                $existingAnswer = isset($assessment) ? $assessment->answers->where('question_id', $question->id)->first() : null;
                            @endphp
                            <textarea name="answers[{{ $question->id }}][text]" 
                                      class="form-control evaluation-field" 
                                      rows="3" 
                                      placeholder="กรุณาตอบคำถามนี้">{{ $existingAnswer ? $existingAnswer->answer_text : '' }}</textarea>
                        </div>
                    @endif

                    @if($question->question_type === 'choice')
                        <!-- คำถามแบบตัวเลือก -->
                        <div class="mb-3">
                            @php
                                $existingAnswer = isset($assessment) ? $assessment->answers->where('question_id', $question->id)->first() : null;
                                $existingChoice = $existingAnswer ? $existingAnswer->answer_text : null;
                            @endphp
                            
                            @if($question->choices)
                                @foreach(explode(',', $question->choices) as $choice)
                                    @php $choice = trim($choice); @endphp
                                    <div class="form-check">
                                        <input class="form-check-input evaluation-field" type="radio" 
                                               name="answers[{{ $question->id }}][choice]" 
                                               id="choice_{{ $question->id }}_{{ $loop->index }}" 
                                               value="{{ $choice }}"
                                               {{ $existingChoice === $choice ? 'checked' : '' }}
                                               required>
                                        <label class="form-check-label" for="choice_{{ $question->id }}_{{ $loop->index }}">
                                            {{ $choice }}
                                        </label>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    @endif

                    @if($isAccordion)
                        <!-- แสดง Child Questions ในรูปแบบ Accordion -->
                        <div class="mt-4">
                            <div class="accordion" id="accordion_{{ $question->id }}">
                                @php
                                    $childQuestions = $allQuestions->where('parent_id', $question->id)->whereNotNull('question_type')->sortBy('sort_order');
                                @endphp
                                
                                @foreach($childQuestions as $childIndex => $child)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading_{{ $child->id }}">
                                        <button class="accordion-button {{ $childIndex === 0 ? '' : 'collapsed' }}" 
                                                type="button" 
                                                data-bs-toggle="collapse" 
                                                data-bs-target="#collapse_{{ $child->id }}" 
                                                aria-expanded="{{ $childIndex === 0 ? 'true' : 'false' }}" 
                                                aria-controls="collapse_{{ $child->id }}">
                                            <span class="badge bg-secondary me-2">{{ $globalQuestionNumber }}.{{ $childIndex + 1 }}</span>
                                            {{ $child->question_text }}
                                        </button>
                                    </h2>
                                    <div id="collapse_{{ $child->id }}" 
                                         class="accordion-collapse collapse {{ $childIndex === 0 ? 'show' : '' }}" 
                                         aria-labelledby="heading_{{ $child->id }}" 
                                         data-bs-parent="#accordion_{{ $question->id }}">
                                        <div class="accordion-body">
                                            @include('partials.question_recursive', [
                                                'question' => $child,
                                                'allQuestions' => $allQuestions,
                                                'globalQuestionNumber' => $globalQuestionNumber,
                                                'assessment' => $assessment ?? null
                                            ])
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- หมายเหตุ -->
                    @if($question->question_type !== null)
                    <div class="mb-3">
                        @php
                            $existingAnswer = isset($assessment) ? $assessment->answers->where('question_id', $question->id)->first() : null;
                        @endphp
                        <label class="form-label">หมายเหตุ (ถ้ามี)</label>
                        <textarea name="answers[{{ $question->id }}][comment]" 
                                  class="form-control" 
                                  rows="2" 
                                  placeholder="หมายเหตุเพิ่มเติม">{{ $existingAnswer ? $existingAnswer->comment : '' }}</textarea>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@if($question->question_type !== null)
    @php $globalQuestionNumber++; @endphp
@endif 