@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">
                        <i class="fas fa-chart-bar me-2"></i>
                        รายงานผลการประเมินผลิตภัณฑ์
                    </h4>
                </div>
                <div class="card-body card">
                    <!-- บล็อกแสดงข้อมูลผลิตภัณฑ์ -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-box me-2"></i>
                                        ข้อมูลผลิตภัณฑ์
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td class="fw-bold" style="width: 150px;">ชื่อผลิตภัณฑ์:</td>
                                                    <td>{{ $product->name ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">โมเดล/รุ่น:</td>
                                                    <td>{{ $product->model ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">วิธีรับข้อมูล:</td>
                                                    <td>{{ $product->log_receive_method ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                                                    <td>{{ $product->product_type ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">Email ติดต่อ:</td>
                                                    <td>{{ $product->user->Email ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            @if($product->image)
                                                <div class="text-center">
                                                    <img src="{{ asset('storage/' . $product->image) }}" 
                                                         alt="รูปภาพผลิตภัณฑ์" 
                                                         class="img-fluid rounded" 
                                                         style="max-height: 200px;">
                                                </div>
                                            @else
                                                <div class="text-center text-muted">
                                                    <i class="fas fa-image fa-3x mb-2"></i>
                                                    <p>ไม่มีรูปภาพ</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-user me-2"></i>
                                        ข้อมูลผู้ใช้
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        @if($product->user->profile_photo_path)
                                            <img src="{{ asset('storage/' . $product->user->profile_photo_path) }}" 
                                                 alt="รูปภาพผู้ใช้" 
                                                 class="rounded-circle mb-3" 
                                                 style="width: 100px; height: 100px; object-fit: cover;">
                                        @else
                                            <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                                 style="width: 100px; height: 100px;">
                                                <i class="fas fa-user fa-2x text-white"></i>
                                            </div>
                                        @endif
                                        <h6>{{ $product->user->name ?? 'ไม่ระบุ' }}</h6>
                                        <p class="text-muted mb-0">{{ $product->user->Email ?? 'ไม่ระบุ' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                    </div>

                    <!-- บล็อกอธิบายความหมายของเครื่องหมาย -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        หมายเหตุ
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-success me-2">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <span class="text-muted">= สอดคล้อง</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-danger me-2">
                                                    <i class="fas fa-times"></i>
                                                </span>
                                                <span class="text-muted">= ไม่สอดคล้อง</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-muted me-2">N/A</span>
                                                <span class="text-muted">= ไม่เกี่ยวข้องกับการประเมิน</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ตารางแสดงผลการประเมิน -->
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-clipboard-check me-2"></i>
                                ตารางแสดงผลการประเมิน
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(isset($assessment) && $assessment)
                                @if($assessment->status === 'draft')
                                    <div class="text-center text-muted py-5">
                                        <i class="fas fa-edit fa-3x mb-3"></i>
                                        <h5>ยังเป็นฉบับร่าง</h5>
                                        <p>การประเมินนี้ยังเป็นฉบับร่าง กรุณาส่งการประเมินก่อนเพื่อดูผลการประเมิน</p>
                                    </div>
                                @else
                                    <div class="mb-4">
                                        <h6 class="text-primary mb-3">
                                            <i class="fas fa-calendar-alt me-1"></i>
                                            การประเมินวันที่: {{ $assessment->DtmIns->format('d/m/Y H:i') }}
                                        </h6>
                                        
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-hover">
                                                <thead class="table-dark">
                                                    <tr>
                                                        <th style="width: 80px;" class="text-center">ข้อ</th>
                                                        <th style="width: 300px;" class="text-center">ข้อกำหนด</th>
                                                        <th style="width: 200px;" class="text-center">คำตอบ</th>
                                                        <th style="width: 120px;" class="text-center">ผลการตรวจสอบ</th>
                                                        <th style="width: 300px;" class="text-center">คำอธิบาย</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(isset($answeredQuestions) && $answeredQuestions->count() > 0)
                                                        @php
                                                            $questionNumber = 1;
                                                        @endphp
                                                        
                                                        <!-- แสดงเฉพาะคำถามที่มีคำตอบใน Assessment นี้ -->
                                                        @foreach($answeredQuestions as $question)
                                                            @php
                                                                $answer = $question->answer; // ใช้ข้อมูลคำตอบที่อยู่ใน question object
                                                                // กำหนด CSS class สำหรับ row
                                                                $rowClass = '';
                                                                if ($question->question_type == 'yes_no' && $question->use_in_evaluation) {
                                                                    if ($answer && $answer->answer_text == 'ใช่') {
                                                                        $rowClass = 'table-success';
                                                                    } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                        $rowClass = 'table-danger';
                                                                    }
                                                                } elseif ($question->question_type === null && $question->use_in_evaluation) {
                                                                    if ($answer && $answer->answer_text == 'ใช่') {
                                                                        $rowClass = 'table-success';
                                                                    } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                        $rowClass = 'table-danger';
                                                                    }
                                                                } elseif ($question->question_type == 'multiple_choice' || $question->question_type == 'text') {
                                                                    $rowClass = 'table-secondary';
                                                                }
                                                            @endphp
                                                            <tr class="{{ $rowClass }}">
                                                                <td class="text-center fw-bold">
                                                                    @if($question->has_question_number)
                                                                    @php
                                                                        $questionNumber = $question->question_number_only;
                                                                        $level = substr_count($questionNumber, '.');
                                                                        $indent = $level * 20; // ย่อหน้าตามระดับ
                                                                    @endphp
                                                                    <div style="padding-left: {{ $indent }}px; text-align: left;">
                                                                        {{ $questionNumber }}
                                                                    </div>
                                                                    @else
                                                                    {{ $questionNumber }}
                                                                    @endif
                                                                </td>
                                                                <td>
                                                                    <strong>{{ $question->question_content ?? $question->question_text ?? 'ไม่ระบุ' }}</strong>
                                                                    @if($question->question_type === null && $question->logic_operator && Auth::user()->Level === 'admin')
                                                                        <br><small class="text-muted">(Logic: {{ $question->logic_operator }})</small>
                                                                    @endif
                                                                    @if($question->question_type == 'multiple_choice')
                                                                        <br><small class="text-muted">(คำถามแบบตัวเลือก)</small>
                                                                    @elseif($question->question_type == 'text')
                                                                        <br><small class="text-muted">(คำถามแบบข้อความ)</small>
                                                                    @endif
                                                                </td>
                                                                <td>
                                                                    @if($question->question_type === null)
                                                                        <!-- สำหรับ parent questions -->
                                                                        -
                                                                    @elseif($answer)
                                                                        @if($question->question_type == 'yes_no')
                                                                            @if($answer->comment)
                                                                                {{ $answer->comment }}
                                                                            @else
                                                                                -
                                                                            @endif
                                                                        @elseif($question->question_type == 'multiple_choice')
                                                                            <span class="badge bg-info text-wrap">
                                                                                <i class="fas fa-list me-1"></i>
                                                                                {{ $answer->answer_text }}
                                                                            </span>
                                                                        @elseif($question->question_type == 'text')
                                                                            <span class="badge bg-secondary">
                                                                                <i class="fas fa-file-text me-1"></i>
                                                                                ข้อความ
                                                                            </span>
                                                                            <div class="small text-muted mt-1">
                                                                                {{ Str::limit($answer->answer_text, 100) }}
                                                                            </div>
                                                                        @else
                                                                            <span class="badge bg-secondary">
                                                                                {{ $answer->answer_text ?? 'ไม่ระบุ' }}
                                                                            </span>
                                                                        @endif
                                                                    @else
                                                                        <span class="text-muted">-</span>
                                                                    @endif
                                                                </td>
                                                                <td class="text-center">
                                                                    @if($question->question_type == 'yes_no')
                                                                        @if($question->use_in_evaluation)
                                                                            @if($answer && $answer->answer_text == 'ใช่')
                                                                                <span class="text-success">
                                                                                    <i class="fas fa-check"></i>
                                                                                </span>
                                                                            @elseif($answer && $answer->answer_text == 'ไม่ใช่')
                                                                                <span class="text-danger">
                                                                                    <i class="fas fa-times"></i>
                                                                                </span>
                                                                            @else
                                                                                <span class="text-muted">N/A</span>
                                                                            @endif
                                                                        @else
                                                                            <span class="text-muted">N/A</span>
                                                                        @endif
                                                                    @elseif($question->question_type === null)
                                                                        @if($question->use_in_evaluation)
                                                                            @if($answer && $answer->answer_text == 'ใช่')
                                                                                <span class="text-success">
                                                                                    <i class="fas fa-check"></i>
                                                                                </span>
                                                                            @elseif($answer && $answer->answer_text == 'ไม่ใช่')
                                                                                <span class="text-danger">
                                                                                    <i class="fas fa-times"></i>
                                                                                </span>
                                                                            @else
                                                                                <span class="text-muted">N/A</span>
                                                                            @endif
                                                                        @else
                                                                            <span class="text-muted">N/A</span>
                                                                        @endif
                                                                    @elseif($question->question_type == 'multiple_choice')
                                                                        <!-- คำถามแบบตัวเลือก - แสดง N/A เสมอ -->
                                                                        <span class="text-muted">N/A</span>
                                                                    @elseif($question->question_type == 'text')
                                                                        <!-- คำถามแบบข้อความ - แสดง N/A เสมอ -->
                                                                        <span class="text-muted">N/A</span>
                                                                    @endif
                                                                </td>
                                                                <td>
                                                                    @if($question->description)
                                                                        {{ $question->description }}
                                                                    @else
                                                                        <span class="text-muted">-</span>
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        
                                                        <!-- ลบส่วนที่ซ้ำซ้อนออก เพราะเราได้รวมคำถามทั้งหมดไว้ใน $allQuestions แล้ว -->
                                                    @else
                                                        <tr>
                                                            <td colspan="5" class="text-center text-muted">
                                                                <i class="fas fa-info-circle me-1"></i>
                                                                ไม่มีคำถามที่ตอบใน Assessment นี้
                                                            </td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                        <!-- ลบส่วนสรุปผลการประเมินออก -->
                                    </div>
                                @endif
                            @else
                                <div class="text-center text-muted py-5">
                                    <i class="fas fa-clipboard-list fa-3x mb-3"></i>
                                    <h5>ยังไม่มีข้อมูลการประเมิน</h5>
                                    <p>ไม่พบผลการประเมินสำหรับผลิตภัณฑ์นี้</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- ปุ่มกลับ -->
                    <div class="text-center mt-4">
                        <div class="d-flex justify-content-center gap-3">
                            @if(Auth::user()->Level === 'admin')
                                <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>
                                    กลับไปหน้า Admin Dashboard
                                </a>
                            @else
                                <a href="{{ route('products.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>
                                    กลับไปหน้ารายการผลิตภัณฑ์
                                </a>
                            @endif
                            <button type="button" class="btn btn-primary" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>
                                พิมพ์
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* สไตล์สำหรับการพิมพ์ */
@media print {
    /* ซ่อนปุ่มที่ไม่ต้องการพิมพ์ */
    .btn {
        display: none !important;
    }
    
    /* ซ่อน navigation bar */
    nav, .navbar, .navbar-expand-md {
        display: none !important;
    }
    
    /* ซ่อน header ที่มีคำว่า "Laravel" */
    header, .header, .app-header {
        display: none !important;
    }
    
    /* ซ่อน footer */
    footer, .footer {
        display: none !important;
    }
    
    /* ซ่อน URL และข้อมูลเบราว์เซอร์ */
    @page {
        margin: 0.5in;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .no-print {
        display: none !important;
    }
    
    /* ปรับแต่งการแสดงผลสำหรับการพิมพ์ */
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .table {
        border-collapse: collapse !important;
    }
    
    .table th,
    .table td {
        border: 1px solid #000 !important;
        padding: 8px !important;
    }
    
    .table-dark {
        background-color: #f8f9fa !important;
        color: #000 !important;
    }
    
    .table-dark th {
        background-color: #e9ecef !important;
        color: #000 !important;
        font-weight: bold !important;
    }
    
    /* ปรับขนาดตัวอักษรสำหรับการพิมพ์ */
    body {
        font-size: 12px !important;
        margin: 0 !important;
        padding: 0 !important;
    }
    
    h4, h5, h6 {
        font-size: 14px !important;
        margin-bottom: 8px !important;
    }
    
    /* ปรับขนาดรูปภาพ */
    img {
        max-height: 150px !important;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .text-muted {
        color: #6c757d !important;
    }
    
    /* ปรับตารางสำหรับการพิมพ์ */
    .table-responsive {
        overflow: visible !important;
    }
    
    /* ซ่อน icon ที่ไม่จำเป็นสำหรับการพิมพ์ แต่ให้แสดงเครื่องหมายถูกผิด */
    .fas:not(.fa-check):not(.fa-times):not(.fa-list):not(.fa-file-text) {
        display: none !important;
    }
    
    /* แสดงเครื่องหมายถูกผิดสำหรับการพิมพ์ */
    .fa-check, .fa-times, .fa-list, .fa-file-text {
        display: inline-block !important;
    }
    
    /* ปรับสีสำหรับการพิมพ์ */
    .text-success {
        color: #155724 !important;
    }
    
    .text-danger {
        color: #721c24 !important;
    }
    
    .text-info {
        color: #0c5460 !important;
    }
    
    .text-secondary {
        color: #383d41 !important;
    }
    
    /* ปรับ layout สำหรับการพิมพ์ */
    .container-fluid {
        width: 100% !important;
        max-width: none !important;
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .row {
        margin: 0 !important;
    }
    
    .col-12, .col-md-12, .col-md-6 {
        padding: 0 !important;
        width: 100% !important;
    }
    
    /* ซ่อน URL และข้อมูลเบราว์เซอร์ */
    @page {
        size: A4;
        margin: 0.5in;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .d-print-none {
        display: none !important;
    }
    
    /* แสดงเฉพาะส่วนที่ต้องการพิมพ์ */
    .d-print-block {
        display: block !important;
    }
}
</style>
@endsection