<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ข้อมูลคำถามทั้งหมด</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .parent { background-color: #e8f5e8; }
        .child { background-color: #fff3cd; }
        .grandchild { background-color: #f8d7da; }
        .great-grandchild { background-color: #d1ecf1; }
        .great-great-grandchild { background-color: #f5c6cb; }
        .great-great-great-grandchild { background-color: #ffeaa7; }
        .accordion { background-color: #fff3cd; }
        .evaluation { background-color: #d4edda; }
        .non-evaluation { background-color: #f8d7da; }
        .table th { background-color: #f8f9fa; }
        .question-text { max-width: 300px; word-wrap: break-word; }
        .statistics-card { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
    </style>
</head>
<body>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <h1 class="text-center mb-4">
                    <i class="fas fa-question-circle me-2"></i>
                    ข้อมูลคำถามทั้งหมดในตาราง questions
                </h1>

                <!-- สรุปสถิติ -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card statistics-card">
                            <div class="card-body">
                                <h5 class="card-title text-center mb-3">
                                    <i class="fas fa-chart-bar me-2"></i>
                                    สรุปสถิติ
                                </h5>
                                <div class="row text-center">
                                    <div class="col-md-2">
                                        <h4>{{ $questions->count() }}</h4>
                                        <small>คำถามทั้งหมด</small>
                                    </div>
                                    <div class="col-md-2">
                                        <h4>{{ $questions->where('parent_id', null)->count() }}</h4>
                                        <small>Parent Questions</small>
                                    </div>
                                    <div class="col-md-2">
                                        <h4>{{ $questions->where('parent_id', '!=', null)->count() }}</h4>
                                        <small>Child Questions</small>
                                    </div>
                                    <div class="col-md-2">
                                        <h4>{{ $questions->where('use_in_evaluation', false)->where('question_type', null)->count() }}</h4>
                                        <small>Accordion Questions</small>
                                    </div>
                                    <div class="col-md-2">
                                        <h4>{{ $questions->where('use_in_evaluation', true)->where('question_type', '!=', null)->count() }}</h4>
                                        <small>Evaluation Questions</small>
                                    </div>
                                    <div class="col-md-2">
                                        <h4>{{ $questions->where('use_in_evaluation', false)->where('question_type', '!=', null)->count() }}</h4>
                                        <small>Non-Evaluation Questions</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ตารางข้อมูลคำถาม -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-table me-2"></i>
                            รายละเอียดคำถามทั้งหมด
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Group</th>
                                        <th>Level</th>
                                        <th>Parent ID</th>
                                        <th>Question Text</th>
                                        <th>Question Type</th>
                                        <th>Use in Evaluation</th>
                                        <th>Choices</th>
                                        <th>Display Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($questions as $question)
                                        @php
                                            $level = getQuestionLevel($question, $questions);
                                            $levelClass = getLevelClass($level);
                                            $displayType = getDisplayType($question->use_in_evaluation, $question->question_type);
                                            $displayClass = getDisplayClass($displayType);
                                        @endphp
                                        <tr class="{{ $levelClass }} {{ $displayClass }}">
                                            <td><strong>{{ $question->id }}</strong></td>
                                            <td>{{ $question->questionGroup->name ?? 'ไม่มี' }}</td>
                                            <td><span class="badge bg-primary">{{ $level }}</span></td>
                                            <td>{{ $question->parent_id ?? 'ไม่มี' }}</td>
                                            <td class="question-text">{{ $question->question_text }}</td>
                                            <td>
                                                @if($question->question_type)
                                                    <span class="badge bg-info">{{ $question->question_type }}</span>
                                                @else
                                                    <span class="badge bg-secondary">null</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($question->use_in_evaluation)
                                                    <span class="badge bg-success">ใช่</span>
                                                @else
                                                    <span class="badge bg-warning">ไม่ใช่</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($question->choices)
                                                    <span class="badge bg-info">มี</span>
                                                @else
                                                    <span class="badge bg-secondary">ไม่มี</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="badge bg-dark">{{ $displayType }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- ข้อมูลตาม Group -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-layer-group me-2"></i>
                            ข้อมูลตาม Group
                        </h5>
                    </div>
                    <div class="card-body">
                        @php
                            $groupStats = $questions->groupBy('question_group_id');
                        @endphp
                        @foreach($groupStats as $groupId => $groupQuestions)
                            <div class="row mb-3">
                                <div class="col-12">
                                    <h6>
                                        <i class="fas fa-folder me-2"></i>
                                        {{ $groupQuestions->first()->questionGroup->name ?? 'ไม่มีชื่อ' }} 
                                        (ID: {{ $groupId }}) - 
                                        <span class="badge bg-primary">{{ $groupQuestions->count() }} คำถาม</span>
                                    </h6>
                                    <div class="ms-4">
                                        @foreach($groupQuestions as $question)
                                            <div class="d-flex align-items-center mb-1">
                                                <small class="text-muted me-2">ID: {{ $question->id }}</small>
                                                <span class="badge bg-secondary me-2">{{ getQuestionLevel($question, $questions) }}</span>
                                                <span class="text-truncate">{{ $question->question_text }}</span>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

@php
    function getQuestionLevel($question, $allQuestions) {
        if (!$question->parent_id) {
            return "Parent (ระดับที่ 1)";
        }
        
        $level = 1;
        $currentParentId = $question->parent_id;
        
        while ($currentParentId) {
            $parent = $allQuestions->where('id', $currentParentId)->first();
            if ($parent) {
                $level++;
                $currentParentId = $parent->parent_id;
            } else {
                break;
            }
        }
        
        switch ($level) {
            case 1: return "Parent (ระดับที่ 1)";
            case 2: return "Child (ระดับที่ 2)";
            case 3: return "Grand Child (ระดับที่ 3)";
            case 4: return "Great Grand Child (ระดับที่ 4)";
            case 5: return "Great Great Grand Child (ระดับที่ 5)";
            case 6: return "Great Great Great Grand Child (ระดับที่ 6)";
            default: return "ระดับที่ {$level}";
        }
    }

    function getLevelClass($level) {
        if (strpos($level, 'Parent') !== false) return 'parent';
        if (strpos($level, 'Child') !== false && strpos($level, 'Grand') === false) return 'child';
        if (strpos($level, 'Grand Child') !== false && strpos($level, 'Great') === false) return 'grandchild';
        if (strpos($level, 'Great Grand Child') !== false && strpos($level, 'Great Great') === false) return 'great-grandchild';
        if (strpos($level, 'Great Great Grand Child') !== false && strpos($level, 'Great Great Great') === false) return 'great-great-grandchild';
        if (strpos($level, 'Great Great Great Grand Child') !== false) return 'great-great-great-grandchild';
        return '';
    }

    function getDisplayType($useInEvaluation, $questionType) {
        if (!$useInEvaluation && $questionType === null) {
            return "Accordion Button";
        } elseif ($useInEvaluation && $questionType !== null) {
            return "Card ปกติ (ใช้ในการประเมิน)";
        } elseif (!$useInEvaluation && $questionType !== null) {
            return "Card สีเทา (ไม่ใช้ในการประเมิน)";
        } else {
            return "ไม่ระบุ";
        }
    }

    function getDisplayClass($displayType) {
        if (strpos($displayType, 'Accordion') !== false) return 'accordion';
        if (strpos($displayType, 'ใช้ในการประเมิน') !== false) return 'evaluation';
        if (strpos($displayType, 'ไม่ใช้ในการประเมิน') !== false) return 'non-evaluation';
        return '';
    }
@endphp 