<?php

use Illuminate\Support\Facades\Route;

// Controllers
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\AssessmentController;
use App\Http\Controllers\SsoController; // << ย้ายขึ้นมารวมกัน

// Landing -> หน้า login
Route::get('/', function () {
    return view('auth.login');
});

// ---- SSO (อยู่นอก auth middleware) ----
Route::get('/sso/login', [SsoController::class, 'login'])->name('sso.login');

// Dashboard หลังล็อกอิน
Route::get('/dashboard', [ProductController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

// กลุ่มที่ต้องล็อกอินแล้วเท่านั้น
Route::middleware(['auth', 'check.user.status'])->group(function () {
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Products
    Route::get('/products', [ProductController::class, 'index'])->name('products.index');
    Route::get('/products/create', [ProductController::class, 'create'])->name('products.create');
    Route::get('/products/create-new', [ProductController::class, 'createNew'])->name('products.create-new');
    Route::post('/products', [ProductController::class, 'store'])->name('products.store');
    Route::post('/products/back-to-edit', [ProductController::class, 'backToEdit'])->name('products.back-to-edit');
    Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('products.destroy');
    Route::get('/products/report/{product}', [ProductController::class, 'report'])->name('products.report');

    // Filters
    Route::get('/products/company/{companyId}', [ProductController::class, 'companyProducts'])->name('products.company');
    Route::get('/products/my', [ProductController::class, 'myProducts'])->name('products.my');

    // Assessments
    Route::get('/assessments/create/{product}', [AssessmentController::class, 'create'])->name('assessments.create');
    Route::post('/assessments', [AssessmentController::class, 'store'])->name('assessments.store');
    Route::post('/assessments/draft', [AssessmentController::class, 'storeDraft'])->name('assessments.store-draft');
    Route::get('/assessments/continue-draft/{product}', [AssessmentController::class, 'continueDraft'])->name('assessments.continue-draft');
    Route::post('/assessments/submit-draft', [AssessmentController::class, 'submitDraft'])->name('assessments.submit-draft');
    Route::get('/assessments/{assessment}/edit', [AssessmentController::class, 'edit'])->name('assessments.edit');
    Route::get('/assessments/{assessment}/manual', [AssessmentController::class, 'manual'])->name('assessments.manual');
    Route::put('/assessments/{assessment}', [AssessmentController::class, 'update'])->name('assessments.update');
});

// Admin
Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    Route::get('/dashboard', [App\Http\Controllers\AdminController::class, 'dashboard'])->name('admin.dashboard');

    // Users
    Route::get('/users', [App\Http\Controllers\AdminController::class, 'users'])->name('admin.users');
    Route::post('/users/{user}/toggle-status', [App\Http\Controllers\AdminController::class, 'toggleUserStatus'])->name('admin.users.toggle-status');

    // Products
    Route::get('/products', [App\Http\Controllers\AdminController::class, 'products'])->name('admin.products');
    Route::get('/products/{product}/edit', [App\Http\Controllers\AdminController::class, 'editProduct'])->name('admin.products.edit');
    Route::put('/products/{product}', [App\Http\Controllers\AdminController::class, 'updateProduct'])->name('admin.products.update');
    Route::delete('/products/{product}', [App\Http\Controllers\AdminController::class, 'deleteProduct'])->name('admin.products.delete');
    Route::get('/products/{product}/report', [App\Http\Controllers\AdminController::class, 'viewReport'])->name('admin.products.report');

    // Assessments
    Route::get('/assessments', [App\Http\Controllers\AdminController::class, 'assessments'])->name('admin.assessments');
    Route::get('/assessments/{assessment}/view', [App\Http\Controllers\AdminController::class, 'viewAssessment'])->name('admin.assessments.view');
    Route::get('/assessments/{assessment}/report', [App\Http\Controllers\AdminController::class, 'assessmentReport'])->name('admin.assessments.report');
    Route::delete('/assessments/{assessment}', [App\Http\Controllers\AdminController::class, 'deleteAssessment'])->name('admin.assessments.delete');

    // Reports
    Route::get('/reports', [App\Http\Controllers\AdminController::class, 'reports'])->name('admin.reports');

    // Question Groups
    Route::get('/question-groups', [App\Http\Controllers\AdminController::class, 'questionGroups'])->name('admin.question-groups');
    Route::get('/question-groups/create', [App\Http\Controllers\AdminController::class, 'createQuestionGroup'])->name('admin.question-groups.create');
    Route::post('/question-groups', [App\Http\Controllers\AdminController::class, 'storeQuestionGroup'])->name('admin.question-groups.store');
    Route::get('/question-groups/{group}/edit', [App\Http\Controllers\AdminController::class, 'editQuestionGroup'])->name('admin.question-groups.edit');
    Route::put('/question-groups/{group}', [App\Http\Controllers\AdminController::class, 'updateQuestionGroup'])->name('admin.question-groups.update');
    Route::delete('/question-groups/{group}', [App\Http\Controllers\AdminController::class, 'deleteQuestionGroup'])->name('admin.question-groups.delete');
    Route::post('/question-groups/{group}/toggle-active', [App\Http\Controllers\AdminController::class, 'toggleQuestionGroupActive'])->name('admin.question-groups.toggle-active');

    // Questions
    Route::get('/question-groups/{group}/questions/create', [App\Http\Controllers\AdminController::class, 'createQuestion'])->name('admin.questions.create');
    Route::post('/question-groups/{group}/questions', [App\Http\Controllers\AdminController::class, 'storeQuestion'])->name('admin.questions.store');
    Route::get('/questions/{question}/edit', [App\Http\Controllers\AdminController::class, 'editQuestion'])->name('admin.questions.edit');
    Route::put('/questions/{question}', [App\Http\Controllers\AdminController::class, 'updateQuestion'])->name('admin.questions.update');
    Route::delete('/questions/{question}', [App\Http\Controllers\AdminController::class, 'deleteQuestion'])->name('admin.questions.delete');

    // D3 Tree
    Route::get('/question-groups/{group}/d3-tree-structure', [App\Http\Controllers\AdminController::class, 'showQuestionTreeStructure'])->name('admin.question-groups.d3-tree-structure');

    // Orders / Moves / Logic
    Route::post('/questions/update-order', [App\Http\Controllers\AdminController::class, 'updateQuestionOrder'])->name('admin.questions.update-order');
    Route::post('/questions/move', [App\Http\Controllers\AdminController::class, 'moveQuestion'])->name('admin.questions.move');
    Route::post('/questions/{question}/update-logic', [App\Http\Controllers\AdminController::class, 'updateQuestionLogic'])->name('admin.questions.update-logic');
});

// วิเคราะห์ questions (dev only)
Route::get('/questions/show', function () {
    $questions = \App\Models\Question::with(['questionGroup', 'parent'])
        ->orderBy('question_group_id')
        ->orderBy('sort_order')
        ->get();

    return view('questions.show', compact('questions'));
})->name('questions.show');

require __DIR__.'/auth.php';
