<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">
                        <i class="fas fa-chart-bar me-2"></i>
                        รายงานผลการประเมินผลิตภัณฑ์
                    </h4>
                </div>
                <div class="card-body card">
                    <!-- บล็อกแสดงข้อมูลผลิตภัณฑ์ -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-box me-2"></i>
                                        ข้อมูลผลิตภัณฑ์
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td class="fw-bold" style="width: 150px;">ชื่อผลิตภัณฑ์:</td>
                                                    <td><?php echo e($product->name ?? 'ไม่ระบุ'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">โมเดล/รุ่น:</td>
                                                    <td><?php echo e($product->model ?? 'ไม่ระบุ'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">วิธีรับข้อมูล:</td>
                                                    <td><?php echo e($product->log_receive_method ?? 'ไม่ระบุ'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                                                    <td><?php echo e($product->product_type ?? 'ไม่ระบุ'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">Email ติดต่อ:</td>
                                                    <td><?php echo e($product->user->Email ?? 'ไม่ระบุ'); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <?php if($product->image): ?>
                                                <div class="text-center">
                                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                                                         alt="รูปภาพผลิตภัณฑ์" 
                                                         class="img-fluid rounded" 
                                                         style="max-height: 200px;">
                                                </div>
                                            <?php else: ?>
                                                <div class="text-center text-muted">
                                                    <i class="fas fa-image fa-3x mb-2"></i>
                                                    <p>ไม่มีรูปภาพ</p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-user me-2"></i>
                                        ข้อมูลผู้ใช้
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <?php if($product->user->profile_photo_path): ?>
                                            <img src="<?php echo e(asset('storage/' . $product->user->profile_photo_path)); ?>" 
                                                 alt="รูปภาพผู้ใช้" 
                                                 class="rounded-circle mb-3" 
                                                 style="width: 100px; height: 100px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                                 style="width: 100px; height: 100px;">
                                                <i class="fas fa-user fa-2x text-white"></i>
                                            </div>
                                        <?php endif; ?>
                                        <h6><?php echo e($product->user->name ?? 'ไม่ระบุ'); ?></h6>
                                        <p class="text-muted mb-0"><?php echo e($product->user->Email ?? 'ไม่ระบุ'); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                    </div>

                    <!-- บล็อกอธิบายความหมายของเครื่องหมาย -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        หมายเหตุ
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-success me-2">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                                <span class="text-muted">= สอดคล้อง</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-danger me-2">
                                                    <i class="fas fa-times"></i>
                                                </span>
                                                <span class="text-muted">= ไม่สอดคล้อง</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-muted me-2">N/A</span>
                                                <span class="text-muted">= ไม่เกี่ยวข้องกับการประเมิน</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ตารางแสดงผลการประเมิน -->
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-clipboard-check me-2"></i>
                                ตารางแสดงผลการประเมิน
                            </h5>
                        </div>
                        <div class="card-body">
                            <?php if(isset($assessment) && $assessment): ?>
                                <?php if($assessment->status === 'draft'): ?>
                                    <div class="text-center text-muted py-5">
                                        <i class="fas fa-edit fa-3x mb-3"></i>
                                        <h5>ยังเป็นฉบับร่าง</h5>
                                        <p>การประเมินนี้ยังเป็นฉบับร่าง กรุณาส่งการประเมินก่อนเพื่อดูผลการประเมิน</p>
                                    </div>
                                <?php else: ?>
                                    <div class="mb-4">
                                        <h6 class="text-primary mb-3">
                                            <i class="fas fa-calendar-alt me-1"></i>
                                            การประเมินวันที่: <?php echo e($assessment->DtmIns->format('d/m/Y H:i')); ?>

                                        </h6>
                                        
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-hover">
                                                <thead class="table-dark">
                                                    <tr>
                                                        <th style="width: 80px;" class="text-center">ข้อ</th>
                                                        <th style="width: 300px;" class="text-center">ข้อกำหนด</th>
                                                        <th style="width: 200px;" class="text-center">คำตอบ</th>
                                                        <th style="width: 120px;" class="text-center">ผลการตรวจสอบ</th>
                                                        <th style="width: 300px;" class="text-center">คำอธิบาย</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(isset($answeredQuestions) && $answeredQuestions->count() > 0): ?>
                                                        <?php
                                                            $questionNumber = 1;
                                                        ?>
                                                        
                                                        <!-- แสดงเฉพาะคำถามที่มีคำตอบใน Assessment นี้ -->
                                                        <?php $__currentLoopData = $answeredQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $answer = $question->answer; // ใช้ข้อมูลคำตอบที่อยู่ใน question object
                                                                // กำหนด CSS class สำหรับ row
                                                                $rowClass = '';
                                                                if ($question->question_type == 'yes_no' && $question->use_in_evaluation) {
                                                                    if ($answer && $answer->answer_text == 'ใช่') {
                                                                        $rowClass = 'table-success';
                                                                    } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                        $rowClass = 'table-danger';
                                                                    }
                                                                } elseif ($question->question_type === null && $question->use_in_evaluation) {
                                                                    if ($answer && $answer->answer_text == 'ใช่') {
                                                                        $rowClass = 'table-success';
                                                                    } elseif ($answer && $answer->answer_text == 'ไม่ใช่') {
                                                                        $rowClass = 'table-danger';
                                                                    }
                                                                } elseif ($question->question_type == 'multiple_choice' || $question->question_type == 'text') {
                                                                    $rowClass = 'table-secondary';
                                                                }
                                                            ?>
                                                            <tr class="<?php echo e($rowClass); ?>">
                                                                <td class="text-center fw-bold">
                                                                    <?php if($question->has_question_number): ?>
                                                                    <?php
                                                                        $questionNumber = $question->question_number_only;
                                                                        $level = substr_count($questionNumber, '.');
                                                                        $indent = $level * 20; // ย่อหน้าตามระดับ
                                                                    ?>
                                                                    <div style="padding-left: <?php echo e($indent); ?>px; text-align: left;">
                                                                        <?php echo e($questionNumber); ?>

                                                                    </div>
                                                                    <?php else: ?>
                                                                    <?php echo e($questionNumber); ?>

                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <strong><?php echo e($question->question_content ?? $question->question_text ?? 'ไม่ระบุ'); ?></strong>
                                                                    <?php if($question->question_type === null && $question->logic_operator && Auth::user()->Level === 'admin'): ?>
                                                                        <br><small class="text-muted">(Logic: <?php echo e($question->logic_operator); ?>)</small>
                                                                    <?php endif; ?>
                                                                    <?php if($question->question_type == 'multiple_choice'): ?>
                                                                        <br><small class="text-muted">(คำถามแบบตัวเลือก)</small>
                                                                    <?php elseif($question->question_type == 'text'): ?>
                                                                        <br><small class="text-muted">(คำถามแบบข้อความ)</small>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <?php if($question->question_type === null): ?>
                                                                        <!-- สำหรับ parent questions -->
                                                                        -
                                                                    <?php elseif($answer): ?>
                                                                        <?php if($question->question_type == 'yes_no'): ?>
                                                                            <?php if($answer->comment): ?>
                                                                                <?php echo e($answer->comment); ?>

                                                                            <?php else: ?>
                                                                                -
                                                                            <?php endif; ?>
                                                                        <?php elseif($question->question_type == 'multiple_choice'): ?>
                                                                            <span class="badge bg-info text-wrap">
                                                                                <i class="fas fa-list me-1"></i>
                                                                                <?php echo e($answer->answer_text); ?>

                                                                            </span>
                                                                        <?php elseif($question->question_type == 'text'): ?>
                                                                            <span class="badge bg-secondary">
                                                                                <i class="fas fa-file-text me-1"></i>
                                                                                ข้อความ
                                                                            </span>
                                                                            <div class="small text-muted mt-1">
                                                                                <?php echo e(Str::limit($answer->answer_text, 100)); ?>

                                                                            </div>
                                                                        <?php else: ?>
                                                                            <span class="badge bg-secondary">
                                                                                <?php echo e($answer->answer_text ?? 'ไม่ระบุ'); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    <?php else: ?>
                                                                        <span class="text-muted">-</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td class="text-center">
                                                                    <?php if($question->question_type == 'yes_no'): ?>
                                                                        <?php if($question->use_in_evaluation): ?>
                                                                            <?php if($answer && $answer->answer_text == 'ใช่'): ?>
                                                                                <span class="text-success">
                                                                                    <i class="fas fa-check"></i>
                                                                                </span>
                                                                            <?php elseif($answer && $answer->answer_text == 'ไม่ใช่'): ?>
                                                                                <span class="text-danger">
                                                                                    <i class="fas fa-times"></i>
                                                                                </span>
                                                                            <?php else: ?>
                                                                                <span class="text-muted">N/A</span>
                                                                            <?php endif; ?>
                                                                        <?php else: ?>
                                                                            <span class="text-muted">N/A</span>
                                                                        <?php endif; ?>
                                                                    <?php elseif($question->question_type === null): ?>
                                                                        <?php if($question->use_in_evaluation): ?>
                                                                            <?php if($answer && $answer->answer_text == 'ใช่'): ?>
                                                                                <span class="text-success">
                                                                                    <i class="fas fa-check"></i>
                                                                                </span>
                                                                            <?php elseif($answer && $answer->answer_text == 'ไม่ใช่'): ?>
                                                                                <span class="text-danger">
                                                                                    <i class="fas fa-times"></i>
                                                                                </span>
                                                                            <?php else: ?>
                                                                                <span class="text-muted">N/A</span>
                                                                            <?php endif; ?>
                                                                        <?php else: ?>
                                                                            <span class="text-muted">N/A</span>
                                                                        <?php endif; ?>
                                                                    <?php elseif($question->question_type == 'multiple_choice'): ?>
                                                                        <!-- คำถามแบบตัวเลือก - แสดง N/A เสมอ -->
                                                                        <span class="text-muted">N/A</span>
                                                                    <?php elseif($question->question_type == 'text'): ?>
                                                                        <!-- คำถามแบบข้อความ - แสดง N/A เสมอ -->
                                                                        <span class="text-muted">N/A</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <?php if($question->description): ?>
                                                                        <?php echo e($question->description); ?>

                                                                    <?php else: ?>
                                                                        <span class="text-muted">-</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        
                                                        <!-- ลบส่วนที่ซ้ำซ้อนออก เพราะเราได้รวมคำถามทั้งหมดไว้ใน $allQuestions แล้ว -->
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="5" class="text-center text-muted">
                                                                <i class="fas fa-info-circle me-1"></i>
                                                                ไม่มีคำถามที่ตอบใน Assessment นี้
                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                        <!-- ลบส่วนสรุปผลการประเมินออก -->
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="text-center text-muted py-5">
                                    <i class="fas fa-clipboard-list fa-3x mb-3"></i>
                                    <h5>ยังไม่มีข้อมูลการประเมิน</h5>
                                    <p>ไม่พบผลการประเมินสำหรับผลิตภัณฑ์นี้</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- ปุ่มกลับ -->
                    <div class="text-center mt-4">
                        <div class="d-flex justify-content-center gap-3">
                            <?php if(Auth::user()->Level === 'admin'): ?>
                                <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>
                                    กลับไปหน้า Admin Dashboard
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>
                                    กลับไปหน้ารายการผลิตภัณฑ์
                                </a>
                            <?php endif; ?>
                            <button type="button" class="btn btn-primary" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>
                                พิมพ์
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* สไตล์สำหรับการพิมพ์ */
@media print {
    /* ซ่อนปุ่มที่ไม่ต้องการพิมพ์ */
    .btn {
        display: none !important;
    }
    
    /* ซ่อน navigation bar */
    nav, .navbar, .navbar-expand-md {
        display: none !important;
    }
    
    /* ซ่อน header ที่มีคำว่า "Laravel" */
    header, .header, .app-header {
        display: none !important;
    }
    
    /* ซ่อน footer */
    footer, .footer {
        display: none !important;
    }
    
    /* ซ่อน URL และข้อมูลเบราว์เซอร์ */
    @page {
        margin: 0.5in;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .no-print {
        display: none !important;
    }
    
    /* ปรับแต่งการแสดงผลสำหรับการพิมพ์ */
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .table {
        border-collapse: collapse !important;
    }
    
    .table th,
    .table td {
        border: 1px solid #000 !important;
        padding: 8px !important;
    }
    
    .table-dark {
        background-color: #f8f9fa !important;
        color: #000 !important;
    }
    
    .table-dark th {
        background-color: #e9ecef !important;
        color: #000 !important;
        font-weight: bold !important;
    }
    
    /* ปรับขนาดตัวอักษรสำหรับการพิมพ์ */
    body {
        font-size: 12px !important;
        margin: 0 !important;
        padding: 0 !important;
    }
    
    h4, h5, h6 {
        font-size: 14px !important;
        margin-bottom: 8px !important;
    }
    
    /* ปรับขนาดรูปภาพ */
    img {
        max-height: 150px !important;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .text-muted {
        color: #6c757d !important;
    }
    
    /* ปรับตารางสำหรับการพิมพ์ */
    .table-responsive {
        overflow: visible !important;
    }
    
    /* ซ่อน icon ที่ไม่จำเป็นสำหรับการพิมพ์ แต่ให้แสดงเครื่องหมายถูกผิด */
    .fas:not(.fa-check):not(.fa-times):not(.fa-list):not(.fa-file-text) {
        display: none !important;
    }
    
    /* แสดงเครื่องหมายถูกผิดสำหรับการพิมพ์ */
    .fa-check, .fa-times, .fa-list, .fa-file-text {
        display: inline-block !important;
    }
    
    /* ปรับสีสำหรับการพิมพ์ */
    .text-success {
        color: #155724 !important;
    }
    
    .text-danger {
        color: #721c24 !important;
    }
    
    .text-info {
        color: #0c5460 !important;
    }
    
    .text-secondary {
        color: #383d41 !important;
    }
    
    /* ปรับ layout สำหรับการพิมพ์ */
    .container-fluid {
        width: 100% !important;
        max-width: none !important;
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .row {
        margin: 0 !important;
    }
    
    .col-12, .col-md-12, .col-md-6 {
        padding: 0 !important;
        width: 100% !important;
    }
    
    /* ซ่อน URL และข้อมูลเบราว์เซอร์ */
    @page {
        size: A4;
        margin: 0.5in;
    }
    
    /* ซ่อนส่วนที่ไม่ต้องการพิมพ์ */
    .d-print-none {
        display: none !important;
    }
    
    /* แสดงเฉพาะส่วนที่ต้องการพิมพ์ */
    .d-print-block {
        display: block !important;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/products/report.blade.php ENDPATH**/ ?>