<?php

// ไฟล์ทดสอบสุดท้ายเพื่อตรวจสอบการแสดงผล accordion buttons

require_once 'vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as Capsule;

// ตั้งค่าการเชื่อมต่อฐานข้อมูล
$capsule = new Capsule;

$capsule->addConnection([
    'driver'    => 'mysql',
    'host'      => '127.0.0.1',
    'port'      => '3307',
    'database'  => 'sas_log',
    'username'  => 'root',
    'password'  => '',
    'charset'   => 'utf8',
    'collation' => 'utf8_unicode_ci',
    'prefix'    => '',
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

echo "<h1>ทดสอบการแสดงผล Accordion Buttons สำหรับ Grand Child Questions</h1>";
echo "<style>
    .accordion-button { background-color: #fff3cd; padding: 10px; margin: 5px; border: 1px solid #ddd; }
    .grandchild-accordion { background-color: #d1ecf1; padding: 10px; margin: 5px; border: 1px solid #ddd; }
    .evaluation-card { background-color: #d4edda; padding: 10px; margin: 5px; border: 1px solid #ddd; }
    .question-info { margin: 10px 0; padding: 10px; border: 1px solid #ddd; }
    .found { background-color: #d4edda; }
    .not-found { background-color: #f8d7da; }
</style>";

try {
    // ดึงข้อมูลคำถามทั้งหมด
    $questions = Capsule::table('sas_questions')
        ->leftJoin('question_groups', 'sas_questions.question_group_id', '=', 'question_groups.id')
        ->leftJoin('sas_questions as parent', 'sas_questions.parent_id', '=', 'parent.id')
        ->select([
            'sas_questions.id',
            'sas_questions.question_text',
            'sas_questions.question_type',
            'sas_questions.use_in_evaluation',
            'sas_questions.parent_id',
            'sas_questions.sort_order',
            'question_groups.name as group_name',
            'parent.question_text as parent_question'
        ])
        ->orderBy('sas_questions.sort_order')
        ->get();

    // จำลองการแสดงผลตามโค้ดใน edit.blade.php
    echo "<h2>การจำลองการแสดงผลตาม edit.blade.php:</h2>";
    
    // หา Parent Questions (ระดับที่ 1)
    $parentQuestions = $questions->where('parent_id', null)->where('use_in_evaluation', false)->where('question_type', null);
    
    $found36 = false;
    $found45 = false;
    
    foreach ($parentQuestions as $parent) {
        echo "<div class='accordion-button'>";
        echo "<strong>Parent Accordion: {$parent->question_text} (ID: {$parent->id})</strong><br>";
        
        // หา Child Questions ของ Parent นี้
        $childQuestions = $questions->where('parent_id', $parent->id);
        
        foreach ($childQuestions as $child) {
            if ($child->use_in_evaluation && $child->question_type !== null) {
                // Child Questions ที่ใช้ในการประเมิน
                echo "<div class='evaluation-card'>";
                echo "  <strong>Evaluation Question: {$child->question_text} (ID: {$child->id})</strong><br>";
                echo "  Type: {$child->question_type} | Use in Evaluation: " . ($child->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
                echo "</div>";
            } elseif (!$child->use_in_evaluation && $child->question_type === null) {
                // Grand Child Accordion Button
                echo "<div class='grandchild-accordion'>";
                echo "  <strong>Grand Child Accordion: {$child->question_text} (ID: {$child->id})</strong><br>";
                
                // ตรวจสอบว่าเป็น ID 36 หรือ 45 หรือไม่
                if ($child->id == 36) {
                    echo "  <strong style='color: green;'>✓ พบ ID 36!</strong><br>";
                    $found36 = true;
                }
                if ($child->id == 45) {
                    echo "  <strong style='color: green;'>✓ พบ ID 45!</strong><br>";
                    $found45 = true;
                }
                
                // หา Great Grand Child Questions ของ Child นี้
                $grandchildQuestions = $questions->where('parent_id', $child->id);
                
                foreach ($grandchildQuestions as $grandchild) {
                    if ($grandchild->use_in_evaluation && $grandchild->question_type !== null) {
                        echo "    <div class='evaluation-card'>";
                        echo "      <strong>Great Grand Child Evaluation: {$grandchild->question_text} (ID: {$grandchild->id})</strong><br>";
                        echo "      Type: {$grandchild->question_type} | Use in Evaluation: " . ($grandchild->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
                        echo "    </div>";
                    }
                }
                echo "</div>";
            }
        }
        echo "</div>";
    }
    
    // สรุปผลการค้นหา
    echo "<h2>สรุปผลการค้นหา:</h2>";
    echo "<div class='" . ($found36 ? 'found' : 'not-found') . "'>";
    echo "<strong>คำถาม ID 36:</strong> " . ($found36 ? '✓ พบและจะแสดงเป็น Grand Child Accordion Button' : '✗ ไม่พบ') . "<br>";
    echo "</div>";
    
    echo "<div class='" . ($found45 ? 'found' : 'not-found') . "'>";
    echo "<strong>คำถาม ID 45:</strong> " . ($found45 ? '✓ พบและจะแสดงเป็น Grand Child Accordion Button' : '✗ ไม่พบ') . "<br>";
    echo "</div>";
    
    if ($found36 && $found45) {
        echo "<div class='found'>";
        echo "<strong>✅ สรุป:</strong> คำถาม ID 36 และ 45 จะแสดงเป็น Grand Child Accordion Buttons ในหน้า edit แล้ว!<br>";
        echo "</div>";
    } else {
        echo "<div class='not-found'>";
        echo "<strong>❌ สรุป:</strong> ยังมีปัญหาการแสดงผล accordion buttons<br>";
        echo "</div>";
    }

} catch (Exception $e) {
    echo "<p>เกิดข้อผิดพลาด: " . $e->getMessage() . "</p>";
}

?> 