<?php
require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

// ตั้งค่าการเชื่อมต่อฐานข้อมูล
$config = [
    'driver' => 'mysql',
    'host' => '127.0.0.1',
    'port' => '3306',
    'database' => 'sas_log',
    'username' => 'root',
    'password' => '',
    'charset' => 'utf8mb4',
    'collation' => 'utf8mb4_unicode_ci',
];

// เชื่อมต่อฐานข้อมูล
DB::purge();
DB::reconnect();
DB::setDefaultConnection('default');

try {
    // ตรวจสอบตาราง customer
    echo "=== ตรวจสอบตาราง customer ===\n";
    $customers = DB::table('customer')->select('Customer_ID', 'Customer_Name', 'Email', 'Level')->get();
    
    foreach ($customers as $customer) {
        echo "ID: {$customer->Customer_ID}, Name: {$customer->Customer_Name}, Email: {$customer->Email}, Level: {$customer->Level}\n";
    }
    
    echo "\n=== ตรวจสอบ session ปัจจุบัน ===\n";
    $sessions = DB::table('sessions')->select('id', 'user_id', 'payload')->get();
    
    foreach ($sessions as $session) {
        echo "Session ID: {$session->id}, User ID: {$session->user_id}\n";
        if ($session->payload) {
            $payload = unserialize(base64_decode($session->payload));
            if (isset($payload['_token'])) {
                echo "  - มี _token\n";
            }
            if (isset($payload['login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d'])) {
                echo "  - มี login_web: " . $payload['login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d'] . "\n";
            }
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?> 