<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View // แสดงฟอร์ม login ให้ผู้ใช้งาน และ :View เป็น type hint ที่จะระบุว่า method นี้จะ return use Illuminate\View\View เท่านั้น
    {
        return view('auth.login'); // render view ชื่อ auth.login.blade.php (resources/views/auth/login.blade.php)
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();

        // redirect ตาม role
        if (Auth::user()->Level === 'admin') { //
            return redirect()->intended(route('admin.dashboard', absolute: false));
        }
        return redirect()->intended(route('products.index', absolute: false));
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
