<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Agency extends Model
{
    protected $table = 'agency';
    protected $primaryKey = 'Agency_ID';
    
    public $timestamps = false;

    protected $fillable = [
        'Agency_Name',
        'Tax_ID',
        'Address',
        'Address_Sent',
        'Address_Test',
        'Address_Eng',
        'Office_Number',
        'Web_Name',
        'CusIns_ID',
        'CusUdp_ID',
        'DtmIns',
        'DtmUdp',
        'active',
        'Note',
        'Edit_Agency',
        'New_Agency'
    ];

    protected $casts = [
        'DtmIns' => 'datetime',
        'DtmUdp' => 'datetime',
        'active' => 'boolean',
    ];

    // Relationships
    public function customers()
    {
        return $this->hasMany(Customer::class, 'Agency_ID', 'Agency_ID');
    }

    public function customersMany()
    {
        return $this->belongsToMany(Customer::class, 'agency_customer', 'Agency_ID', 'Customer_ID');
    }

    // Accessors
    public function getNameAttribute()
    {
        return $this->Agency_Name;
    }

    // Mutators
    public function setNameAttribute($value)
    {
        $this->Agency_Name = $value;
    }
}
