<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Assessment extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'question_group_id',
        'status',
        'user_id', // ถ้าคุณบันทึกว่าใครเป็นคนสร้าง assessment
        'started_at',
        'submitted_at',
        'CusIns_ID',
        'CusUdp_ID',
    ];

    // กำหนดชื่อ timestamp columns
    const CREATED_AT = 'DtmIns';
    const UPDATED_AT = 'DtmUpd';

    /**
     * ความสัมพันธ์กับ Product (ผลิตภัณฑ์ที่ถูกประเมิน)
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * ความสัมพันธ์กับ QuestionGroup (กลุ่มคำถามที่ใช้ในแบบประเมิน)
     */
    public function questionGroup()
    {
        return $this->belongsTo(QuestionGroup::class);
    }

    /**
     * ความสัมพันธ์กับ Answer (คำตอบแต่ละข้อของการประเมิน)
     */
    public function answers()
    {
        return $this->hasMany(Answer::class);
    }

    /**
     * ความสัมพันธ์กับ User (ผู้สร้างแบบประเมินนี้ ถ้ามีการเก็บ)
     */
    public function user()
    {
        return $this->belongsTo(Customer::class, 'user_id', 'Customer_ID');
    }
}