<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();

            $table->foreignId('question_group_id')->constrained()->onDelete('cascade');
            $table->foreignId('parent_id')->nullable()->constrained('questions')->onDelete('cascade');
            $table->text('question_text');
            $table->text('description')->nullable();
            $table->boolean('use_in_evaluation')->default(true);
            $table->enum('logic_operator', ['AND', 'OR'])->nullable();
            $table->string('keyword_tag')->nullable();
            $table->integer('sort_order')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('questions');
    }
};
