<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer', function (Blueprint $table) {
            $table->increments('Customer_ID')->comment('รหัสข้อมูลลูกค้า');
            $table->string('Customer_Name', 255)->comment('ชื่อผู้ติดต่อ');
            $table->string('Mobile_Number', 11)->comment('เบอร์โทรศัพท์ผู้ติดต่อ');
            $table->string('Email', 50)->unique()->comment('อีเมล');
            $table->string('Password', 100)->comment('รหัสผ่านของลูกค้า');
            $table->string('Level', 10)->comment('ระดับสิทธ์การเข้าถึง');
            $table->integer('Agency_ID')->comment('รหัสข้อมูลหน่วยงาน');
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
            $table->timestamp('DtmIns')->default(DB::raw('CURRENT_TIMESTAMP'))->comment('วันที่และเวลา สร้าง');
            $table->timestamp('DtmUdp')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'))->comment('วันที่และเวลา แก้ไข');
            $table->string('On_Off_Customer', 3)->default('On')->comment('สิทธิการแก้ไข On=สามารถแก้ไขได้ Off=ไม่สามารถแก้ไขได้');
            $table->string('Edit_Customer', 3)->default('Off')->comment('คำขอการแก้ไข On=มีคำขอ Off=ไม่มี');
            $table->string('New_Customer', 3)->default('Off')->comment('สถานะลูกค้าใหม่ On=ใหม่ Off=เดิม');

            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer');
    }
};
