<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //เพิ่มคอลัมภ์ Cus_Ins และ Cus_Ins_Udp ให้กับตารางทั้งหมด

        //ตาราง answers
        Schema::table('answers', function (Blueprint $table) {
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
        });

        //ตาราง assessments
        Schema::table('assessments', function (Blueprint $table) {
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
        });

        //ตาราง products
        Schema::table('products', function (Blueprint $table) {
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
        });

        //ตาราง questions
        Schema::table('questions', function (Blueprint $table) {
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
        });

        //ตาราง question_groups
        Schema::table('question_groups', function (Blueprint $table) {
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['CusIns_ID', 'CusUdp_ID']);
        });

        Schema::table('questions', function (Blueprint $table) {
            $table->dropColumn(['CusIns_ID', 'CusUdp_ID']);
        });

        Schema::table('question_groups', function (Blueprint $table) {
            $table->dropColumn(['CusIns_ID', 'CusUdp_ID']);
        });
        
        Schema::table('assessments', function (Blueprint $table) {
            $table->dropColumn(['CusIns_ID', 'CusUdp_ID']);
        });

        Schema::table('answers', function (Blueprint $table) {
            $table->dropColumn(['CusIns_ID', 'CusUdp_ID']);
        });
    }
};
