<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\QuestionGroup;
use App\Models\Question;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Models\Company;
use Illuminate\Database\Seeder;

class QuestionSeeder extends Seeder
{
    public function run(): void
    {        // สร้างหรือหา user (สำหรับใช้เป็นเจ้าของ group)
        $user = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('password123'),
                'remember_token' => Str::random(10),
                'role' => 'admin',
            ]
        );

        // สร้าง Question Group
        $group = QuestionGroup::create([
            'name' => 'คุณลักษณะทั่วไป',
            'created_by' => $user->id,
        ]);

        // เพิ่มคำถาม
        $question1 =Question::create([
            'question_group_id' => $group->id,
            'question_text' => 'การแบ่งแยกสิทธิ์และหน้าที่ระหว่าง “ผู้ดูแลระบบ” และ “ผู้ดูแลข้อมูล”',
            'use_in_evaluation' => false,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ผู้ดูแลระบบ มีหน้าที่ติดตั้ง ตั้งค่า และดูแลการทำงานของระบบ',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ผู้ดูแลระบบไม่มีสิทธิ์เข้าถึงข้อมูลจราจรที่เก็บ',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ผู้ดูแลข้อมูล สามารถเข้าถึงข้อมูลได้',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ผู้ดูแลข้อมูลไม่มีสิทธิ์แก้ไข เปลี่ยนแปลง ลบหรือทำลายข้อมูล และไม่มีสิทธิ์เปลี่ยนแปลงการตั้งค่าใด ๆ ของระบบ',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ระบบควรสามารถจำกัดจำนวนผู้ใช้ที่อนุญาตหรือยอมให้สร้างบัญชีผู้ใช้ขึ้นบนระบบ',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'จำนวนผู้ดูแลข้อมูลไม่ควรเกิน 1 บัญชี',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'ไม่สามารถกำหนดให้มีบัญชีผู้ใช้ใด ๆ มีสิทธิเป็นผู้ดูแลระบบและผู้ดูแลข้อมูลพร้อมกันได้',
            'use_in_evaluation' => true,
        ]);

        Question::create([
            'question_group_id' => $group->id,
            'parent_id' => $question1->id,
            'question_text' => 'มาตรการควบคุมเพิ่มเติม',
            'use_in_evaluation' => true,
        ]);
    }
}