@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-plus me-2"></i>
            สร้างกลุ่มคำถามใหม่
        </h1>
        <a href="{{ route('admin.question-groups') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>
            กลับไปรายการ
        </a>
    </div>

    <!-- Create Question Group Form -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-folder-plus me-2"></i>
                ข้อมูลกลุ่มคำถาม
            </h6>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.question-groups.store') }}">
                @csrf
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="name" class="form-label">ชื่อกลุ่มคำถาม <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('name') is-invalid @enderror" 
                                   id="name" 
                                   name="name" 
                                   value="{{ old('name') }}" 
                                   placeholder="กรอกชื่อกลุ่มคำถาม"
                                   required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">คำอธิบาย</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="4" 
                                      placeholder="กรอกคำอธิบายเกี่ยวกับกลุ่มคำถามนี้">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    <strong>เปิดใช้งานในแบบประเมิน</strong>
                                </label>
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    กลุ่มคำถามนี้จะแสดงในแบบประเมินสำหรับผู้ใช้ทั่วไป
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-info-circle me-1"></i>
                                    ข้อมูลเพิ่มเติม
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-user me-1"></i>
                                        ผู้สร้าง: {{ Auth::user()->Customer_Name }}
                                    </small>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="fas fa-calendar me-1"></i>
                                        วันที่สร้าง: {{ now()->format('d/m/Y H:i') }}
                                    </small>
                                </div>
                                <div class="mb-0">
                                    <small class="text-muted">
                                        <i class="fas fa-question-circle me-1"></i>
                                        สามารถเพิ่มคำถามได้หลังจากสร้างกลุ่มแล้ว
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.question-groups') }}" class="btn btn-secondary">
                        <i class="fas fa-times me-1"></i>
                        ยกเลิก
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>
                        บันทึก
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection 