<div class="question-item mb-3" data-question-id="{{ $question->id }}" data-parent-id="{{ $question->parent_id }}">
    <div class="card question-card {{ $level > 0 ? 'border-start border-primary' : '' }}" style="margin-left: {{ $level * 20 }}px;">
        <div class="card-header d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-grip-vertical me-2 drag-handle" style="cursor: move; color: #6c757d;"></i>
                
                <!-- ปุ่มพับ/กาง (แสดงเฉพาะเมื่อมีคำถามย่อย) -->
                @if($question->children->count() > 0)
                    <button type="button" 
                            class="btn btn-sm btn-outline-secondary me-2 collapse-toggle-btn" 
                            data-question-id="{{ $question->id }}"
                            title="พับ/กางคำถามย่อย">
                        <i class="fas fa-chevron-down collapse-icon"></i>
                    </button>
                @endif
                
                <h6 class="mb-0">
                    @if($level > 0)
                        <span class="badge bg-secondary me-2">Level {{ $level }}</span>
                    @endif
                    {{ $question->question_text }}
                    @if($question->children->count() > 0)
                        <span class="badge bg-info ms-2">{{ $question->children->count() }} คำถามย่อย</span>
                    @endif
                </h6>
            </div>
            <div class="d-flex gap-1">
                @if($question->use_in_evaluation)
                    <span class="badge bg-success">ใช้ในการประเมิน</span>
                @else
                    <span class="badge bg-secondary">ไม่ใช้ในการประเมิน</span>
                @endif
                @if($question->logic_operator)
                    <span class="badge bg-info">{{ $question->logic_operator_label }}</span>
                @endif
                <span class="badge bg-primary">{{ $question->question_type_label }}</span>
            </div>
        </div>
        <div class="card-body">
            @if($question->description)
                <p class="text-muted mb-2">{{ $question->description }}</p>
            @endif
            
            <!-- แสดง Choices สำหรับ Multiple Choice Questions -->
            @if($question->question_type === 'multiple_choice' && $question->choices && is_array($question->choices) && count($question->choices) > 0)
                <div class="mb-3">
                    <strong class="text-primary">
                        <i class="fas fa-list-ul me-1"></i>
                        ตัวเลือกคำตอบ:
                    </strong>
                    <div class="mt-2">
                        @foreach($question->choices as $index => $choice)
                            <div class="d-flex align-items-center mb-1">
                                <span class="badge bg-secondary me-2">{{ $index + 1 }}</span>
                                <span>{{ $choice }}</span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
            
            <!-- Logic Control สำหรับคำถามแม่ที่มีคำถามย่อย -->
            @if($question->children->count() > 0)
                <div class="mb-3 p-3 bg-light rounded">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <strong class="text-primary">
                                <i class="fas fa-cogs me-1"></i>
                                เงื่อนไขการเชื่อมต่อคำถามย่อย:
                            </strong>
                            <span class="badge bg-info ms-2" id="logic-display-{{ $question->id }}">
                                {{ $question->logic_operator ?: 'AND' }}
                            </span>
                        </div>
                        <div class="d-flex gap-2">
                            <select class="form-select form-select-sm logic-selector" 
                                    data-question-id="{{ $question->id }}"
                                    style="width: auto;">
                                <option value="AND" {{ ($question->logic_operator ?: 'AND') == 'AND' ? 'selected' : '' }}>
                                    AND (และ) - ต้องเป็นจริงทั้งหมด
                                </option>
                                <option value="OR" {{ ($question->logic_operator ?: 'AND') == 'OR' ? 'selected' : '' }}>
                                    OR (หรือ) - เป็นจริงอย่างน้อยหนึ่งข้อ
                                </option>
                            </select>
                            <button type="button" 
                                    class="btn btn-sm btn-outline-primary update-logic-btn"
                                    data-question-id="{{ $question->id }}">
                                <i class="fas fa-save me-1"></i>
                                บันทึก
                            </button>
                        </div>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        ควบคุมเงื่อนไขการประเมินคำถามย่อย {{ $question->children->count() }} คำถาม
                    </small>
                </div>
            @endif
            
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex gap-2">
                    <!-- ปุ่มเปลี่ยนตำแหน่ง -->
                    <div class="btn-group btn-group-sm" role="group">
                        <button type="button" 
                                class="btn btn-outline-secondary move-up-btn" 
                                data-question-id="{{ $question->id }}"
                                title="เลื่อนขึ้น">
                            <i class="fas fa-chevron-up"></i>
                        </button>
                        <button type="button" 
                                class="btn btn-outline-secondary move-down-btn" 
                                data-question-id="{{ $question->id }}"
                                title="เลื่อนลง">
                            <i class="fas fa-chevron-down"></i>
                        </button>
                    </div>
                    
                    <!-- ปุ่มเพิ่มคำถามย่อย -->
                    <a href="{{ route('admin.questions.create', ['group' => $question->questionGroup, 'parent_id' => $question->id]) }}" 
                       class="btn btn-sm btn-outline-success"
                       title="เพิ่มคำถามย่อย">
                        <i class="fas fa-plus me-1"></i>
                        เพิ่มคำถามย่อย
                    </a>
                    
                    <a href="{{ route('admin.questions.edit', $question) }}" 
                       class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-edit me-1"></i>
                        แก้ไข
                    </a>
                    <button type="button" 
                            class="btn btn-sm btn-outline-danger delete-question-btn" 
                            data-question-id="{{ $question->id }}"
                            data-question-text="{{ $question->question_text }}">
                        <i class="fas fa-trash me-1"></i>
                        ลบ
                    </button>
                </div>
                <small class="text-muted">
                    <i class="fas fa-calendar me-1"></i>
                    {{ $question->DtmIns->format('d/m/Y H:i') }}
                </small>
            </div>
        </div>
    </div>

    <!-- Child Questions (Recursive) - Drop Zone for dragging questions -->
    <div class="child-questions mt-2" data-parent-id="{{ $question->id }}" data-question-id="{{ $question->id }}">
        @if($question->children->count() > 0)
            @foreach($question->children as $child)
                @include('admin.question-groups.partials.question-item', ['question' => $child, 'level' => $level + 1])
            @endforeach
        @else
            <!-- Drop zone indicator when no children (hidden by default) -->
            <div class="drop-zone-indicator p-3 text-center text-muted" style="display: none;">
                <div class="d-flex align-items-center justify-content-center">
                    <i class="fas fa-arrow-down me-2 text-primary"></i>
                    <small>
                        <strong>ลากคำถามมาวางที่นี่</strong><br>
                        เพื่อสร้างคำถามย่อย
                    </small>
                </div>
            </div>
        @endif
    </div>
</div> 
 
 
 