@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-plus me-2"></i>
            @if($parentQuestion)
                เพิ่มคำถามย่อย
            @else
                เพิ่มคำถามใหม่
            @endif
        </h1>
        <a href="{{ route('admin.question-groups.edit', $group) }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>
            กลับไปกลุ่มคำถาม
        </a>
    </div>

    <!-- แสดงข้อมูลคำถามแม่ (ถ้ามี) -->
    @if($parentQuestion)
        <div class="card shadow mb-4">
            <div class="card-header py-3 bg-info text-white">
                <h6 class="m-0 font-weight-bold">
                    <i class="fas fa-info-circle me-2"></i>
                    คำถามแม่
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h6 class="text-primary">{{ $parentQuestion->question_text }}</h6>
                        @if($parentQuestion->description)
                            <p class="text-muted mb-2">{{ $parentQuestion->description }}</p>
                        @endif
                        <div class="d-flex gap-2">
                            <span class="badge bg-primary">{{ $parentQuestion->question_type_label }}</span>
                            @if($parentQuestion->use_in_evaluation)
                                <span class="badge bg-success">ใช้ในการประเมิน</span>
                            @else
                                <span class="badge bg-secondary">ไม่ใช้ในการประเมิน</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            {{ $parentQuestion->DtmIns->format('d/m/Y H:i') }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Create Question Form -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-question-circle me-2"></i>
                @if($parentQuestion)
                    ข้อมูลคำถามย่อย - {{ $group->name }}
                @else
                    ข้อมูลคำถาม - {{ $group->name }}
                @endif
            </h6>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.questions.store', $group) }}">
                @csrf
                
                <!-- Hidden input สำหรับ parent_id -->
                @if($parentQuestion)
                    <input type="hidden" name="parent_id" value="{{ $parentQuestion->id }}">
                @endif
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="question_text" class="form-label">คำถาม <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('question_text') is-invalid @enderror" 
                                      id="question_text" 
                                      name="question_text" 
                                      rows="3" 
                                      placeholder="กรอกคำถาม"
                                      required>{{ old('question_text') }}</textarea>
                            @error('question_text')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">คำอธิบายเพิ่มเติม</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="3" 
                                      placeholder="กรอกคำอธิบายเพิ่มเติม (ถ้ามี)">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="question_type" class="form-label">ประเภทคำตอบ <span class="text-danger">*</span></label>
                                    <select class="form-select @error('question_type') is-invalid @enderror" 
                                            id="question_type" 
                                            name="question_type" 
                                            required>
                                        <option value="yes_no" {{ old('question_type') == 'yes_no' ? 'selected' : '' }}>ใช่/ไม่ใช่ (Yes/No)</option>
                                        <option value="multiple_choice" {{ old('question_type') == 'multiple_choice' ? 'selected' : '' }}>ตัวเลือก (Multiple Choice)</option>
                                        <option value="text" {{ old('question_type') == 'text' ? 'selected' : '' }}>ข้อความ (Text)</option>
                                        <option value="" {{ old('question_type') === '' ? 'selected' : '' }}>ไม่มี</option>
                                    </select>
                                    @error('question_type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">เลือกประเภทคำตอบที่ต้องการ</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="keyword_tag" class="form-label">แท็กคำสำคัญ</label>
                                    <input type="text" 
                                           class="form-control @error('keyword_tag') is-invalid @enderror" 
                                           id="keyword_tag" 
                                           name="keyword_tag" 
                                           value="{{ old('keyword_tag') }}" 
                                           placeholder="กรอกแท็กคำสำคัญ (ถ้ามี)">
                                    @error('keyword_tag')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">แท็กสำหรับจัดหมวดหมู่คำถาม</small>
                                </div>
                            </div>
                        </div>

                        <!-- Choice Options for Multiple Choice Questions -->
                        <div id="choice_options_container" class="mb-3" style="display: none;">
                            <label class="form-label">ตัวเลือก <span class="text-danger">*</span></label>
                            <div id="choices_container">
                                <div class="choice-item mb-2">
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control choice-input" 
                                               name="choices[]" 
                                               placeholder="กรอกตัวเลือกที่ 1">
                                        <button type="button" class="btn btn-outline-danger remove-choice-btn">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="choice-item mb-2">
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control choice-input" 
                                               name="choices[]" 
                                               placeholder="กรอกตัวเลือกที่ 2">
                                        <button type="button" class="btn btn-outline-danger remove-choice-btn">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-choice-btn">
                                <i class="fas fa-plus me-1"></i>
                                เพิ่มตัวเลือก
                            </button>
                            <small class="form-text text-muted">กรอกตัวเลือกสำหรับคำถามแบบตัวเลือก</small>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-cog me-1"></i>
                                    ตั้งค่าเพิ่มเติม
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" 
                                               type="checkbox" 
                                               id="use_in_evaluation" 
                                               name="use_in_evaluation" 
                                               value="1"
                                               {{ old('use_in_evaluation') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="use_in_evaluation">
                                            ใช้ในการประเมิน
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">เลือกถ้าคำถามนี้จะใช้ในการประเมินผล (เฉพาะคำถามแบบ ใช่/ไม่ใช่ เท่านั้น)</small>
                                </div>
                                
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-1"></i>
                                    <strong>หมายเหตุ:</strong>
                                    <ul class="mb-0 mt-2">
                                        <li>สร้างคำถามก่อน แล้วใช้การลากเพื่อกำหนดความสัมพันธ์แม่-ลูก</li>
                                        <li>เงื่อนไขการเชื่อมต่อ (AND/OR) จะแสดงในหน้าแก้ไขกลุ่มคำถาม</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.question-groups.edit', $group) }}" class="btn btn-secondary">
                        <i class="fas fa-times me-1"></i>
                        ยกเลิก
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>
                        บันทึกคำถาม
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const questionTypeSelect = document.getElementById('question_type');
    const choiceOptionsContainer = document.getElementById('choice_options_container');
    const addChoiceBtn = document.getElementById('add-choice-btn');
    const choicesContainer = document.getElementById('choices_container');

    // Show/hide choice options based on question type
    questionTypeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        const useInEvaluationCheckbox = document.getElementById('use_in_evaluation');
        const choiceInputs = document.querySelectorAll('.choice-input');
        
        if (selectedType === 'multiple_choice') {
            choiceOptionsContainer.style.display = 'block';
            // multiple_choice ไม่ใช้ในการประเมินเสมอ
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            // เพิ่ม hidden input เพื่อส่งค่า 0
            addHiddenInput('use_in_evaluation', '0');
            // เพิ่ม required ให้ choice inputs
            choiceInputs.forEach(input => {
                input.required = true;
            });
        } else if (selectedType === 'text') {
            choiceOptionsContainer.style.display = 'none';
            // text ไม่ใช้ในการประเมินเสมอ
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            // เพิ่ม hidden input เพื่อส่งค่า 0
            addHiddenInput('use_in_evaluation', '0');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        } else if (selectedType === '') { // เลือก "ไม่มี"
            choiceOptionsContainer.style.display = 'none';
            // "ไม่มี" ไม่ใช้ในการประเมินเสมอ
            useInEvaluationCheckbox.checked = false;
            useInEvaluationCheckbox.disabled = true;
            // เพิ่ม hidden input เพื่อส่งค่า 0
            addHiddenInput('use_in_evaluation', '0');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        } else { // yes_no สามารถเลือกใช้ในการประเมินได้
            choiceOptionsContainer.style.display = 'none';
            // yes_no สามารถเลือกใช้ในการประเมินได้
            useInEvaluationCheckbox.disabled = false;
            // ลบ hidden input ถ้ามี
            removeHiddenInput('use_in_evaluation');
            // ลบ required จาก choice inputs
            choiceInputs.forEach(input => {
                input.required = false;
            });
        }
    });

    // Add new choice option
    function addChoice() {
        const choiceItems = document.querySelectorAll('.choice-item');
        const newIndex = choiceItems.length + 1;
        
        const newChoiceItem = document.createElement('div');
        newChoiceItem.className = 'choice-item mb-2';
        newChoiceItem.innerHTML = `
            <div class="input-group">
                <span class="input-group-text">${newIndex}</span>
                <input type="text" 
                       class="form-control choice-input" 
                       name="choices[]" 
                       placeholder="กรอกตัวเลือกที่ ${newIndex}">
                <button type="button" 
                        class="btn btn-outline-danger remove-choice-btn">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        `;
        
        choicesContainer.appendChild(newChoiceItem);
        updateChoiceNumbers();
        updateRemoveButtons();
        
        // เพิ่ม required ถ้าประเภทคำถามเป็น multiple_choice
        const questionType = document.getElementById('question_type').value;
        if (questionType === 'multiple_choice') {
            const newInput = newChoiceItem.querySelector('.choice-input');
            newInput.required = true;
        }
    }

    // Remove choice option
    function removeChoice(button) {
        const choiceItem = button.closest('.choice-item');
        choiceItem.remove();
        updateChoiceNumbers();
        updateRemoveButtons();
    }

    // Update choice numbers
    function updateChoiceNumbers() {
        const choiceItems = document.querySelectorAll('.choice-item');
        choiceItems.forEach((item, index) => {
            const numberSpan = item.querySelector('.input-group-text');
            numberSpan.textContent = index + 1;
            
            const input = item.querySelector('.choice-input');
            input.placeholder = `กรอกตัวเลือกที่ ${index + 1}`;
        });
    }

    // Show/hide remove buttons based on number of choices
    function updateRemoveButtons() {
        const choiceItems = document.querySelectorAll('.choice-item');
        const removeButtons = document.querySelectorAll('.remove-choice-btn');
        
        removeButtons.forEach(button => {
            if (choiceItems.length > 2) {
                button.style.display = 'block';
            } else {
                button.style.display = 'none';
            }
        });
    }

    // Event listeners
    addChoiceBtn.addEventListener('click', addChoice);
    
    // Event delegation for remove buttons
    choicesContainer.addEventListener('click', function(e) {
        if (e.target.closest('.remove-choice-btn')) {
            removeChoice(e.target.closest('.remove-choice-btn'));
        }
    });

    // Initial setup
    updateRemoveButtons();
});

// ฟังก์ชันเพิ่ม hidden input
function addHiddenInput(name, value) {
    // ลบ hidden input เดิมถ้ามี
    removeHiddenInput(name);
    
    const hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = name;
    hiddenInput.value = value;
    hiddenInput.id = 'hidden_' + name;
    
    document.querySelector('form').appendChild(hiddenInput);
}

// ฟังก์ชันลบ hidden input
function removeHiddenInput(name) {
    const hiddenInput = document.getElementById('hidden_' + name);
    if (hiddenInput) {
        hiddenInput.remove();
    }
}
</script>
@endsection 