@extends('layouts.app')

@section('content')
<div class="container">
  <h2>เริ่มการประเมิน: {{ $product->name }}</h2>

  <form method="POST" action="{{ route('assessments.store') }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="product_id" value="{{ $product->id }}">

    @foreach($questionGroups as $groupIndex => $group)
      <div class="card mb-4">
        <div class="card-header">
          <strong>{{ $groupIndex + 1 }}. {{ $group->title }}</strong>
        </div>
        <div class="card-body">
          @foreach($group->questions as $questionIndex => $question)
            <div class="mb-4">
              <label class="form-label question-label">
                <span class="question-number-inline">{{ $groupIndex + 1 }}.{{ $questionIndex + 1 }}.</span> {{ $question->question_text }}
              </label>
              
              <!-- คำถามแบบ ใช่/ไม่ใช่ -->
              <div class="mb-3">
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="answers[{{ $question->id }}][choice]" id="yes_{{ $question->id }}" value="yes" required>
                  <label class="form-check-label" for="yes_{{ $question->id }}">ใช่</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="answers[{{ $question->id }}][choice]" id="no_{{ $question->id }}" value="no" required>
                  <label class="form-check-label" for="no_{{ $question->id }}">ไม่ใช่</label>
                </div>
              </div>

              <!-- ข้อความเพิ่มเติม (แสดงเมื่อเลือก ใช่) -->
              <div class="mb-3" id="details_{{ $question->id }}" style="display: none;">
                <label class="form-label">รายละเอียดเพิ่มเติม (กรณีตอบว่าใช่)</label>
                <textarea name="answers[{{ $question->id }}][details]" class="form-control" rows="2"></textarea>
              </div>

              <label class="form-label mt-2">รูปภาพ (ถ้ามี)</label>
              <input type="file" name="answers[{{ $question->id }}][image]" class="form-control" accept="image/*">

              <label class="form-label mt-2">หมายเหตุ (ถ้ามี)</label>
              <textarea name="answers[{{ $question->id }}][comment]" class="form-control" rows="2"></textarea>
            </div>
          @endforeach
        </div>
      </div>
    @endforeach

    <button type="submit" class="btn btn-primary">ส่งแบบประเมิน</button>
    <a href="{{ route('products.index') }}" class="btn btn-secondary">ยกเลิก</a>
  </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // จัดการการแสดง/ซ่อนช่องรายละเอียดเพิ่มเติม
  const radioButtons = document.querySelectorAll('input[type="radio"]');
  radioButtons.forEach(radio => {
    radio.addEventListener('change', function() {
      const questionId = this.name.match(/\[(\d+)\]/)[1];
      const detailsDiv = document.getElementById('details_' + questionId);
      
      if (this.value === 'yes') {
        detailsDiv.style.display = 'block';
      } else {
        detailsDiv.style.display = 'none';
        // ล้างข้อมูลในช่องรายละเอียดเมื่อเลือก ไม่ใช่
        detailsDiv.querySelector('textarea').value = '';
      }
    });
  });
});
</script>
@endsection