@extends('layouts.app')

@section('content')
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h4 class="text-center mb-0">
                            <i class="fas fa-user-plus me-2"></i>
                            {{ __('ลงทะเบียน') }}
                        </h4>
                    </div>
                    <div class="card-body p-4">
                        <form method="POST" action="{{ route('register') }}">
                            @csrf

                            <!-- ชื่อ (Customer_Name) -->
                            <div class="mb-3">
                                <label for="customer_name" class="form-label">
                                    <i class="fas fa-user me-1"></i>
                                    {{ __('ชื่อ') }}
                                </label>
                                <input id="customer_name" class="form-control @error('customer_name') is-invalid @enderror" 
                                       type="text" name="customer_name" value="{{ old('customer_name') }}" 
                                       placeholder="{{ __('กรอกชื่อของคุณ') }}"
                                       required autofocus autocomplete="name">
                                @error('customer_name')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- อีเมล (Email) -->
                            <div class="mb-3">
                                <label for="email" class="form-label">
                                    <i class="fas fa-envelope me-1"></i>
                                    {{ __('อีเมล') }}
                                </label>
                                <input id="email" class="form-control @error('email') is-invalid @enderror" 
                                       type="email" name="email" value="{{ old('email') }}" 
                                       placeholder="{{ __('example@email.com') }}"
                                       required autocomplete="username">
                                @error('email')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- เบอร์โทรศัพท์ (Mobile_Number) -->
                            <div class="mb-3">
                                <label for="mobile_number" class="form-label">
                                    <i class="fas fa-phone me-1"></i>
                                    {{ __('เบอร์โทรศัพท์') }}
                                </label>
                                <input id="mobile_number" class="form-control @error('mobile_number') is-invalid @enderror"
                                       type="tel" name="mobile_number" value="{{ old('mobile_number') }}"
                                       placeholder="{{ __('081-234-5678') }}"
                                       required autocomplete="tel">
                                @error('mobile_number')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- ชื่อบริษัท (Agency_Name) -->
                            <div class="mb-3">
                                <label for="agency_name" class="form-label">
                                    <i class="fas fa-building me-1"></i>
                                    {{ __('ชื่อบริษัท') }}
                                </label>
                                <input id="agency_name" class="form-control @error('agency_name') is-invalid @enderror"
                                       type="text" name="agency_name" value="{{ old('agency_name') }}"
                                       placeholder="{{ __('กรอกชื่อบริษัทของคุณ') }}"
                                       required autocomplete="organization">
                                @error('agency_name')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- รหัสผ่าน (Password) -->
                            <div class="mb-3">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-1"></i>
                                    {{ __('รหัสผ่าน') }}
                                </label>
                                <input id="password" class="form-control @error('password') is-invalid @enderror"
                                       type="password" name="password" 
                                       placeholder="{{ __('รหัสผ่านอย่างน้อย 8 ตัวอักษร') }}"
                                       required autocomplete="new-password">
                                @error('password')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- ยืนยันรหัสผ่าน -->
                            <div class="mb-4">
                                <label for="password_confirmation" class="form-label">
                                    <i class="fas fa-lock me-1"></i>
                                    {{ __('ยืนยันรหัสผ่าน') }}
                                </label>
                                <input id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror"
                                       type="password" name="password_confirmation" 
                                       placeholder="{{ __('กรอกรหัสผ่านอีกครั้ง') }}"
                                       required autocomplete="new-password">
                                @error('password_confirmation')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="d-flex justify-content-between align-items-center">
                                <a class="text-decoration-none text-muted" href="{{ route('login') }}">
                                    <i class="fas fa-sign-in-alt me-1"></i>
                                    {{ __('มีบัญชีผู้ใช้งานแล้ว?') }}
                                </a>

                                <button type="submit" class="btn btn-primary px-4">
                                    <i class="fas fa-user-plus me-1"></i>
                                    {{ __('ลงทะเบียน') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
