@extends('layouts.app')

@section('content')
<div class="container mt-4">
  <div class="row justify-content-center">
    <div class="col-md-8">
      <!-- Progress Bar -->
      <div class="card shadow mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">
              <i class="fas fa-tasks me-2"></i>
              @if(!isset($validated))
              ความคืบหน้าการกรอกข้อมูลผลิตภัณฑ์
              @else
              ความคืบหน้าการประเมินคู่มือ
              @endif
            </h6>
            <span id="progress-text" class="badge bg-primary">0/5</span>
          </div>
          <div class="progress" style="height: 10px;">
            <div id="progress-bar" class="progress-bar bg-primary" role="progressbar" style="width: 0%"></div>
          </div>
          <div id="progress-status" class="text-muted small mt-2">
            @if(!isset($validated))
            กรุณากรอกข้อมูลผลิตภัณฑ์ให้ครบถ้วน
            @else
            กรุณาตอบคำถามการประเมินให้ครบถ้วน
            @endif
          </div>
        </div>
      </div>

      @if(!isset($validated))
      <!-- ฟอร์มเพิ่มผลิตภัณฑ์ -->
      <div class="card shadow">
        <div class="card-header bg-primary text-white">
          <h4 class="mb-0">
            <i class="fas fa-plus me-2"></i>
            {{ __('เพิ่มผลิตภัณฑ์') }}
          </h4>
        </div>

        <div class="card-body p-4">
          <form method="POST" action="{{ route('products.store') }}" enctype="multipart/form-data" id="product-form">
            @csrf

            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-box me-1"></i>
                    {{ __('ชื่อผลิตภัณฑ์') }}
                    <span class="text-danger">*</span>
                  </label>
                  <input type="text" class="form-control @error('name') is-invalid @enderror form-field"
                    name="name" required value="{{ old('name') }}"
                    placeholder="{{ __('กรอกชื่อผลิตภัณฑ์') }}" data-field="name">
                  @error('name')
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    {{ $message }}
                  </div>
                  @enderror
                </div>
              </div>

              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-tag me-1"></i>
                    {{ __('รุ่น') }}
                    <span class="text-danger">*</span>
                  </label>
                  <input type="text" class="form-control @error('model') is-invalid @enderror form-field"
                    name="model" value="{{ old('model') }}"
                    placeholder="{{ __('กรอกรุ่นผลิตภัณฑ์') }}" data-field="model">
                  @error('model')
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    {{ $message }}
                  </div>
                  @enderror
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-network-wired me-1"></i>
                    {{ __('วิธีรับข้อมูล') }}
                    <span class="text-danger">*</span>
                  </label>
                  <select name="log_receive_method" class="form-select @error('log_receive_method') is-invalid @enderror form-field" required data-field="log_receive_method">
                    <option value="">{{ __('--เลือกวิธีรับข้อมูล--') }}</option>
                    <option value="syslog_udp" {{ old('log_receive_method') == 'syslog_udp' ? 'selected' : '' }}>syslog UDP</option>
                    <option value="syslog_tcp" {{ old('log_receive_method') == 'syslog_tcp' ? 'selected' : '' }}>syslog TCP</option>
                    <option value="syslog_both" {{ old('log_receive_method') == 'syslog_both' ? 'selected' : '' }}>syslog UDP และ syslog TCP</option>
                    <option value="other" {{ old('log_receive_method') == 'other' ? 'selected' : '' }}>{{ __('อื่นๆ') }}</option>
                  </select>
                  @error('log_receive_method')
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    {{ $message }}
                  </div>
                  @enderror
                </div>
              </div>

              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-server me-1"></i>
                    {{ __('ประเภทผลิตภัณฑ์') }}
                    <span class="text-danger">*</span>
                  </label>
                  <select name="product_type" class="form-select @error('product_type') is-invalid @enderror form-field" required data-field="product_type">
                    <option value="">{{ __('--เลือกประเภทผลิตภัณฑ์--') }}</option>
                    <option value="hw_sw_log_server" {{ old('product_type') == 'hw_sw_log_server' ? 'selected' : '' }}>{{ __('Hardware + Software Log Server') }}</option>
                    <option value="sw_log_server" {{ old('product_type') == 'sw_log_server' ? 'selected' : '' }}>{{ __('Software Log Server') }}</option>
                  </select>
                  @error('product_type')
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    {{ $message }}
                  </div>
                  @enderror
                </div>
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label">
                <i class="fas fa-image me-1"></i>
                {{ __('รูปภาพผลิตภัณฑ์') }}
                <span class="text-danger">*</span>
              </label>
              <input type="file" class="form-control @error('image') is-invalid @enderror form-field"
                name="image" accept="image/*" data-field="image">
              <div class="form-text">{{ __('รองรับไฟล์: JPEG, PNG, JPG, GIF, SVG ขนาดไม่เกิน 2MB') }}</div>
              @error('image')
              <div class="invalid-feedback">
                <i class="fas fa-exclamation-circle me-1"></i>
                {{ $message }}
              </div>
              @enderror
            </div>

            <div class="mb-4">
              <label class="form-label">
                <i class="fas fa-align-left me-1"></i>
                {{ __('คำอธิบาย') }}
                <span class="text-muted">(ไม่บังคับ)</span>
              </label>
              <textarea name="description" class="form-control @error('description') is-invalid @enderror"
                rows="4" placeholder="{{ __('กรอกคำอธิบายผลิตภัณฑ์ (ไม่บังคับ)') }}">{{ old('description') }}</textarea>
              @error('description')
              <div class="invalid-feedback">
                <i class="fas fa-exclamation-circle me-1"></i>
                {{ $message }}
              </div>
              @enderror
            </div>

            <div class="d-flex justify-content-end gap-2">
              <a href="{{ route('products.index') }}" class="btn btn-secondary">
                <i class="fas fa-times me-1"></i>
                {{ __('ยกเลิก') }}
              </a>
              <button type="submit" class="btn btn-primary" id="submit-btn">
                <i class="fas fa-arrow-right me-1"></i>
                {{ __('ถัดไป') }}
              </button>
            </div>
          </form>
        </div>
      </div>

      @else
      <!-- ฟอร์มประเมินคู่มือ -->
      <div class="card shadow">
        <div class="card-header bg-success text-white">
          <h4 class="mb-0">
            <i class="fas fa-clipboard-check me-2"></i>
            {{ __('แบบประเมินคู่มือ') }}
          </h4>
        </div>

        <div class="card-body p-4 pb-0">
          <!-- แสดงข้อมูลผลิตภัณฑ์ที่กรอกไว้ -->
          <div class="alert alert-info border-0 shadow-sm mb-4">
            <div class="d-flex align-items-center">
              <i class="fas fa-info-circle fa-2x me-3 text-info"></i>
              <div>
                <h6 class="alert-heading mb-1">ข้อมูลผลิตภัณฑ์ที่กรอกไว้</h6>
                <p class="mb-1"><strong>ชื่อ:</strong> {{ $validated['name'] }}</p>
                <p class="mb-1"><strong>รุ่น:</strong> {{ $validated['model'] ?? 'ไม่ระบุ' }}</p>
                <p class="mb-0"><strong>ประเภท:</strong> {{ $validated['product_type'] == 'hw_sw_log_server' ? 'Hardware + Software Log Server' : 'Software Log Server' }}</p>
              </div>
            </div>
          </div>
        </div>

        <!-- คำแนะนำ -->
        <div class="alert alert-info border-0 shadow-sm m-3 mt-0">
          <div class="d-flex align-items-center">
            <i class="fas fa-info-circle fa-2x me-3 text-info"></i>
            <div>
              <h6 class="alert-heading mb-1">คำแนะนำในการประเมิน</h6>
              <p class="mb-0 small">กรุณาอ่านคำถามอย่างละเอียดและตอบตามความจริง เพื่อให้ได้ผลการประเมินที่แม่นยำ</p>
            </div>
          </div>
        </div>

        <form method="POST" action="{{ route('assessments.store') }}" id="assessment-form">
          @csrf

          <!-- แสดงคำถามโดยตรง -->
          <div class="m-3">
            @php
              $globalQuestionNumber = 1;
            @endphp
            @foreach($questionGroups as $groupIndex => $group)
            <div class="mb-4">
                  <div class="row">
                    @foreach($group->questions as $questionIndex => $question)
                    @if($question->use_in_evaluation && !$question->parent_id && $question->question_type !== null)
                    <!-- คำถามปกติที่ใช้ในการประเมิน (ไม่มี parent และ question_type ไม่เป็น null) -->
                    <div class="col-12 mb-4">
                      <div class="card border-0 shadow-sm">
                        <div class="card-body p-4">
                          <div class="d-flex align-items-start mb-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; min-width: 40px;">
                          <span class="question-number">{{ $globalQuestionNumber }}</span>
                            </div>
                            <div class="flex-grow-1">
                              <h6 class="card-title mb-2 question-label">{{ $question->question_text }}</h6>
                              <!-- ฟอร์มตอบคำถาม -->
                              @if($question->question_type == 'yes_no')
                                <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                <div class="mb-3">
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio" 
                                           name="answers[{{ $question->id }}][choice]" 
                                           id="yes_{{ $question->id }}" 
                                           value="yes" 
                                           data-question-id="{{ $question->id }}">
                                    <label class="form-check-label" for="yes_{{ $question->id }}">
                                      ใช่
                                    </label>
                                  </div>
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio" 
                                           name="answers[{{ $question->id }}][choice]" 
                                           id="no_{{ $question->id }}" 
                                           value="no" 
                                           data-question-id="{{ $question->id }}">
                                    <label class="form-check-label" for="no_{{ $question->id }}">
                                      ไม่ใช่
                                    </label>
                                  </div>
                                </div>
                                <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                <div id="text_field_{{ $question->id }}" class="mt-3" style="display: none;">
                                  <label class="form-label text-muted">
                                    <i class="fas fa-comment me-1"></i>
                                    กรุณาระบุรายละเอียดเพิ่มเติม:
                                  </label>
                                  <textarea
                                    name="answers[{{ $question->id }}][details]"
                                    class="form-control border-0 bg-light evaluation-field"
                                    rows="3"
                                    placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                    style="resize: none;"
                                    data-field="evaluation_{{ $question->id }}_details"></textarea>
                                </div>
                          @elseif($question->question_type == 'multiple_choice')
                            <!-- สำหรับคำถามแบบตัวเลือก -->
                            <div class="mb-3">
                            @php
                                $choices = $question->choices;
                                if (is_string($choices)) {
                                    $choices = json_decode($choices, true);
                                }
                            @endphp
                            @if($choices && is_array($choices) && count($choices) > 0)
                                @foreach($choices as $choiceIndex => $choice)
                                    <div class="form-check">
                                        <input class="form-check-input multiple-choice-radio" type="radio"
                                            name="answers[{{ $question->id }}][choice]"
                                            id="choice_{{ $question->id }}_{{ $choiceIndex }}"
                                            value="{{ $choice }}"
                                            data-question-id="{{ $question->id }}">
                                        <label class="form-check-label" for="choice_{{ $question->id }}_{{ $choiceIndex }}">
                                            {{ $choice }}
                                        </label>
                                    </div>
                                    @endforeach
                            @else
                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                <div class="alert alert-warning border-0">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                    @if(config('app.debug'))
                                        <br><small class="text-muted">Debug: choices = {{ json_encode($question->choices) }}</small>
                              @endif
                            </div>
                                @endif
                          </div>
                          @elseif($question->question_type == 'text')
                            <!-- สำหรับคำถามแบบข้อความ -->
                            <div class="mb-3">
                                <textarea
                                    name="answers[{{ $question->id }}][text]"
                                    class="form-control border-0 bg-light evaluation-field"
                                    rows="3"
                                    placeholder="กรุณาตอบคำถาม..."
                                    style="resize: none;"
                                    data-field="evaluation_{{ $question->id }}_text"></textarea>
                        </div>
                          @endif
                      </div>
                    </div>
                    </div>
                  </div>
                </div>
                @php $globalQuestionNumber++; @endphp
                @elseif(!$question->use_in_evaluation && $question->question_type === null && !$question->parent_id)
                <!-- Parent Question (ระดับ 1) - แสดงเป็น accordion button เสมอ -->
                    <div class="col-12 mb-3">
                      <div class="accordion-item border-0">
                        <h2 class="accordion-header" id="heading-parent-{{ $question->id }}">
                          <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-parent-{{ $question->id }}" style="padding: 1.5rem;">
                            <div class="d-flex align-items-center w-100">
                              <div class="flex-grow-1">
                            <h6 class="mb-1 question-label">{{ $question->question_text }}</h6>
                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                              </div>
                              <i class="fas fa-chevron-down ms-auto"></i>
                            </div>
                          </button>
                        </h2>
                        <div id="collapse-parent-{{ $question->id }}" class="accordion-collapse collapse" aria-labelledby="heading-parent-{{ $question->id }}">
                          <div class="accordion-body bg-white p-4">
                            <div class="row">
                              @foreach($group->questions->where('parent_id', $question->id) as $childIndex => $child)
                              @if($child->use_in_evaluation && $child->question_type !== null)
                              <!-- Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                              <div class="col-12 mb-4">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body p-4">
                                        <div class="ms-4 border-start border-primary ps-3">
                                            <div class="d-flex align-items-start mb-3">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-2 text-dark">{{ $child->question_text }}</h6>
                                                    <!-- ฟอร์มตอบคำถาม -->
                                                    @if($child->question_type == 'yes_no')
                                                        <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                        <div class="mb-3">
                                                            <div class="form-check form-check-inline">
                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                    name="answers[{{ $child->id }}][choice]"
                                                                    id="yes_{{ $child->id }}"
                                                                    value="yes"
                                                                    data-question-id="{{ $child->id }}">
                                                                <label class="form-check-label" for="yes_{{ $child->id }}">
                                                                    ใช่
                                                                </label>
                                                            </div>
                                                            <div class="form-check form-check-inline">
                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                    name="answers[{{ $child->id }}][choice]"
                                                                    id="no_{{ $child->id }}"
                                                                    value="no"
                                                                    data-question-id="{{ $child->id }}">
                                                                <label class="form-check-label" for="no_{{ $child->id }}">
                                                                    ไม่ใช่
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                        <div id="text_field_{{ $child->id }}" class="mt-3" style="display: none;">
                                                            <label class="form-label text-muted">
                                                                <i class="fas fa-comment me-1"></i>
                                                                กรุณาระบุรายละเอียดเพิ่มเติม:
                                                            </label>
                                                            <textarea
                                                                name="answers[{{ $child->id }}][details]"
                                                                class="form-control border-0 bg-light evaluation-field"
                                                                rows="3"
                                                                placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                style="resize: none;"
                                                                data-field="evaluation_{{ $child->id }}_details"></textarea>
                                                        </div>
                                                    @elseif($child->question_type == 'multiple_choice')
                                                        <!-- สำหรับคำถามแบบตัวเลือก -->
                                                        <div class="mb-3">
                                                        @php
                                                            $choices = $child->choices;
                                                            if (is_string($choices)) {
                                                                $choices = json_decode($choices, true);
                                                            }
                                                        @endphp
                                                        @if($choices && is_array($choices) && count($choices) > 0)
                                                            @foreach($choices as $choiceIndex => $choice)
                                                                <div class="form-check">
                                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                                        name="answers[{{ $child->id }}][choice]"
                                                                        id="choice_{{ $child->id }}_{{ $choiceIndex }}"
                                                                        value="{{ $choice }}"
                                                                        data-question-id="{{ $child->id }}">
                                                                    <label class="form-check-label" for="choice_{{ $child->id }}_{{ $choiceIndex }}">
                                                                        {{ $choice }}
                                                                    </label>
                                                                </div>
                                                                @endforeach
                                                        @else
                                                            <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                            <div class="alert alert-warning border-0">
                                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                                ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                @if(config('app.debug'))
                                                                    <br><small class="text-muted">Debug: choices = {{ json_encode($child->choices) }}</small>
                                                                @endif
                                                            </div>
                                                            @endif
                                                        </div>
                                                    @elseif($child->question_type == 'text')
                                                        <!-- สำหรับคำถามแบบข้อความ -->
                                                        <div class="mb-3">
                                                            <textarea
                                                                name="answers[{{ $child->id }}][text]"
                                                                class="form-control border-0 bg-light evaluation-field"
                                                                rows="3"
                                                                placeholder="กรุณาตอบคำถาม..."
                                                                style="resize: none;"
                                                                data-field="evaluation_{{ $child->id }}_text"></textarea>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                              </div>
                              @php $globalQuestionNumber++; @endphp
                              @elseif(!$child->use_in_evaluation && $child->question_type !== null)
                              <!-- Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null (เช่น multiple_choice) -->
                                        <div class="col-12 mb-4">
                                          <div class="card border-0 shadow-sm">
                                              <div class="card-body p-4">
                                        <div class="ms-4 border-start border-secondary ps-3">
                                                      <div class="d-flex align-items-start mb-3">
                                                          <div class="flex-grow-1">
                                                    <h6 class="card-title mb-2 text-dark">{{ $child->question_text }}</h6>
                                                              <!-- ฟอร์มตอบคำถาม -->
                                                    @if($child->question_type == 'multiple_choice')
                                                                  <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                  <div class="mb-3">
                                                                  @php
                                                            $choices = $child->choices;
                                                                      if (is_string($choices)) {
                                                                          $choices = json_decode($choices, true);
                                                                      }
                                                                  @endphp
                                                                  @if($choices && is_array($choices) && count($choices) > 0)
                                                                      @foreach($choices as $choiceIndex => $choice)
                                                                          <div class="form-check">
                                                                    <input class="form-check-input" type="radio"
                                                                        name="answers[{{ $child->id }}][choice]"
                                                                        id="choice_{{ $child->id }}_{{ $choiceIndex }}"
                                                                        value="{{ $choice }}">
                                                                    <label class="form-check-label" for="choice_{{ $child->id }}_{{ $choiceIndex }}">
                                                                                  {{ $choice }}
                                                                              </label>
                                                                          </div>
                                                                          @endforeach
                                                                  @else
                                                                      <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                      <div class="alert alert-warning border-0">
                                                                          <i class="fas fa-exclamation-triangle me-2"></i>
                                                                          ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                          @if(config('app.debug'))
                                                                    <br><small class="text-muted">Debug: choices = {{ json_encode($child->choices) }}</small>
                                                                          @endif
                                                                      </div>
                                                                      @endif
                                                                  </div>
                                                    @elseif($child->question_type == 'text')
                                                                  <!-- สำหรับคำถามแบบข้อความ -->
                                                                  <div class="mb-3">
                                                                      <textarea
                                                                name="answers[{{ $child->id }}][text]"
                                                                class="form-control border-0 bg-light"
                                                                          rows="3"
                                                                          placeholder="กรุณาตอบคำถาม..."
                                                                style="resize: none;"></textarea>
                                                                  </div>
                                                              @endif
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                        </div>
                              @elseif(!$child->use_in_evaluation && $child->question_type === null)
                              <!-- Child Questions ที่ไม่ใช้ในการประเมินและ question_type เป็น null - แสดงเป็น accordion button -->
                                    <div class="col-12 mb-3">
                                      <div class="accordion-item border-0">
                                  <h2 class="accordion-header" id="heading-child-{{ $child->id }}">
                                    <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-child-{{ $child->id }}" style="padding: 1.25rem;">
                                            <div class="d-flex align-items-center w-100">
                                              <div class="flex-grow-1">
                                          <h6 class="mb-1 question-label">{{ $child->question_text }}</h6>
                                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                                              </div>
                                              <i class="fas fa-chevron-down ms-auto"></i>
                                            </div>
                                          </button>
                                        </h2>
                                  <div id="collapse-child-{{ $child->id }}" class="accordion-collapse collapse" aria-labelledby="heading-child-{{ $child->id }}">
                                          <div class="accordion-body bg-white p-4">
                                            <div class="row">
                                        @foreach($group->questions->where('parent_id', $child->id) as $grandChildIndex => $grandChild)
                                        @if($grandChild->use_in_evaluation && $grandChild->question_type !== null)
                                        <!-- Grand Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                                        <div class="col-12 mb-4">
                                                <div class="card border-0 shadow-sm">
                                              <div class="card-body p-4">
                                                        <div class="ms-4 border-start border-primary ps-3">
                                                      <div class="d-flex align-items-start mb-3">
                                                          <div class="flex-grow-1">
                                                              <h6 class="card-title mb-2 text-dark">{{ $grandChild->question_text }}</h6>
                                                                    <!-- ฟอร์มตอบคำถาม -->
                                                              @if($grandChild->question_type == 'yes_no')
                                                                        <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                                        <div class="mb-3">
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                              name="answers[{{ $grandChild->id }}][choice]"
                                                                              id="yes_{{ $grandChild->id }}"
                                                                                    value="yes"
                                                                              data-question-id="{{ $grandChild->id }}">
                                                                          <label class="form-check-label" for="yes_{{ $grandChild->id }}">
                                                                                    ใช่
                                                                                </label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                              name="answers[{{ $grandChild->id }}][choice]"
                                                                              id="no_{{ $grandChild->id }}"
                                                                                    value="no"
                                                                              data-question-id="{{ $grandChild->id }}">
                                                                          <label class="form-check-label" for="no_{{ $grandChild->id }}">
                                                                                    ไม่ใช่
                                                                                </label>
                                                                            </div>
                                                                        </div>
                                                                        <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                                  <div id="text_field_{{ $grandChild->id }}" class="mt-3" style="display: none;">
                                                                            <label class="form-label text-muted">
                                                                                <i class="fas fa-comment me-1"></i>
                                                                                กรุณาระบุรายละเอียดเพิ่มเติม:
                                                                            </label>
                                                                            <textarea
                                                                          name="answers[{{ $grandChild->id }}][details]"
                                                                                class="form-control border-0 bg-light evaluation-field"
                                                                                rows="3"
                                                                                placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                                style="resize: none;"
                                                                          data-field="evaluation_{{ $grandChild->id }}_details"></textarea>
                                                                        </div>
                                                              @elseif($grandChild->question_type == 'multiple_choice')
                                                                        <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                        <div class="mb-3">
                                                                            @php
                                                                      $choices = $grandChild->choices;
                                                                                if (is_string($choices)) {
                                                                                    $choices = json_decode($choices, true);
                                                                                }
                                                                            @endphp
                                                                            @if($choices && is_array($choices) && count($choices) > 0)
                                                                                @foreach($choices as $choiceIndex => $choice)
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                                                  name="answers[{{ $grandChild->id }}][choice]"
                                                                                  id="choice_{{ $grandChild->id }}_{{ $choiceIndex }}"
                                                                                        value="{{ $choice }}"
                                                                                  data-question-id="{{ $grandChild->id }}">
                                                                              <label class="form-check-label" for="choice_{{ $grandChild->id }}_{{ $choiceIndex }}">
                                                                                        {{ $choice }}
                                                                                    </label>
                                                                                </div>
                                                                                @endforeach
                                                                            @else
                                                                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                                <div class="alert alert-warning border-0">
                                                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                    @if(config('app.debug'))
                                                                              <br><small class="text-muted">Debug: choices = {{ json_encode($grandChild->choices) }}</small>
                                                                                    @endif
                                                                                </div>
                                                                            @endif
                                                                        </div>
                                                              @elseif($grandChild->question_type == 'text')
                                                                        <!-- สำหรับคำถามแบบข้อความ -->
                                                                        <div class="mb-3">
                                                                            <textarea
                                                                          name="answers[{{ $grandChild->id }}][text]"
                                                                                class="form-control border-0 bg-light evaluation-field"
                                                                                rows="3"
                                                                                placeholder="กรุณาตอบคำถาม..."
                                                                                style="resize: none;"
                                                                          data-field="evaluation_{{ $grandChild->id }}_text"></textarea>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                              </div>
                                        @php $globalQuestionNumber++; @endphp
                                    @elseif(!$grandChild->use_in_evaluation && $grandChild->question_type !== null)
                                    <!-- Grand Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null -->
                                              <div class="col-12 mb-4">
                                                <div class="card border-0 shadow-sm">
                                                    <div class="card-body p-4">
                                              <div class="ms-4 border-start border-secondary ps-3">
                                                            <div class="d-flex align-items-start mb-3">
                                                                <div class="flex-grow-1">
                                                          <h6 class="card-title mb-2 text-dark">{{ $grandChild->question_text }}</h6>
                                                                    <!-- ฟอร์มตอบคำถาม -->
                                                          @if($grandChild->question_type == 'multiple_choice')
                                                                  <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                  <div class="mb-3">
                                                                            @php
                                                                  $choices = $grandChild->choices;
                                                                                if (is_string($choices)) {
                                                                                    $choices = json_decode($choices, true);
                                                                                }
                                                                            @endphp
                                                                            @if($choices && is_array($choices) && count($choices) > 0)
                                                                                @foreach($choices as $choiceIndex => $choice)
                                                                          <div class="form-check">
                                                                              <input class="form-check-input" type="radio"
                                                                            name="answers[{{ $grandChild->id }}][choice]"
                                                                            id="choice_{{ $grandChild->id }}_{{ $choiceIndex }}"
                                                                                  value="{{ $choice }}">
                                                                        <label class="form-check-label" for="choice_{{ $grandChild->id }}_{{ $choiceIndex }}">
                                                                                  {{ $choice }}
                                                                              </label>
                                                                          </div>
                                                                          @endforeach
                                                                            @else
                                                                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                                <div class="alert alert-warning border-0">
                                                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                    @if(config('app.debug'))
                                                                          <br><small class="text-muted">Debug: choices = {{ json_encode($grandChild->choices) }}</small>
                                                                      @endif
                                                                  </div>
                                                                            @endif
                                                                        </div>
                                                      @elseif($grandChild->question_type == 'text')
                                                                  <!-- สำหรับคำถามแบบข้อความ -->
                                                                  <div class="mb-3">
                                                                      <textarea
                                                                  name="answers[{{ $grandChild->id }}][text]"
                                                                          class="form-control border-0 bg-light"
                                                                          rows="3"
                                                                          placeholder="กรุณาตอบคำถาม..."
                                                                          style="resize: none;"></textarea>
                                                                  </div>
                                                              @endif
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                        </div>
                                        @endif
                                        @endforeach
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              @endif
                              @endforeach
                  </div>
                </div>
                @endif
                @endforeach
              </div>
            </div>
            @endforeach
          </div>

          <!-- ปุ่มส่งแบบฟอร์ม -->
          <div class="text-center mt-4">
            <div class="d-flex justify-content-center gap-3">
              <button type="button" class="btn btn-secondary btn-lg px-4" onclick="history.back()">
                <i class="fas fa-arrow-left me-2"></i>
                ย้อนกลับ
              </button>
              <button type="submit" formaction="{{ route('assessments.store-draft') }}" class="btn btn-warning btn-lg px-4" id="draft-submit-btn">
                <i class="fas fa-save me-2"></i>
                บันทึกฉบับร่าง
              </button>
              <button type="submit" class="btn btn-success btn-lg px-5" id="evaluation-submit-btn" style="display: none;">
                <i class="fas fa-paper-plane me-2"></i>
                ส่งแบบประเมิน
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
    @endif
  </div>
</div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const formFields = document.querySelectorAll('.form-field');
    const evaluationFields = document.querySelectorAll('.evaluation-field');
    const progressBar = document.getElementById('progress-bar');
    const progressText = document.getElementById('progress-text');
    const progressStatus = document.getElementById('progress-status');
    const submitBtn = document.getElementById('submit-btn');
    const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');

    // ตรวจสอบว่าอยู่ในฟอร์มไหน
    const isEvaluationForm = evaluationFields.length > 0;

    let totalFields, completedFields;

    if (isEvaluationForm) {
      // สำหรับฟอร์มประเมิน
      // นับจำนวนคำถามทั้งหมดที่ต้องตอบ
      const questionIds = new Set();
      
      // นับ radio buttons (yes_no เท่านั้น)
      const selectedRadios = document.querySelectorAll('.yes-no-radio');
      selectedRadios.forEach(radio => {
        questionIds.add(radio.getAttribute('data-question-id'));
      });

      totalFields = questionIds.size;
      completedFields = 0;
    } else {
      // สำหรับฟอร์มเพิ่มผลิตภัณฑ์
      totalFields = 5; // จำนวนฟิลด์ที่จำเป็น
      completedFields = 0;
    }

    // ฟังก์ชันตรวจสอบว่าฟิลด์มีข้อมูลหรือไม่
    function isFieldFilled(field) {
      if (field.type === 'file') {
        return field.files.length > 0;
      } else if (field.tagName === 'SELECT') {
        return field.value !== '';
      } else {
        return field.value.trim() !== '';
      }
    }

    // ฟังก์ชันอัปเดต progress
    function updateProgress() {
      completedFields = 0;
        const answeredQuestions = new Set();
        
        // นับ radio buttons ที่เลือกแล้ว (yes_no เท่านั้น)
        const selectedRadios = document.querySelectorAll('.yes-no-radio:checked');
        selectedRadios.forEach(radio => {
          answeredQuestions.add(radio.getAttribute('data-question-id'));
        });
        
        completedFields = answeredQuestions.size;

      const percentage = totalFields > 0 ? (completedFields / totalFields) * 100 : 0;

      // อัปเดต progress bar
      progressBar.style.width = percentage + '%';

      // อัปเดตข้อความและปุ่ม
      if (completedFields === totalFields && totalFields > 0) {
        progressText.textContent = 'Complete!';
        progressText.className = 'badge bg-success';
        progressStatus.textContent = 'พร้อมส่งแบบประเมิน';
        
        // ซ่อนปุ่มบันทึกฉบับร่างและแสดงปุ่มส่งแบบประเมิน
        const draftSubmitBtn = document.getElementById('draft-submit-btn');
        const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
        
        if (draftSubmitBtn) {
          draftSubmitBtn.style.display = 'none';
        }
        if (evaluationSubmitBtn) {
          evaluationSubmitBtn.style.display = 'inline-block';
          evaluationSubmitBtn.disabled = false;
        }
      } else {
        progressText.textContent = `${completedFields}/${totalFields}`;
        progressText.className = 'badge bg-warning';
        progressStatus.textContent = `กรุณาตอบคำถามให้ครบถ้วน (${completedFields}/${totalFields})`;
        
        // แสดงปุ่มบันทึกฉบับร่างและซ่อนปุ่มส่งแบบประเมิน
        const draftSubmitBtn = document.getElementById('draft-submit-btn');
        const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
        
        if (draftSubmitBtn) {
          draftSubmitBtn.style.display = 'inline-block';
          draftSubmitBtn.disabled = false;
        }
        if (evaluationSubmitBtn) {
          evaluationSubmitBtn.style.display = 'none';
        }
      }
    }

    // เพิ่ม event listener สำหรับฟิลด์
    if (isEvaluationForm) {
      evaluationFields.forEach(field => {
        field.addEventListener('input', updateProgress);
        field.addEventListener('change', updateProgress);
      });
    } else {
      formFields.forEach(field => {
        field.addEventListener('input', updateProgress);
        field.addEventListener('change', updateProgress);
      });
    }

    // จัดการการแสดง/ซ่อนฟิลด์ text สำหรับคำถามแบบ yes_no
    const yesNoRadios = document.querySelectorAll('.yes-no-radio');
    yesNoRadios.forEach(radio => {
      radio.addEventListener('change', function() {
        const questionId = this.getAttribute('data-question-id');
        const textField = document.getElementById(`text_field_${questionId}`);
        const detailsField = document.querySelector(`textarea[name="answers[${questionId}][details]"]`);

        if (this.value === 'yes') {
          // แสดงฟิลด์ text เมื่อเลือก "ใช่" (ไม่บังคับกรอก)
          textField.style.display = 'block';
          if (detailsField) {
            detailsField.required = false; // ไม่บังคับกรอก
            detailsField.classList.add('evaluation-field');
          }
        } else {
          // ซ่อนฟิลด์ text เมื่อเลือก "ไม่ใช่"
          textField.style.display = 'none';
          if (detailsField) {
            detailsField.required = false;
            detailsField.value = '';
            detailsField.classList.remove('evaluation-field');
          }
        }

        // อัปเดต progress
        updateProgress();
      });
    });

    // เพิ่ม event listener สำหรับ radio buttons เพื่อนับ progress
    yesNoRadios.forEach(radio => {
      radio.addEventListener('change', updateProgress);
    });

    // ตรวจสอบสถานะเริ่มต้น
    updateProgress();

    // Accordion Button Animation
    const accordionButtons = document.querySelectorAll('.accordion-button');
    
    accordionButtons.forEach(button => {
      button.addEventListener('click', function(e) {
        // หยุดการทำงานของ event listener อื่นๆ ที่อาจขัดแย้ง
        e.stopPropagation();
        
        // หาลูกศรที่อยู่ในปุ่มนี้เท่านั้น
        const icon = this.querySelector('.fas.fa-chevron-down');
        if (icon) {
          // หมุนไอคอนเมื่อคลิกที่ไหนก็ได้ในปุ่ม
          if (this.classList.contains('collapsed')) {
            // เมื่อ accordion ปิด (collapsed) ลูกศรชี้ลง
            icon.style.transform = 'rotate(0deg)';
          } else {
            // เมื่อ accordion เปิด (expanded) ลูกศรชี้ขึ้น
            icon.style.transform = 'rotate(180deg)';
          }
        }
      });
    });

    // เพิ่ม event listener สำหรับ accordion collapse เพื่อ sync animation
    const accordionCollapses = document.querySelectorAll('.accordion-collapse');
    accordionCollapses.forEach(collapse => {
      collapse.addEventListener('show.bs.collapse', function() {
        // หาปุ่มที่เกี่ยวข้องกับ accordion นี้เท่านั้น
        const button = document.querySelector(`[data-bs-target="#${this.id}"]`);
        if (button) {
          const icon = button.querySelector('.fas.fa-chevron-down');
          if (icon) {
            // เมื่อ accordion เปิด ลูกศรชี้ขึ้น
            icon.style.transform = 'rotate(180deg)';
          }
        }
      });
      
      collapse.addEventListener('hide.bs.collapse', function() {
        // หาปุ่มที่เกี่ยวข้องกับ accordion นี้เท่านั้น
        const button = document.querySelector(`[data-bs-target="#${this.id}"]`);
        if (button) {
          const icon = button.querySelector('.fas.fa-chevron-down');
          if (icon) {
            // เมื่อ accordion ปิด ลูกศรชี้ลง
            icon.style.transform = 'rotate(0deg)';
          }
        }
      });
    });

    // เพิ่ม CSS สำหรับ accordion animation
    const accordionStyle = document.createElement('style');
    accordionStyle.textContent = `
      .accordion-button .fas.fa-chevron-down {
        transition: transform 0.3s ease;
      }
      
      .accordion-button:not(.collapsed) .fas.fa-chevron-down {
        transform: rotate(180deg);
      }
      
      .accordion-button.collapsed .fas.fa-chevron-down {
        transform: rotate(0deg);
      }
      
      .accordion-collapse {
        transition: all 0.3s ease;
      }
      
      .accordion-button:hover {
        transform: translateY(-1px);
        transition: all 0.2s ease;
      }
      
      .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
      }
    `;
    document.head.appendChild(accordionStyle);
  });
</script>
@endsection

<!-- @{{ old('...') }} คือ ฟังก์ชันช่วยของ Laravel ที่ใช้ใน Blade Template สำหรับ คืนค่า ค่าที่ผู้ใช้เคยกรอกไว้ ก่อนหน้า(ในกรณีที่ submit form แล้วเกิด validation error)-->