@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">
                        <i class="fas fa-chart-bar me-2"></i>
                        รายงานผลการประเมินผลิตภัณฑ์
                    </h4>
                </div>
                <div class="card-body card">
                    <!-- บล็อกแสดงข้อมูลผลิตภัณฑ์ -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-box me-2"></i>
                                        ข้อมูลผลิตภัณฑ์
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td class="fw-bold" style="width: 150px;">ชื่อผลิตภัณฑ์:</td>
                                                    <td>{{ $product->name ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">โมเดล/รุ่น:</td>
                                                    <td>{{ $product->model ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">วิธีรับข้อมูล:</td>
                                                    <td>{{ $product->log_receive_method ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                                                    <td>{{ $product->product_type ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-bold">Email ติดต่อ:</td>
                                                    <td>{{ $product->user->Email ?? 'ไม่ระบุ' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            @if($product->image)
                                                <div class="text-center">
                                                    <img src="{{ asset('storage/' . $product->image) }}" 
                                                         alt="รูปภาพผลิตภัณฑ์" 
                                                         class="img-fluid rounded" 
                                                         style="max-height: 200px;">
                                                </div>
                                            @else
                                                <div class="text-center text-muted">
                                                    <i class="fas fa-image fa-3x mb-2"></i>
                                                    <p>ไม่มีรูปภาพ</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-user me-2"></i>
                                        ข้อมูลผู้ใช้
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        @if($product->user->profile_photo_path)
                                            <img src="{{ asset('storage/' . $product->user->profile_photo_path) }}" 
                                                 alt="รูปภาพผู้ใช้" 
                                                 class="rounded-circle mb-3" 
                                                 style="width: 100px; height: 100px; object-fit: cover;">
                                        @else
                                            <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                                 style="width: 100px; height: 100px;">
                                                <i class="fas fa-user fa-2x text-white"></i>
                                            </div>
                                        @endif
                                        <h6>{{ $product->user->name ?? 'ไม่ระบุ' }}</h6>
                                        <p class="text-muted mb-0">{{ $product->user->Email ?? 'ไม่ระบุ' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                    </div>

                    <!-- ตารางแสดงผลการประเมิน -->
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-clipboard-check me-2"></i>
                                ตารางแสดงผลการประเมิน
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(isset($assessment) && $assessment)
                                <!-- Debug Information -->
                                @if(config('app.debug'))
                                    <div class="alert alert-info">
                                        <strong>Debug Info:</strong><br>
                                        Assessment ID: {{ $assessment->id }}<br>
                                        Total Answers: {{ $assessment->answers->count() }}<br>
                                        Evaluation Answers: {{ $assessment->answers->where('question.use_in_evaluation', true)->count() }}
                                    </div>
                                @endif
                                
                                <div class="mb-4">
                                    <h6 class="text-primary mb-3">
                                        <i class="fas fa-calendar-alt me-1"></i>
                                        การประเมินวันที่: {{ $assessment->DtmIns->format('d/m/Y H:i') }}
                                    </h6>
                                    
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th style="width: 80px;" class="text-center">ข้อ</th>
                                                    <th style="width: 300px;">ข้อกำหนด</th>
                                                    <th style="width: 200px;">คำตอบ</th>
                                                    <th style="width: 120px;" class="text-center">ผลการตรวจสอบ</th>
                                                    <th>คำอธิบาย</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($assessment->answers) && $assessment->answers->count() > 0)
                                                    @php
                                                        $questionNumber = 1;
                                                    @endphp
                                                    @foreach($assessment->answers as $index => $answer)
                                                        @php
                                                            $question = $answer->question;
                                                            // ตรวจสอบว่าเป็นคำถามที่ใช้ในการประเมินหรือไม่
                                                            $isEvaluationQuestion = $question && $question->use_in_evaluation;
                                                        @endphp
                                                        @if($isEvaluationQuestion)
                                                            <tr>
                                                                <td class="text-center fw-bold">
                                                                    {{ $questionNumber }}
                                                                </td>
                                                                <td>
                                                                    <strong>{{ $question->question_text ?? 'ไม่ระบุ' }}</strong>
                                                                    @if($question->description)
                                                                        <br><small class="text-muted">{{ $question->description }}</small>
                                                                    @endif
                                                                </td>
                                                                <td>
                                                                    @if($question->question_type == 'yes_no')
                                                                        <span class="badge {{ $answer->answer_text == 'ใช่' ? 'bg-success' : 'bg-danger' }}">
                                                                            <i class="fas {{ $answer->answer_text == 'ใช่' ? 'fa-check' : 'fa-times' }} me-1"></i>
                                                                            {{ $answer->answer_text }}
                                                                        </span>
                                                                    @elseif($question->question_type == 'multiple_choice')
                                                                        <span class="badge bg-info">
                                                                            <i class="fas fa-list me-1"></i>
                                                                            {{ $answer->answer_text }}
                                                                        </span>
                                                                    @elseif($question->question_type == 'text')
                                                                        <span class="badge bg-secondary">
                                                                            <i class="fas fa-file-text me-1"></i>
                                                                            ข้อความ
                                                                        </span>
                                                                        <div class="small text-muted mt-1">
                                                                            {{ Str::limit($answer->answer_text, 100) }}
                                                                        </div>
                                                                    @else
                                                                        <span class="badge bg-secondary">
                                                                            {{ $answer->answer_text ?? 'ไม่ระบุ' }}
                                                                        </span>
                                                                    @endif
                                                                </td>
                                                                <td class="text-center">
                                                                    @if($question->question_type == 'yes_no')
                                                                        @if($answer->answer_text == 'ใช่')
                                                                            <span class="badge bg-success">
                                                                                <i class="fas fa-check me-1"></i>
                                                                                ผ่าน
                                                                            </span>
                                                                        @else
                                                                            <span class="badge bg-danger">
                                                                                <i class="fas fa-times me-1"></i>
                                                                                ไม่ผ่าน
                                                                            </span>
                                                                        @endif
                                                                    @elseif($question->question_type == 'multiple_choice')
                                                                        <span class="badge bg-info">
                                                                            <i class="fas fa-list me-1"></i>
                                                                            ตอบแล้ว
                                                                        </span>
                                                                    @elseif($question->question_type == 'text')
                                                                        <span class="badge bg-secondary">
                                                                            <i class="fas fa-file-text me-1"></i>
                                                                            ตอบแล้ว
                                                                        </span>
                                                                    @else
                                                                        <span class="badge bg-secondary">
                                                                            <i class="fas fa-file-text me-1"></i>
                                                                            ตอบแล้ว
                                                                        </span>
                                                                    @endif
                                                                </td>
                                                                <td>
                                                                    @if($answer->comment)
                                                                        <div class="text-success">
                                                                            <i class="fas fa-comment me-1"></i>
                                                                            {{ $answer->comment }}
                                                                        </div>
                                                                    @else
                                                                        <span class="text-muted">
                                                                            <i class="fas fa-minus me-1"></i>
                                                                            ไม่มีคำอธิบาย
                                                                        </span>
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            @php
                                                                $questionNumber++;
                                                            @endphp
                                                        @endif
                                                    @endforeach
                                                    
                                                    @if($questionNumber == 1)
                                                        <tr>
                                                            <td colspan="5" class="text-center text-muted">
                                                                <i class="fas fa-info-circle me-1"></i>
                                                                ไม่มีคำถามที่ใช้ในการประเมิน
                                                            </td>
                                                        </tr>
                                                    @endif
                                                @else
                                                    <tr>
                                                        <td colspan="5" class="text-center text-muted">
                                                            <i class="fas fa-info-circle me-1"></i>
                                                            ไม่มีข้อมูลการประเมิน
                                                        </td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- สรุปผลการประเมิน -->
                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <div class="card bg-light">
                                                <div class="card-body">
                                                    <h6 class="card-title">
                                                        <i class="fas fa-chart-pie me-1"></i>
                                                        สรุปผลการประเมิน
                                                    </h6>
                                                    @php
                                                        $totalQuestions = $assessment->answers->where('question.use_in_evaluation', true)->count();
                                                        $passedQuestions = $assessment->answers->where('question.use_in_evaluation', true)
                                                            ->where('question.question_type', 'yes_no')
                                                            ->where('answer_text', 'ใช่')
                                                            ->count();
                                                        $percentage = $totalQuestions > 0 ? round(($passedQuestions / $totalQuestions) * 100, 2) : 0;
                                                    @endphp
                                                    <p class="mb-1">
                                                        <strong>คำถามทั้งหมด:</strong> {{ $totalQuestions }} ข้อ
                                                    </p>
                                                    <p class="mb-1">
                                                        <strong>ผ่าน:</strong> {{ $passedQuestions }} ข้อ
                                                    </p>
                                                    <p class="mb-1">
                                                        <strong>ไม่ผ่าน:</strong> {{ $totalQuestions - $passedQuestions }} ข้อ
                                                    </p>
                                                    <p class="mb-0">
                                                        <strong>เปอร์เซ็นต์:</strong> 
                                                        @if($percentage >= 80)
                                                            <span class="badge bg-success">{{ $percentage }}% (ผ่าน)</span>
                                                        @elseif($percentage >= 60)
                                                            <span class="badge bg-warning">{{ $percentage }}% (ผ่านแบบมีเงื่อนไข)</span>
                                                        @else
                                                            <span class="badge bg-danger">{{ $percentage }}% (ไม่ผ่าน)</span>
                                                        @endif
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="card bg-light">
                                                <div class="card-body">
                                                    <h6 class="card-title">
                                                        <i class="fas fa-user-check me-1"></i>
                                                        ข้อมูลการประเมิน
                                                    </h6>
                                                    <p class="mb-1">
                                                        <strong>ผู้ประเมิน:</strong> {{ $assessment->user->name ?? 'ไม่ระบุ' }}
                                                    </p>
                                                    <p class="mb-1">
                                                        <strong>อีเมล:</strong> {{ $assessment->user->Email ?? 'ไม่ระบุ' }}
                                                    </p>
                                                    <p class="mb-0">
                                                        <strong>วันที่ประเมิน:</strong> {{ $assessment->DtmIns->format('d/m/Y H:i') }}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="text-center text-muted py-5">
                                    <i class="fas fa-clipboard-list fa-3x mb-3"></i>
                                    <h5>ยังไม่มีข้อมูลการประเมิน</h5>
                                    <p>ไม่พบผลการประเมินสำหรับผลิตภัณฑ์นี้</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- ปุ่มกลับ -->
                    <div class="text-center mt-4">
                        @if(Auth::user()->role === 'admin')
                            <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                กลับไปหน้า Admin Dashboard
                            </a>
                        @else
                            <a href="{{ route('products.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                กลับไปหน้ารายการผลิตภัณฑ์
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection