<?php

// ไฟล์สำหรับแสดงข้อมูลคำถามทั้งหมดในตาราง questions
// ใช้เพื่อวิเคราะห์และแก้ไขปัญหา

require_once 'vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as Capsule;

// ตั้งค่าการเชื่อมต่อฐานข้อมูล
$capsule = new Capsule;

$capsule->addConnection([
    'driver'    => 'mysql',
    'host'      => 'localhost',
    'database'  => 'your_database_name', // แก้ไขเป็นชื่อฐานข้อมูลของคุณ
    'username'  => 'your_username',       // แก้ไขเป็น username ของคุณ
    'password'  => 'your_password',       // แก้ไขเป็น password ของคุณ
    'charset'   => 'utf8',
    'collation' => 'utf8_unicode_ci',
    'prefix'    => '',
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

echo "<h1>ข้อมูลคำถามทั้งหมดในตาราง questions</h1>";
echo "<style>
    table { border-collapse: collapse; width: 100%; margin: 20px 0; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background-color: #f2f2f2; }
    .parent { background-color: #e8f5e8; }
    .child { background-color: #fff3cd; }
    .grandchild { background-color: #f8d7da; }
    .great-grandchild { background-color: #d1ecf1; }
    .great-great-grandchild { background-color: #f5c6cb; }
    .great-great-great-grandchild { background-color: #ffeaa7; }
    .accordion { background-color: #fff3cd; }
    .evaluation { background-color: #d4edda; }
    .non-evaluation { background-color: #f8d7da; }
</style>";

try {
    // ดึงข้อมูลคำถามทั้งหมดพร้อมกับข้อมูลที่เกี่ยวข้อง
    $questions = Capsule::table('questions')
        ->leftJoin('question_groups', 'questions.question_group_id', '=', 'question_groups.id')
        ->leftJoin('questions as parent', 'questions.parent_id', '=', 'parent.id')
        ->select([
            'questions.id',
            'questions.question_text',
            'questions.question_type',
            'questions.use_in_evaluation',
            'questions.parent_id',
            'questions.choices',
            'questions.sort_order',
            'question_groups.name as group_name',
            'parent.question_text as parent_text'
        ])
        ->orderBy('question_groups.name')
        ->orderBy('questions.sort_order')
        ->get();

    if ($questions->count() > 0) {
        echo "<table>";
        echo "<tr>
                <th>ID</th>
                <th>Group</th>
                <th>Level</th>
                <th>Parent</th>
                <th>Question Text</th>
                <th>Question Type</th>
                <th>Use in Evaluation</th>
                <th>Choices</th>
                <th>Display Type</th>
              </tr>";

        foreach ($questions as $question) {
            // กำหนดระดับของคำถาม
            $level = $this->getQuestionLevel($question->parent_id, $questions);
            $levelClass = $this->getLevelClass($level);
            
            // กำหนดประเภทการแสดงผล
            $displayType = $this->getDisplayType($question->use_in_evaluation, $question->question_type);
            $displayClass = $this->getDisplayClass($displayType);

            echo "<tr class='{$levelClass} {$displayClass}'>";
            echo "<td>{$question->id}</td>";
            echo "<td>{$question->group_name}</td>";
            echo "<td>{$level}</td>";
            echo "<td>" . ($question->parent_text ?: 'ไม่มี') . "</td>";
            echo "<td>{$question->question_text}</td>";
            echo "<td>" . ($question->question_type ?: 'null') . "</td>";
            echo "<td>" . ($question->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "</td>";
            echo "<td>" . ($question->choices ?: 'ไม่มี') . "</td>";
            echo "<td>{$displayType}</td>";
            echo "</tr>";
        }
        echo "</table>";

        // สรุปสถิติ
        echo "<h2>สรุปสถิติ</h2>";
        $this->showStatistics($questions);

    } else {
        echo "<p>ไม่พบข้อมูลคำถามในตาราง</p>";
    }

} catch (Exception $e) {
    echo "<p>เกิดข้อผิดพลาด: " . $e->getMessage() . "</p>";
}

/**
 * ฟังก์ชันสำหรับกำหนดระดับของคำถาม
 */
function getQuestionLevel($parentId, $questions) {
    if (!$parentId) {
        return "Parent (ระดับที่ 1)";
    }
    
    $level = 1;
    $currentParentId = $parentId;
    
    while ($currentParentId) {
        $parent = $questions->where('id', $currentParentId)->first();
        if ($parent) {
            $level++;
            $currentParentId = $parent->parent_id;
        } else {
            break;
        }
    }
    
    switch ($level) {
        case 1: return "Parent (ระดับที่ 1)";
        case 2: return "Child (ระดับที่ 2)";
        case 3: return "Grand Child (ระดับที่ 3)";
        case 4: return "Great Grand Child (ระดับที่ 4)";
        case 5: return "Great Great Grand Child (ระดับที่ 5)";
        case 6: return "Great Great Great Grand Child (ระดับที่ 6)";
        default: return "ระดับที่ {$level}";
    }
}

/**
 * ฟังก์ชันสำหรับกำหนด CSS class ตามระดับ
 */
function getLevelClass($level) {
    if (strpos($level, 'Parent') !== false) return 'parent';
    if (strpos($level, 'Child') !== false && strpos($level, 'Grand') === false) return 'child';
    if (strpos($level, 'Grand Child') !== false && strpos($level, 'Great') === false) return 'grandchild';
    if (strpos($level, 'Great Grand Child') !== false && strpos($level, 'Great Great') === false) return 'great-grandchild';
    if (strpos($level, 'Great Great Grand Child') !== false && strpos($level, 'Great Great Great') === false) return 'great-great-grandchild';
    if (strpos($level, 'Great Great Great Grand Child') !== false) return 'great-great-great-grandchild';
    return '';
}

/**
 * ฟังก์ชันสำหรับกำหนดประเภทการแสดงผล
 */
function getDisplayType($useInEvaluation, $questionType) {
    if (!$useInEvaluation && $questionType === null) {
        return "Accordion Button";
    } elseif ($useInEvaluation && $questionType !== null) {
        return "Card ปกติ (ใช้ในการประเมิน)";
    } elseif (!$useInEvaluation && $questionType !== null) {
        return "Card สีเทา (ไม่ใช้ในการประเมิน)";
    } else {
        return "ไม่ระบุ";
    }
}

/**
 * ฟังก์ชันสำหรับกำหนด CSS class ตามประเภทการแสดงผล
 */
function getDisplayClass($displayType) {
    if (strpos($displayType, 'Accordion') !== false) return 'accordion';
    if (strpos($displayType, 'ใช้ในการประเมิน') !== false) return 'evaluation';
    if (strpos($displayType, 'ไม่ใช้ในการประเมิน') !== false) return 'non-evaluation';
    return '';
}

/**
 * ฟังก์ชันสำหรับแสดงสถิติ
 */
function showStatistics($questions) {
    $totalQuestions = $questions->count();
    $parentQuestions = $questions->where('parent_id', null)->count();
    $childQuestions = $questions->where('parent_id', '!=', null)->count();
    
    $accordionQuestions = $questions->where('use_in_evaluation', false)->where('question_type', null)->count();
    $evaluationQuestions = $questions->where('use_in_evaluation', true)->where('question_type', '!=', null)->count();
    $nonEvaluationQuestions = $questions->where('use_in_evaluation', false)->where('question_type', '!=', null)->count();
    
    echo "<div style='display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin: 20px 0;'>";
    echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px;'>";
    echo "<h3>จำนวนคำถามทั้งหมด: {$totalQuestions}</h3>";
    echo "</div>";
    echo "<div style='background: #fff3cd; padding: 15px; border-radius: 5px;'>";
    echo "<h3>Parent Questions: {$parentQuestions}</h3>";
    echo "</div>";
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px;'>";
    echo "<h3>Child Questions: {$childQuestions}</h3>";
    echo "</div>";
    echo "<div style='background: #d4edda; padding: 15px; border-radius: 5px;'>";
    echo "<h3>Accordion Questions: {$accordionQuestions}</h3>";
    echo "</div>";
    echo "<div style='background: #cce5ff; padding: 15px; border-radius: 5px;'>";
    echo "<h3>Evaluation Questions: {$evaluationQuestions}</h3>";
    echo "</div>";
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px;'>";
    echo "<h3>Non-Evaluation Questions: {$nonEvaluationQuestions}</h3>";
    echo "</div>";
    echo "</div>";
}

?> 