<?php $__env->startSection('content'); ?>
<div class="container">
  <h2>เริ่มการประเมิน: <?php echo e($product->name); ?></h2>

  <form method="POST" action="<?php echo e(route('assessments.store')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">

    <?php $__currentLoopData = $questionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupIndex => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="card mb-4">
        <div class="card-header">
          <strong><?php echo e($groupIndex + 1); ?>. <?php echo e($group->title); ?></strong>
        </div>
        <div class="card-body">
          <?php $__currentLoopData = $group->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $questionIndex => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-4">
              <label class="form-label question-label">
                <span class="question-number-inline"><?php echo e($groupIndex + 1); ?>.<?php echo e($questionIndex + 1); ?>.</span> <?php echo e($question->question_text); ?>

              </label>
              
              <!-- คำถามแบบ ใช่/ไม่ใช่ -->
              <div class="mb-3">
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="answers[<?php echo e($question->id); ?>][choice]" id="yes_<?php echo e($question->id); ?>" value="yes" required>
                  <label class="form-check-label" for="yes_<?php echo e($question->id); ?>">ใช่</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="answers[<?php echo e($question->id); ?>][choice]" id="no_<?php echo e($question->id); ?>" value="no" required>
                  <label class="form-check-label" for="no_<?php echo e($question->id); ?>">ไม่ใช่</label>
                </div>
              </div>

              <!-- ข้อความเพิ่มเติม (แสดงเมื่อเลือก ใช่) -->
              <div class="mb-3" id="details_<?php echo e($question->id); ?>" style="display: none;">
                <label class="form-label">รายละเอียดเพิ่มเติม (กรณีตอบว่าใช่)</label>
                <textarea name="answers[<?php echo e($question->id); ?>][details]" class="form-control" rows="2"></textarea>
              </div>

              <label class="form-label mt-2">รูปภาพ (ถ้ามี)</label>
              <input type="file" name="answers[<?php echo e($question->id); ?>][image]" class="form-control" accept="image/*">

              <label class="form-label mt-2">หมายเหตุ (ถ้ามี)</label>
              <textarea name="answers[<?php echo e($question->id); ?>][comment]" class="form-control" rows="2"></textarea>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <button type="submit" class="btn btn-primary">ส่งแบบประเมิน</button>
    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">ยกเลิก</a>
  </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // จัดการการแสดง/ซ่อนช่องรายละเอียดเพิ่มเติม
  const radioButtons = document.querySelectorAll('input[type="radio"]');
  radioButtons.forEach(radio => {
    radio.addEventListener('change', function() {
      const questionId = this.name.match(/\[(\d+)\]/)[1];
      const detailsDiv = document.getElementById('details_' + questionId);
      
      if (this.value === 'yes') {
        detailsDiv.style.display = 'block';
      } else {
        detailsDiv.style.display = 'none';
        // ล้างข้อมูลในช่องรายละเอียดเมื่อเลือก ไม่ใช่
        detailsDiv.querySelector('textarea').value = '';
      }
    });
  });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/aritach/sas-log/resources/views/assessments/create.blade.php ENDPATH**/ ?>