<nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
            <img src="<?php echo e(asset('images/logo.jpg')); ?>" alt="Logo" style="width: 150px; height: 55px; margin: 5px;">
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Left Side Of Navbar -->
            <ul class="navbar-nav ms-5">
                <!-- Navigation Links for Authenticated Users -->
                <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item me-3">
                        <a class="nav-link" href="https://www.squat.in.th/services/logservertesting/" target="_blank">
                            <i class="fas fa-chart-line me-1"></i>
                            <?php echo e(__('ข้อมูลมาตรฐาน')); ?>

                        </a>
                    </li>
                    <li class="nav-item me-3">
                        <a class="nav-link" href="<?php echo e(route('products.index')); ?>">
                            <i class="fas fa-clipboard-list me-1"></i>
                            <?php echo e(__('ประเมินผลิตภัณฑ์')); ?>

                        </a>
                    </li>
                <?php endif; ?>
            </ul>

            <!-- Right Side Of Navbar -->
            <ul class="navbar-nav ms-auto">
                <!-- Authentication Links -->
                <?php if(auth()->guard()->guest()): ?>
                    <?php if(Route::has('login')): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('เข้าสู่ระบบ')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if(Route::has('register')): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('ลงทะเบียน')); ?></a>
                        </li>
                    <?php endif; ?>
                <?php else: ?>
                    <!-- Admin Function Button -->
                    <?php if(Auth::user()->role === 'admin'): ?>
                    <li class="nav-item me-3">
                        <a class="nav-link btn btn-primary text-white px-3" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="fas fa-cogs me-1"></i>
                            <?php echo e(__('ADMIN FUNCTION')); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                            <i class="fas fa-user-circle me-1"></i>
                            <?php echo e(Auth::user()->name); ?>

                        </a>

                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="<?php echo e(route('profile.edit')); ?>">
                                <i class="fas fa-user-edit me-2"></i>
                                <?php echo e(__('โปรไฟล์')); ?>

                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                                <i class="fas fa-sign-out-alt me-2"></i>
                                <?php echo e(__('ออกจากระบบ')); ?>

                            </a>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>
<?php /**PATH /Users/aritach/sas-log/resources/views/layouts/navigation.blade.php ENDPATH**/ ?>