<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-question-circle me-2"></i>
            จัดการกลุ่มคำถาม
        </h1>
        <a href="<?php echo e(route('admin.question-groups.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-1"></i>
            สร้างกลุ่มคำถามใหม่
        </a>
    </div>

    <!-- Question Groups List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>
                รายการกลุ่มคำถามทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info"><?php echo e($groups->total()); ?> กลุ่ม</span>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if($groups->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th>ชื่อกลุ่มคำถาม</th>
                                <th>จำนวนคำถาม</th>
                                <th>สถานะ</th>
                                <th>วันที่สร้าง</th>
                                <th>ผู้สร้าง</th>
                                <th class="text-center" style="width: 200px;">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center text-muted"><?php echo e($index + 1 + (($groups->currentPage() - 1) * $groups->perPage())); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <i class="fas fa-folder fa-2x text-primary"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-0"><?php echo e($group->name); ?></h6>
                                            <?php if($group->description): ?>
                                                <small class="text-muted"><?php echo e(Str::limit($group->description, 100)); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-success me-2"><?php echo e($group->questions->count()); ?></span>
                                        <small class="text-muted">คำถาม</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input toggle-active" 
                                               type="checkbox" 
                                               id="active_<?php echo e($group->id); ?>"
                                               data-group-id="<?php echo e($group->id); ?>"
                                               <?php echo e($group->is_active ? 'checked' : ''); ?>

                                               title="<?php echo e($group->is_active ? 'ปิดการใช้งาน' : 'เปิดการใช้งาน'); ?>">
                                        <label class="form-check-label" for="active_<?php echo e($group->id); ?>">
                                            <?php if($group->is_active): ?>
                                                <span class="badge bg-success">ใช้งาน</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">ไม่ใช้งาน</span>
                                            <?php endif; ?>
                                        </label>
                                    </div>
                                </td>
                                <td>
                                    <i class="fas fa-calendar-alt me-1 text-muted"></i>
                                    <?php echo e($group->DtmIns->format('d/m/Y H:i')); ?>

                                </td>
                                <td>
                                    <?php if($group->creator): ?>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-user me-1 text-muted"></i>
                                            <span><?php echo e($group->creator->Customer_Name); ?></span>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.question-groups.edit', $group)); ?>" 
                                           class="btn btn-sm btn-outline-primary" 
                                           title="แก้ไข">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.questions.create', $group)); ?>" 
                                           class="btn btn-sm btn-outline-success" 
                                           title="เพิ่มคำถาม">
                                            <i class="fas fa-plus"></i>
                                        </a>
                                        <button type="button" 
                                                class="btn btn-sm btn-outline-danger delete-btn" 
                                                data-group-id="<?php echo e($group->id); ?>"
                                                data-group-name="<?php echo e($group->name); ?>"
                                                title="ลบ">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center py-3">
                    <?php echo e($groups->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                    <h4 class="text-muted">ไม่พบกลุ่มคำถาม</h4>
                    <p class="text-muted">เริ่มต้นด้วยการสร้างกลุ่มคำถามใหม่</p>
                    <a href="<?php echo e(route('admin.question-groups.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>
                        สร้างกลุ่มคำถามแรก
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">ยืนยันการลบ</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>คุณต้องการลบกลุ่มคำถาม "<span id="groupName"></span>" หรือไม่?</p>
                <p class="text-danger"><small>การดำเนินการนี้จะลบคำถามทั้งหมดในกลุ่มนี้ด้วย</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">ลบ</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete confirmation
    const deleteButtons = document.querySelectorAll('.delete-btn');
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    const deleteForm = document.getElementById('deleteForm');
    const groupNameSpan = document.getElementById('groupName');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function() {
            const groupId = this.getAttribute('data-group-id');
            const groupName = this.getAttribute('data-group-name');
            
            groupNameSpan.textContent = groupName;
            deleteForm.action = `/admin/question-groups/${groupId}`;
            deleteModal.show();
        });
    });

    // Toggle active status
    const toggleActiveInputs = document.querySelectorAll('.toggle-active');
    toggleActiveInputs.forEach(input => {
        input.addEventListener('change', function() {
            const groupId = this.getAttribute('data-group-id');
            const isActive = this.checked;
            const originalState = !isActive; // เก็บสถานะเดิม

            // แสดง loading state
            this.disabled = true;
            
            // หา label element ที่ถูกต้อง
            const label = this.closest('.form-check').querySelector('.form-check-label');
            const originalLabel = label ? label.innerHTML : '';

            fetch(`/admin/question-groups/${groupId}/toggle-active`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // อัปเดต label ถ้ามี
                    if (label) {
                        if (isActive) {
                            label.innerHTML = '<span class="badge bg-success">ใช้งาน</span>';
                        } else {
                            label.innerHTML = '<span class="badge bg-secondary">ไม่ใช้งาน</span>';
                        }
                    }
                    
                    // แสดงข้อความสำเร็จแบบ toast
                    const toast = document.createElement('div');
                    toast.className = 'alert alert-success alert-dismissible fade show position-fixed';
                    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
                    toast.innerHTML = `
                        <i class="fas fa-check-circle me-2"></i>
                        ${data.message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    `;
                    document.body.appendChild(toast);
                    
                    // ลบ toast หลังจาก 3 วินาที
                    setTimeout(() => {
                        if (toast.parentNode) {
                            toast.remove();
                        }
                    }, 3000);
                } else {
                    throw new Error(data.message || 'เกิดข้อผิดพลาดในการเปลี่ยนแปลงสถานะ');
                }
            })
            .catch(error => {
                console.error('Error toggling active status:', error);
                
                // Revert checkbox state
                this.checked = originalState;
                if (label) {
                    label.innerHTML = originalLabel;
                }
                
                // แสดงข้อความ error
                const errorToast = document.createElement('div');
                errorToast.className = 'alert alert-danger alert-dismissible fade show position-fixed';
                errorToast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
                errorToast.innerHTML = `
                    <i class="fas fa-exclamation-circle me-2"></i>
                    เกิดข้อผิดพลาด: ${error.message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                `;
                document.body.appendChild(errorToast);
                
                // ลบ error toast หลังจาก 5 วินาที
                setTimeout(() => {
                    if (errorToast.parentNode) {
                        errorToast.remove();
                    }
                }, 5000);
            })
            .finally(() => {
                // Enable checkbox
                this.disabled = false;
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/aritach/sas-log/resources/views/admin/question-groups/index.blade.php ENDPATH**/ ?>