<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-clipboard-check me-2"></i>
                        จัดการการประเมิน
                    </h1>
                    <p class="text-muted mb-0">ดูและจัดการการประเมินทั้งหมดในระบบ</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
                        กลับไป Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Assessments List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-clipboard-check me-2"></i>
                รายการการประเมินทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info"><?php echo e($assessments->total()); ?> รายการ</span>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if($assessments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th>ผลิตภัณฑ์</th>
                                <th>ผู้ประเมิน</th>
                                <th>บริษัท</th>
                                <th>คะแนนรวม</th>
                                <th>สถานะ</th>
                                <th>วันที่ประเมิน</th>
                                <th class="text-center" style="width: 120px;">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center"><?php echo e($assessments->firstItem() + $index); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <?php if($assessment->product && $assessment->product->image): ?>
                                            <img src="<?php echo e(Storage::url($assessment->product->image)); ?>" 
                                                 alt="<?php echo e($assessment->product->name); ?>" 
                                                 class="rounded me-2" 
                                                 style="width: 40px; height: 40px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-light rounded d-flex align-items-center justify-content-center me-2" 
                                                 style="width: 40px; height: 40px;">
                                                <i class="fas fa-box text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div>
                                            <div class="fw-bold"><?php echo e($assessment->product->name ?? 'ไม่ระบุ'); ?></div>
                                            <small class="text-muted"><?php echo e($assessment->product->model ?? ''); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if($assessment->user): ?>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-user-circle fa-lg text-gray-400 me-2"></i>
                                            <div>
                                                <div class="fw-bold"><?php echo e($assessment->user->Customer_Name); ?></div>
                                                <small class="text-muted"><?php echo e($assessment->user->Email); ?></small>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">ไม่ระบุ</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($assessment->user && $assessment->user->agency): ?>
                                        <span class="badge bg-success"><?php echo e($assessment->user->agency->Agency_Name); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">ไม่ระบุ</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $totalScore = $assessment->answers->sum('score');
                                        $maxScore = $assessment->answers->count() * 5; // สมมติว่าแต่ละข้อมีคะแนนเต็ม 5
                                        $percentage = $maxScore > 0 ? ($totalScore / $maxScore) * 100 : 0;
                                        $progressClass = $percentage >= 80 ? 'bg-success' : ($percentage >= 60 ? 'bg-warning' : 'bg-danger');
                                    ?>
                                    <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <strong><?php echo e($totalScore); ?>/<?php echo e($maxScore); ?></strong>
                                        </div>
                                        <div class="progress flex-grow-1" style="height: 8px;">
                                            <div class="progress-bar <?php echo e($progressClass); ?>" 
                                                 style="width: <?php echo e($percentage); ?>%"></div>
                                        </div>
                                        <small class="ms-2"><?php echo e(number_format($percentage, 1)); ?>%</small>
                                    </div>
                                </td>
                                <td>
                                    <?php if($assessment->status == 'submitted'): ?>
                                        <span class="badge bg-success">เสร็จสิ้น</span>
                                    <?php elseif($assessment->status == 'draft'): ?>
                                        <span class="badge bg-warning">กำลังดำเนินการ</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">รอดำเนินการ</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($assessment->DtmIns ? $assessment->DtmIns->format('d/m/Y H:i') : '-'); ?></td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.assessments.view', $assessment->id)); ?>" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.assessments.report', $assessment->id)); ?>" 
                                           class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-chart-bar"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger"
                                                data-assessment-id="<?php echo e($assessment->id); ?>"
                                                onclick="deleteAssessment(this.dataset.assessmentId)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="card-footer">
                    <?php echo e($assessments->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-clipboard-check fa-3x text-gray-300 mb-3"></i>
                    <h5 class="text-gray-500">ไม่พบข้อมูลการประเมิน</h5>
                    <p class="text-muted">ยังไม่มีการประเมินในระบบ</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
function deleteAssessment(assessmentId) {
    if (confirm('คุณต้องการลบการประเมินนี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้')) {
        // ส่ง AJAX request เพื่อลบการประเมิน
        fetch(`/admin/assessments/${assessmentId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('เกิดข้อผิดพลาดในการลบการประเมิน');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('เกิดข้อผิดพลาดในการลบการประเมิน');
        });
    }
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/aritach/sas-log/resources/views/admin/assessments/index.blade.php ENDPATH**/ ?>