<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agency', function (Blueprint $table) {
            $table->increments('Agency_ID')->comment('รหัสข้อมูลตาราง (ใช้ในการรันเลข)');
            $table->string('Agency_Name', 255)->comment('ชื่อหน่วยงาน');
            $table->string('Tax_ID',13)->comment('เลขประจำตัวผู้เสียภาษีของหน่วยงาน');
            $table->string('Address',255)->comment('ที่อยู่ภาษาไทย (ที่จดทะเบียนพาณิชย์)  สำหรับทำใบเสนอราคา,ใบเสร็จรับเงิน');
            $table->string('Address_Sent',255)->comment('ที่อยู่สำหรับจัดส่งเอกสาร');
            $table->string('Address_Test',255)->comment('ที่อยู่สำหรับจัดทำรายงานผลการทดสอบ');
            $table->string('Address_Eng',255)->comment('ที่อยู่ภาษาอังกฤษ');
            $table->string('Office_Number',255)->comment('เบอร์โทรศัพท์สำนักงาน');
            $table->string('Web_Name',255)->comment('เว็บไซต์หน่วยงาน หรือเว็บไซต์ผลิตภัณฑ');
            $table->integer('CusIns_ID')->comment('รหัสลูกค้า ที่สร้าง');
            $table->integer('CusUdp_ID')->comment('รหัสลูกค้า ที่แก้ไข');
            $table->timestamp('DtmIns')->default(DB::raw('CURRENT_TIMESTAMP'))->comment('วันที่และเวลา สร้าง');
            $table->timestamp('DtmUdp')->default(DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'))->comment('วันที่และเวลา แก้ไข');
            $table->tinyInteger('active')->default(1)->comment('True to 1 = Active\r\nFlase to 0 = Not Active');
            $table->string('Note', 100)->comment('หมายเหตุ');
            $table->string('Edit_Agency', 3)->default('Off')->comment('คำขอการแก้ไข\r\nOn= มีการส่งคำขอการแก้ไข\r\nOff=ยกเลิกการส่งคำขอการแก้ไข');
            $table->string('New_Agency', 3)->default('Off')->comment('On=เป็นหน่วยงานใหม่ที่เพิ่มเข้ามา\r\nOff=ไม่เป็นหน่วยงานใหม่');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agency');
    }
};
