<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Company;
use Database\Seeders\CompanySeeder;
class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $company1 = CompanySeeder::createCompany();

        User::create([
            'name' => 'Test User',
            'email' => 'test@example.com',
            'password' => Hash::make('password123'),
            'remember_token' => Str::random(10),
            'phone' => '081234567890',
            'company_id' => $company1->id,
            'company_name' => $company1->name,
            'role' => 'client',
        ]);
        $this->call([
            QuestionSeeder::class,//เรียกใช้ QuestionsSeeder เพื่อสร้างข้อมูลคำถาม โดยทำงานหลังจากสร้าง user และ company เสร็จแล้ว
        ]);
    }
}

//: void คือ return type declaration ที่บอกว่า method หรือ function นี้ไม่มีการ return ค่า