@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-clipboard-check me-2"></i>
                        จัดการการประเมิน
                    </h1>
                    <p class="text-muted mb-0">ดูและจัดการการประเมินทั้งหมดในระบบ</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
                        กลับไป Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Assessments List -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-clipboard-check me-2"></i>
                รายการการประเมินทั้งหมด
            </h6>
            <div class="d-flex gap-2">
                <span class="badge bg-info">{{ $assessments->total() }} รายการ</span>
            </div>
        </div>
        <div class="card-body p-0">
            @if($assessments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center" style="width: 60px;">ลำดับ</th>
                                <th>ผลิตภัณฑ์</th>
                                <th>ผู้ประเมิน</th>
                                <th>บริษัท</th>
                                <th>ผลการตรวจสอบ</th>
                                <th>สถานะ</th>
                                <th>วันที่ประเมิน</th>
                                <th class="text-center" style="width: 120px;">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($assessments as $index => $assessment)
                            <tr>
                                <td class="text-center">{{ $assessments->firstItem() + $index }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($assessment->product && $assessment->product->image)
                                            <img src="{{ asset('storage/' . $assessment->product->image) }}" 
                                                 alt="{{ $assessment->product->name }}" 
                                                 class="rounded me-2" 
                                                 style="width: 40px; height: 40px; object-fit: cover;">
                                        @else
                                            <div class="bg-light rounded d-flex align-items-center justify-content-center me-2" 
                                                 style="width: 40px; height: 40px;">
                                                <i class="fas fa-box text-muted"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <div class="fw-bold">{{ $assessment->product->name ?? 'ไม่ระบุ' }}</div>
                                            <small class="text-muted">{{ $assessment->product->model ?? '' }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($assessment->user)
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-user-circle fa-lg text-gray-400 me-2"></i>
                                            <div>
                                                <div class="fw-bold">{{ $assessment->user->Customer_Name }}</div>
                                                <small class="text-muted">{{ $assessment->user->Email }}</small>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted">ไม่ระบุ</span>
                                    @endif
                                </td>
                                <td>
                                    @if($assessment->user && $assessment->user->agency)
                                        <span class="badge bg-success">{{ $assessment->user->agency->Agency_Name }}</span>
                                    @else
                                        <span class="badge bg-secondary">ไม่ระบุ</span>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $totalScore = $assessment->answers->sum('score');
                                        $maxScore = $assessment->answers->count() * 5; // สมมติว่าแต่ละข้อมีคะแนนเต็ม 5
                                        $percentage = $maxScore > 0 ? ($totalScore / $maxScore) * 100 : 0;
                                        $progressClass = $percentage >= 80 ? 'bg-success' : ($percentage >= 60 ? 'bg-warning' : 'bg-danger');
                                    @endphp
                                    <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <strong>{{ $totalScore }}/{{ $maxScore }}</strong>
                                        </div>
                                        <div class="progress flex-grow-1" style="height: 8px;">
                                            <div class="progress-bar {{ $progressClass }}" 
                                                 style="width: {{ $percentage }}%"></div>
                                        </div>
                                        <small class="ms-2">{{ number_format($percentage, 1) }}%</small>
                                    </div>
                                </td>
                                <td>
                                    @if($assessment->status == 'submitted')
                                        <span class="badge bg-success">เสร็จสิ้น</span>
                                    @elseif($assessment->status == 'draft')
                                        <span class="badge bg-warning">กำลังดำเนินการ</span>
                                    @else
                                        <span class="badge bg-secondary">รอดำเนินการ</span>
                                    @endif
                                </td>
                                <td>{{ $assessment->DtmIns ? $assessment->DtmIns->format('d/m/Y H:i') : '-' }}</td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.assessments.view', $assessment->id) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.assessments.report', $assessment->id) }}" 
                                           class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-chart-bar"></i>
                                        </a>
                                        @php
                                            $user = Auth::user();
                                            $hasDeleteAccess = false;
                                            
                                            // เจ้าของผลิตภัณฑ์
                                            if($user->Customer_ID === $assessment->product->user_id) {
                                                $hasDeleteAccess = true;
                                            }
                                            // Admin หรือ SuperAdmin
                                            elseif(strtolower($user->Level) === 'admin' || strtolower($user->Level) === 'superadmin') {
                                                $hasDeleteAccess = true;
                                            }
                                            // คนในบริษัทเดียวกัน
                                            elseif($user->Agency_ID && $assessment->product->user && $assessment->product->user->Agency_ID && $user->Agency_ID === $assessment->product->user->Agency_ID) {
                                                $hasDeleteAccess = true;
                                            }
                                        @endphp
                                        
                                        @if($hasDeleteAccess)
                                            <button type="button" class="btn btn-sm btn-outline-danger"
                                                    data-assessment-id="{{ $assessment->id }}"
                                                    onclick="deleteAssessment(this.dataset.assessmentId)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="card-footer">
                    {{ $assessments->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-clipboard-check fa-3x text-gray-300 mb-3"></i>
                    <h5 class="text-gray-500">ไม่พบข้อมูลการประเมิน</h5>
                    <p class="text-muted">ยังไม่มีการประเมินในระบบ</p>
                </div>
            @endif
        </div>
    </div>
</div>

<script>
function deleteAssessment(assessmentId) {
    if (confirm('คุณต้องการลบการประเมินนี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้')) {
        // ส่ง AJAX request เพื่อลบการประเมิน
        fetch(`/admin/assessments/${assessmentId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('เกิดข้อผิดพลาดในการลบการประเมิน');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('เกิดข้อผิดพลาดในการลบการประเมิน');
        });
    }
}
</script>
@endsection 