@extends('layouts.app')

@section('content')
<style>
  /* สีพื้นหลังแบบจาง */
  .q-incomplete {
    background-color: rgba(255, 193, 7, 0.15); /* เหลืองจาง */
  }
  .q-complete {
    background-color: rgba(25, 135, 84, 0.15); /* เขียวจาง */
  }
  /* แถบสถานะด้านซ้าย */
  .q-card-status {
    position: absolute;
    left: 0; top: 0; bottom: 0;
    width: 6px;
    border-top-left-radius: .5rem;
    border-bottom-left-radius: .5rem;
  }
  .q-card-status.success { background-color: #198754; }
  .q-card-status.warning { background-color: #ffc107; }

  .q-card { position: relative; border-radius: .5rem; }

  /* สำหรับ accordion parent */
  .accordion-item.q-complete > .accordion-header > .accordion-button {
    background-color: rgba(25, 135, 84, 0.15);
    color: #198754;
    font-weight: bold;
  }
  .accordion-item.q-incomplete > .accordion-header > .accordion-button {
    background-color: rgba(255, 193, 7, 0.15);
    color: #856404;
  }
</style>

<div class="container mt-4">
  <div class="row justify-content-center">
    <div class="col-md-10">

      {{-- Progress Bar --}}
      <div class="card shadow mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">
              <i class="fas fa-edit me-2"></i> ทำต่อการประเมินผลิตภัณฑ์
            </h6>
            <span id="progress-text" class="badge bg-warning">ฉบับร่าง</span>
          </div>
          <div class="progress" style="height:10px;">
            <div id="progress-bar" class="progress-bar bg-warning" role="progressbar" style="width:0%"></div>
          </div>
          <div id="progress-status" class="text-muted small mt-2">
            กรุณาตอบคำถามการประเมินให้ครบถ้วน
          </div>
        </div>
      </div>

      {{-- Product Info --}}
      <div class="card shadow mb-4">
        <div class="card-header bg-info text-white">
          <h4 class="mb-0"><i class="fas fa-box me-2"></i> ข้อมูลผลิตภัณฑ์</h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <table class="table table-borderless">
                <tr><td class="fw-bold" style="width:150px;">ชื่อผลิตภัณฑ์:</td><td>{{ $assessment->product->name ?? 'ไม่ระบุ' }}</td></tr>
                <tr><td class="fw-bold">โมเดล/รุ่น:</td><td>{{ $assessment->product->model ?? 'ไม่ระบุ' }}</td></tr>
                <tr><td class="fw-bold">วิธีรับข้อมูล:</td><td>{{ $assessment->product->log_receive_method ?? 'ไม่ระบุ' }}</td></tr>
                <tr><td class="fw-bold">ประเภทผลิตภัณฑ์:</td><td>{{ $assessment->product->product_type ?? 'ไม่ระบุ' }}</td></tr>
              </table>
            </div>
            <div class="col-md-6">
              @if($assessment->product->image)
                <div class="text-center">
                  <img src="{{ asset('storage/' . $assessment->product->image) }}" alt="รูปภาพผลิตภัณฑ์" class="img-fluid rounded" style="max-height:150px;">
                </div>
              @else
                <div class="text-center text-muted">
                  <i class="fas fa-image fa-2x mb-2"></i><p>ไม่มีรูปภาพ</p>
                </div>
              @endif
            </div>
          </div>
        </div>
      </div>

      {{-- Tips --}}
      <div class="alert alert-warning border-0 shadow-sm">
        <div class="d-flex align-items-center">
          <i class="fas fa-exclamation-triangle fa-2x me-3 text-warning"></i>
          <div>
            <h6 class="alert-heading mb-1">ทำต่อจากฉบับร่าง</h6>
            <p class="mb-0 small">กรอกต่อแล้วกด “บันทึกฉบับร่าง” หรือ “ส่งแบบประเมิน” เมื่อพร้อม</p>
          </div>
        </div>
      </div>

      {{-- FORM --}}
      <form id="assessment-form" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="assessment_id" value="{{ $assessment->id }}">
        <input type="hidden" name="product_id" value="{{ $assessment->product_id }}">

        {{-- Questions --}}
        <div class="mb-4">
          @php $globalQuestionNumber = 1; @endphp
          @foreach($questionGroups as $group)
            <div class="mb-4">
              <div class="row">
                @foreach($group->questions as $question)
                  @if($question->use_in_evaluation && !$question->parent_id && $question->question_type !== null)
                    <div class="col-12 mb-4">
                      <div class="card border-0 shadow-sm q-card q-incomplete" data-question-id="{{ $question->id }}">
                        <div class="q-card-status warning"></div>
                        <div class="card-body p-4">
                          <div class="d-flex align-items-start mb-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width:40px;height:40px;min-width:40px;">
                              <span class="question-number">{{ $globalQuestionNumber }}</span>
                            </div>
                            <div class="flex-grow-1">
                              <h6 class="card-title mb-2 question-label">{{ $question->question_text }}</h6>

                              @php
                                $existingAnswer = $assessment->answers->where('question_id', $question->id)->first();
                                $existingChoice = $existingAnswer?->answer_text;   // "ใช่"/"ไม่ใช่" หรือ choice
                                $existingDetails = $existingAnswer?->comment;
                              @endphp

                              @if($question->question_type == 'yes_no')
                                <div class="mb-3">
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio"
                                      name="answers[{{ $question->id }}][choice]"
                                      id="yes_{{ $question->id }}"
                                      value="ใช่"
                                      data-question-id="{{ $question->id }}"
                                      {{ $existingChoice === 'ใช่' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="yes_{{ $question->id }}">ใช่</label>
                                  </div>
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio"
                                      name="answers[{{ $question->id }}][choice]"
                                      id="no_{{ $question->id }}"
                                      value="ไม่ใช่"
                                      data-question-id="{{ $question->id }}"
                                      {{ $existingChoice === 'ไม่ใช่' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="no_{{ $question->id }}">ไม่ใช่</label>
                                  </div>
                                </div>

                                {{-- ช่องรายละเอียดเมื่อ "ใช่" --}}
                                <div id="text_field_{{ $question->id }}" class="mt-3" style="display: {{ $existingChoice === 'ใช่' ? 'block' : 'none' }};">
                                  <label class="form-label text-muted"><i class="fas fa-comment me-1"></i> กรุณาระบุรายละเอียดเพิ่มเติม:</label>
                                  <textarea
                                    name="answers[{{ $question->id }}][details]"
                                    class="form-control border-0 bg-light evaluation-field details-field"
                                    rows="3"
                                    placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                    style="resize:none;"
                                  >{{ $existingDetails }}</textarea>
                                </div>
                              @elseif($question->question_type == 'multiple_choice')
                                @php
                                  $choices = is_string($question->choices) ? json_decode($question->choices, true) : $question->choices;
                                  $existingChoice = $existingAnswer?->answer_text;
                                @endphp
                                <div class="mb-3">
                                  @if($choices && is_array($choices) && count($choices))
                                    @foreach($choices as $i => $choice)
                                      <div class="form-check">
                                        <input class="form-check-input multiple-choice-radio" type="radio"
                                          name="answers[{{ $question->id }}][choice]"
                                          id="choice_{{ $question->id }}_{{ $i }}"
                                          value="{{ $choice }}"
                                          data-question-id="{{ $question->id }}"
                                          {{ $existingChoice === $choice ? 'checked' : '' }}>
                                        <label class="form-check-label" for="choice_{{ $question->id }}_{{ $i }}">{{ $choice }}</label>
                                      </div>
                                    @endforeach
                                  @else
                                    <div class="alert alert-warning border-0">
                                      <i class="fas fa-exclamation-triangle me-2"></i> ไม่มีตัวเลือก กรุณาติดต่อผู้ดูแลระบบ
                                    </div>
                                  @endif
                                </div>
                              @elseif($question->question_type == 'text')
                                @php $existingText = $existingAnswer?->answer_text ?? ''; @endphp
                                <div class="mb-3">
                                  <textarea
                                    name="answers[{{ $question->id }}][text]"
                                    class="form-control border-0 bg-light evaluation-field text-field"
                                    rows="3" placeholder="กรุณาตอบคำถาม..." style="resize:none;"
                                  >{{ $existingText }}</textarea>
                                </div>
                              @endif
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    @php $globalQuestionNumber++; @endphp
                  @endif

                  {{-- Parent + Children --}}
                  @if(!$question->use_in_evaluation && $question->question_type === null && !$question->parent_id)
                    <div class="col-12 mb-3">
                      <div class="accordion-item border-0">
                        <h2 class="accordion-header" id="heading-parent-{{ $question->id }}">
                          <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-parent-{{ $question->id }}" style="padding:1.5rem;">
                            <div class="d-flex align-items-center w-100">
                              <div class="flex-grow-1">
                                <h6 class="mb-1 question-label">{{ $question->question_text }}</h6>
                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                              </div>
                              <i class="fas fa-chevron-down ms-auto"></i>
                            </div>
                          </button>
                        </h2>
                        <div id="collapse-parent-{{ $question->id }}" class="accordion-collapse collapse" aria-labelledby="heading-parent-{{ $question->id }}">
                          <div class="accordion-body bg-white p-4">
                            <div class="row">
                              @foreach($group->questions->where('parent_id', $question->id) as $child)
                                @if($child->use_in_evaluation && $child->question_type !== null)
                                  <div class="col-12 mb-4">
                                    <div class="card border-0 shadow-sm q-card q-incomplete" data-question-id="{{ $child->id }}">
                                      <div class="q-card-status warning"></div>
                                      <div class="card-body p-4">
                                        <div class="ms-4 border-start border-primary ps-3">
                                          <h6 class="card-title mb-2 text-dark">{{ $child->question_text }}</h6>

                                          @php
                                            $existingAnswer = $assessment->answers->where('question_id', $child->id)->first();
                                            $existingChoice = $existingAnswer?->answer_text;
                                            $existingDetails = $existingAnswer?->comment;
                                          @endphp

                                          @if($child->question_type == 'yes_no')
                                            <div class="mb-3">
                                              <div class="form-check form-check-inline">
                                                <input class="form-check-input yes-no-radio" type="radio"
                                                  name="answers[{{ $child->id }}][choice]"
                                                  id="yes_{{ $child->id }}"
                                                  value="ใช่"
                                                  data-question-id="{{ $child->id }}"
                                                  {{ $existingChoice === 'ใช่' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="yes_{{ $child->id }}">ใช่</label>
                                              </div>
                                              <div class="form-check form-check-inline">
                                                <input class="form-check-input yes-no-radio" type="radio"
                                                  name="answers[{{ $child->id }}][choice]"
                                                  id="no_{{ $child->id }}"
                                                  value="ไม่ใช่"
                                                  data-question-id="{{ $child->id }}"
                                                  {{ $existingChoice === 'ไม่ใช่' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="no_{{ $child->id }}">ไม่ใช่</label>
                                              </div>
                                            </div>

                                            <div id="text_field_{{ $child->id }}" class="mt-3" style="display: {{ $existingChoice === 'ใช่' ? 'block' : 'none' }};">
                                              <label class="form-label text-muted"><i class="fas fa-comment me-1"></i> กรุณาระบุรายละเอียดเพิ่มเติม:</label>
                                              <textarea
                                                name="answers[{{ $child->id }}][details]"
                                                class="form-control border-0 bg-light evaluation-field details-field"
                                                rows="3" placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..." style="resize:none;"
                                              >{{ $existingDetails }}</textarea>
                                            </div>
                                          @elseif($child->question_type == 'multiple_choice')
                                            @php
                                              $choices = is_string($child->choices) ? json_decode($child->choices, true) : $child->choices;
                                              $existingChoice = $existingAnswer?->answer_text;
                                            @endphp
                                            <div class="mb-3">
                                              @if($choices && is_array($choices) && count($choices))
                                                @foreach($choices as $i => $choice)
                                                  <div class="form-check">
                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                      name="answers[{{ $child->id }}][choice]"
                                                      id="choice_{{ $child->id }}_{{ $i }}"
                                                      value="{{ $choice }}"
                                                      data-question-id="{{ $child->id }}"
                                                      {{ $existingChoice === $choice ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="choice_{{ $child->id }}_{{ $i }}">{{ $choice }}</label>
                                                  </div>
                                                @endforeach
                                              @else
                                                <div class="alert alert-warning border-0"><i class="fas fa-exclamation-triangle me-2"></i> ไม่มีตัวเลือก</div>
                                              @endif
                                            </div>
                                          @elseif($child->question_type == 'text')
                                            @php $existingText = $existingAnswer?->answer_text ?? ''; @endphp
                                            <div class="mb-3">
                                              <textarea name="answers[{{ $child->id }}][text]" class="form-control border-0 bg-light evaluation-field text-field" rows="3" placeholder="กรุณาตอบคำถาม..." style="resize:none;">{{ $existingText }}</textarea>
                                            </div>
                                          @endif

                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  @php $globalQuestionNumber++; @endphp
                                @endif
                              @endforeach
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  @endif

                @endforeach
              </div>
            </div>
          @endforeach
        </div>

        {{-- Action buttons --}}
        <div class="text-center mt-4">
          <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="{{ route('products.index') }}" class="btn btn-outline-secondary btn-lg px-4">
              <i class="fas fa-arrow-left me-2"></i> ย้อนกลับ
            </a>

            {{-- บันทึกฉบับร่าง --}}
            <button type="button"
                    class="btn btn-warning btn-lg px-4"
                    id="btn-save-draft"
                    data-action="{{ route('assessments.store-draft') }}">
              <i class="fas fa-save me-2"></i> บันทึกฉบับร่าง
            </button>

            {{-- ส่งแบบประเมิน --}}
            <button type="button"
                    class="btn btn-success btn-lg px-5"
                    id="btn-submit"
                    data-action="{{ route('assessments.submit-draft') }}"
                    disabled>
              <i class="fas fa-paper-plane me-2"></i> ส่งแบบประเมิน
            </button>
          </div>
        </div>

      </form>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const form       = document.getElementById('assessment-form');
  const btnDraft   = document.getElementById('btn-save-draft');
  const btnSubmit  = document.getElementById('btn-submit');

  const progressBar    = document.getElementById('progress-bar');
  const progressText   = document.getElementById('progress-text');
  const progressStatus = document.getElementById('progress-status');

  const qCards = document.querySelectorAll('.q-card[data-question-id]');
  const total = qCards.length;

  function isCardComplete(card) {
    const yesNo = card.querySelectorAll('.yes-no-radio');
    if (yesNo.length) {
      const checked = card.querySelector('.yes-no-radio:checked');
      if (!checked) return false;
      if (checked.value === 'ใช่') {
        const details = card.querySelector('.details-field');
        if (details && !details.value.trim()) return false;
      }
      return true;
    }
    const multi = card.querySelectorAll('.multiple-choice-radio');
    if (multi.length) {
      return !!card.querySelector('.multiple-choice-radio:checked');
    }
    const txt = card.querySelector('.text-field');
    if (txt) return !!txt.value.trim();
    return false;
  }

  function styleCard(card, complete) {
    card.classList.toggle('q-complete', complete);
    card.classList.toggle('q-incomplete', !complete);

    const bar = card.querySelector('.q-card-status');
    if (bar) {
      bar.classList.toggle('success', complete);
      bar.classList.toggle('warning', !complete);
    }
  }

  function renderProgress() {
    let done = 0;
    qCards.forEach(card => {
      const ok = isCardComplete(card);
      if (ok) done++;
      styleCard(card, ok);

      // === update accordion parent ===
      const parentAccordion = card.closest('.accordion-body');
      if (parentAccordion) {
        const parentItem = parentAccordion.closest('.accordion-item');
        if (parentItem) {
          const children = parentAccordion.querySelectorAll('.q-card[data-question-id]');
          const completeChildren = parentAccordion.querySelectorAll('.q-card.q-complete');
          parentItem.classList.toggle('q-complete', children.length && children.length === completeChildren.length);
          parentItem.classList.toggle('q-incomplete', !(children.length && children.length === completeChildren.length));
        }
      }
    });

    const percent = total ? (done / total) * 100 : 0;
    progressBar.style.width = percent + '%';

    if (done === total && total > 0) {
      progressText.textContent = 'Complete!';
      progressText.className = 'badge bg-success';
      progressStatus.textContent = 'พร้อมส่งแบบประเมิน';
      btnSubmit.disabled = false;
    } else {
      progressText.textContent = `${done}/${total}`;
      progressText.className = 'badge bg-warning';
      progressStatus.textContent = `กรุณาตอบคำถามให้ครบถ้วน (${done}/${total})`;
      btnSubmit.disabled = true;
    }
  }

  document.querySelectorAll('.yes-no-radio').forEach(r => {
    r.addEventListener('change', function () {
      const box = document.getElementById('text_field_' + this.dataset.questionId);
      if (box) box.style.display = (this.value === 'ใช่') ? 'block' : 'none';
      renderProgress();
    });
  });

  document.querySelectorAll('.evaluation-field, .multiple-choice-radio, .text-field, .details-field')
    .forEach(el => {
      el.addEventListener('input', renderProgress);
      el.addEventListener('change', renderProgress);
    });

  function postTo(url) {
    form.setAttribute('action', url);
    form.setAttribute('method', 'POST');
    const spoof = form.querySelector('input[name="_method"]');
    if (spoof) spoof.remove();

    btnDraft.disabled = true;
    btnSubmit.disabled = true;
    form.submit();
  }

  btnDraft?.addEventListener('click', () => postTo(btnDraft.dataset.action));
  btnSubmit?.addEventListener('click', () => postTo(btnSubmit.dataset.action));

  renderProgress();
});
</script>


@endsection
