<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('ลบบัญชีผู้ใช้งาน') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __('หากลบบัญชีผู้ใช้งาน จะทำให้ข้อมูลทั้งหมดถูกลบออกจากระบบอย่างถาวร ก่อนลบบัญชีผู้ใช้งาน กรุณาดาวน์โหลดข้อมูลที่คุณต้องการรักษา') }}
        </p>
    </header>

    <x-danger-button
        x-data=""
        x-on:click.prevent="$dispatch('open-modal', 'confirm-user-deletion')"
    >{{ __('ลบบัญชีผู้ใช้งาน') }}</x-danger-button>

    <x-modal name="confirm-user-deletion" :show="$errors->userDeletion->isNotEmpty()" focusable>
        <form method="post" action="{{ route('profile.destroy') }}" class="p-6">
            @csrf
            @method('delete')

            <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                {{ __('คุณแน่ใจหรือว่าต้องการลบบัญชีผู้ใช้งานของคุณ?') }}
            </h2>

            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                {{ __('หากลบบัญชีผู้ใช้งาน จะทำให้ข้อมูลทั้งหมดถูกลบออกจากระบบอย่างถาวร กรุณากรอกรหัสผ่านของคุณเพื่อยืนยันการลบบัญชีผู้ใช้งานของคุณ') }}
            </p>

            <div class="mt-6">
                <x-input-label for="password" value="{{ __('รหัสผ่าน') }}" class="sr-only" />

                <x-text-input
                    id="password"
                    name="password"
                    type="password"
                    class="mt-1 block w-3/4"
                    placeholder="{{ __('Password') }}"
                />

                <x-input-error :messages="$errors->userDeletion->get('password')" class="mt-2" />
            </div>

            <div class="mt-6 flex justify-end">
                <x-secondary-button x-on:click="$dispatch('close')">
                    {{ __('Cancel') }}
                </x-secondary-button>

                <x-danger-button class="ms-3">
                    {{ __('Delete Account') }}
                </x-danger-button>
            </div>
        </form>
    </x-modal>
</section>
