@if ($paginator->hasPages())
    <nav aria-label="Pagination Navigation" class="mt-4">
        <div class="d-flex flex-column flex-sm-row align-items-center justify-content-between">
            {{-- Results Info --}}
            <div class="mb-3 mb-sm-0">
                <p class="text-muted mb-0">
                    แสดง <span class="fw-bold text-primary">{{ $paginator->firstItem() }}</span> 
                    ถึง <span class="fw-bold text-primary">{{ $paginator->lastItem() }}</span> 
                    จากทั้งหมด <span class="fw-bold text-primary">{{ $paginator->total() }}</span> รายการ
                </p>
            </div>

            {{-- Pagination Controls --}}
            <div class="d-flex align-items-center">
                {{-- Previous Button --}}
                @if ($paginator->onFirstPage())
                    <button class="btn btn-outline-secondary btn-sm me-2" disabled>
                        <i class="fas fa-chevron-left me-1"></i>ก่อนหน้า
                    </button>
                @else
                    <a href="{{ $paginator->previousPageUrl() }}" 
                       class="btn btn-outline-primary btn-sm me-2" 
                       rel="prev">
                        <i class="fas fa-chevron-left me-1"></i>ก่อนหน้า
                    </a>
                @endif

                {{-- Page Numbers --}}
                <div class="btn-group" role="group">
                    @foreach ($elements as $element)
                        {{-- "Three Dots" Separator --}}
                        @if (is_string($element))
                            <button class="btn btn-outline-secondary btn-sm disabled" disabled>
                                {{ $element }}
                            </button>
                        @endif

                        {{-- Array Of Links --}}
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <button class="btn btn-primary btn-sm active" aria-current="page">
                                        {{ $page }}
                                    </button>
                                @else
                                    <a href="{{ $url }}" class="btn btn-outline-primary btn-sm">
                                        {{ $page }}
                                    </a>
                                @endif
                            @endforeach
                        @endif
                    @endforeach
                </div>

                {{-- Next Button --}}
                @if ($paginator->hasMorePages())
                    <a href="{{ $paginator->nextPageUrl() }}" 
                       class="btn btn-outline-primary btn-sm ms-2" 
                       rel="next">
                        ถัดไป<i class="fas fa-chevron-right ms-1"></i>
                    </a>
                @else
                    <button class="btn btn-outline-secondary btn-sm ms-2" disabled>
                        ถัดไป<i class="fas fa-chevron-right ms-1"></i>
                    </button>
                @endif
            </div>
        </div>

        {{-- Mobile Pagination (Simple) --}}
        <div class="d-flex d-sm-none justify-content-center mt-3">
            <div class="btn-group" role="group">
                @if ($paginator->onFirstPage())
                    <button class="btn btn-outline-secondary btn-sm" disabled>
                        <i class="fas fa-chevron-left"></i>
                    </button>
                @else
                    <a href="{{ $paginator->previousPageUrl() }}" 
                       class="btn btn-outline-primary btn-sm" 
                       rel="prev">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                @endif

                <span class="btn btn-outline-info btn-sm disabled">
                    หน้า {{ $paginator->currentPage() }} จาก {{ $paginator->lastPage() }}
                </span>

                @if ($paginator->hasMorePages())
                    <a href="{{ $paginator->nextPageUrl() }}" 
                       class="btn btn-outline-primary btn-sm" 
                       rel="next">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                @else
                    <button class="btn btn-outline-secondary btn-sm" disabled>
                        <i class="fas fa-chevron-right"></i>
                    </button>
                @endif
            </div>
        </div>
    </nav>
@endif
