<?php $__env->startSection('content'); ?>
<div class="container mt-4">
  <div class="row justify-content-center">
    <div class="col-md-8">
      
      <div class="card shadow mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0"><i class="fas fa-edit me-2"></i>ทำต่อการประเมินผลิตภัณฑ์</h6>
            <span id="progress-text" class="badge bg-warning">ฉบับร่าง</span>
          </div>
          <div class="progress" style="height:10px;">
            <div id="progress-bar" class="progress-bar bg-warning" style="width:0%"></div>
          </div>
          <div id="progress-status" class="text-muted small mt-2">กรุณาตอบคำถามให้ครบถ้วน</div>
        </div>
      </div>

      
      <?php $prod = $assessment->product; ?>
      <div class="card shadow mb-4">
        <div class="card-header bg-info text-white">
          <h4 class="mb-0"><i class="fas fa-box me-2"></i>ข้อมูลผลิตภัณฑ์</h4>
        </div>
        <div class="card-body">
          <?php if($prod): ?>
            <div class="row">
              <div class="col-md-6">
                <table class="table table-borderless">
                  <tr>
                    <td class="fw-bold" style="width:150px;">ชื่อผลิตภัณฑ์:</td>
                    <td><?php echo e($prod?->name ?? 'ไม่ระบุ'); ?></td>
                  </tr>
                  <tr>
                    <td class="fw-bold">โมเดล/รุ่น:</td>
                    <td><?php echo e($prod?->model ?? 'ไม่ระบุ'); ?></td>
                  </tr>
                  <tr>
                    <td class="fw-bold">วิธีรับข้อมูล:</td>
                    <td><?php echo e($prod?->log_receive_method_label ?? $prod?->log_receive_method ?? 'ไม่ระบุ'); ?></td>
                  </tr>
                  <tr>
                    <td class="fw-bold">ประเภทผลิตภัณฑ์:</td>
                    <td><?php echo e($prod?->product_type_label ?? $prod?->product_type ?? 'ไม่ระบุ'); ?></td>
                  </tr>
                </table>
              </div>
              <div class="col-md-6">
                <?php if($prod?->image): ?>
                  <div class="text-center">
                    <img src="<?php echo e(asset('storage/' . $prod->image)); ?>" alt="รูปภาพผลิตภัณฑ์"
                         class="img-fluid rounded" style="max-height:150px;">
                  </div>
                <?php else: ?>
                  <div class="text-center text-muted">
                    <i class="fas fa-image fa-2x mb-2"></i>
                    <p class="mb-0">ไม่มีรูปภาพ</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          <?php else: ?>
            <div class="alert alert-danger mb-0">
              <i class="fas fa-exclamation-triangle me-2"></i>
              ไม่พบข้อมูลผลิตภัณฑ์ที่เชื่อมกับแบบประเมินนี้ (อาจถูกลบหรืออ้างอิงไม่ถูกต้อง)
            </div>
          <?php endif; ?>
        </div>
      </div>

      
      <div class="alert alert-warning border-0 shadow-sm">
        <div class="d-flex align-items-center">
          <i class="fas fa-exclamation-triangle fa-2x me-3 text-warning"></i>
          <div>
            <h6 class="alert-heading mb-1">ทำต่อจากฉบับร่าง</h6>
            <p class="mb-0 small">ตอบให้ครบแล้วกด “ส่งแบบประเมิน”</p>
          </div>
        </div>
      </div>

      
      <form method="POST" id="assessment-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="Agency_ID" value="<?php echo e($agencyId); ?>">
        <input type="hidden" name="assessment_id" value="<?php echo e($assessment->id); ?>">

        <div class="mb-4">
          <?php $globalQuestionNumber = 1; ?>
          <?php $__currentLoopData = $questionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-4">
              <div class="row">
                <?php $__currentLoopData = $group->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if($question->use_in_evaluation && !$question->parent_id && $question->question_type !== null): ?>
                    <?php
                      $ans     = $assessment->answers->firstWhere('question_id', $question->id);
                      $choice  = $ans->answer_text ?? null;     // ใช่/ไม่ใช่ หรือค่าตัวเลือก
                      $comment = $ans->comment ?? null;         // รายละเอียดเมื่อเลือก "ใช่"
                      $text    = $ans->answer_text ?? '';        // สำหรับคำถามแบบข้อความ
                      $choices = $question->choices;
                      if (is_string($choices)) $choices = json_decode($choices, true);
                    ?>

                    <div class="col-12 mb-4">
                      <div class="card border-0 shadow-sm">
                        <div class="card-body p-4">
                          <div class="d-flex align-items-start mb-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width:40px;height:40px;min-width:40px;">
                              <span class="question-number"><?php echo e($globalQuestionNumber); ?></span>
                            </div>
                            <div class="flex-grow-1">
                              <h6 class="card-title mb-2"><?php echo e($question->question_text); ?></h6>

                              <?php if($question->question_type == 'yes_no'): ?>
                                <div class="mb-3">
                                  <label class="me-3">
                                    <input class="form-check-input yes-no-radio" type="radio"
                                           name="answers[<?php echo e($question->id); ?>][choice]"
                                           value="ใช่" data-question-id="<?php echo e($question->id); ?>"
                                           <?php echo e($choice === 'ใช่' ? 'checked' : ''); ?>> ใช่
                                  </label>
                                  <label>
                                    <input class="form-check-input yes-no-radio" type="radio"
                                           name="answers[<?php echo e($question->id); ?>][choice]"
                                           value="ไม่ใช่" data-question-id="<?php echo e($question->id); ?>"
                                           <?php echo e($choice === 'ไม่ใช่' ? 'checked' : ''); ?>> ไม่ใช่
                                  </label>
                                </div>

                                <div id="text_field_<?php echo e($question->id); ?>" class="mt-3" style="display: <?php echo e($choice === 'ใช่' ? 'block' : 'none'); ?>;">
                                  <label class="form-label text-muted">
                                    <i class="fas fa-comment me-1"></i>รายละเอียดเพิ่มเติม
                                  </label>
                                  <textarea name="answers[<?php echo e($question->id); ?>][details]"
                                            class="form-control border-0 bg-light evaluation-text"
                                            rows="3" style="resize:none;"><?php echo e($comment); ?></textarea>
                                </div>

                              <?php elseif($question->question_type == 'multiple_choice'): ?>
                                <div class="mb-3">
                                  <?php if($choices && is_array($choices)): ?>
                                    <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <div class="form-check">
                                        <input class="form-check-input multiple-choice-radio" type="radio"
                                               name="answers[<?php echo e($question->id); ?>][choice]"
                                               id="choice_<?php echo e($question->id); ?>_<?php echo e($i); ?>"
                                               value="<?php echo e($c); ?>" data-question-id="<?php echo e($question->id); ?>"
                                               <?php echo e($choice === $c ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="choice_<?php echo e($question->id); ?>_<?php echo e($i); ?>"><?php echo e($c); ?></label>
                                      </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  <?php else: ?>
                                    <div class="alert alert-warning border-0">ไม่มีตัวเลือก กรุณาติดต่อผู้ดูแล</div>
                                  <?php endif; ?>
                                </div>

                              <?php elseif($question->question_type == 'text'): ?>
                                <div class="mb-3">
                                  <textarea name="answers[<?php echo e($question->id); ?>][text]"
                                            class="form-control border-0 bg-light evaluation-text"
                                            rows="3" style="resize:none;"><?php echo e($text); ?></textarea>
                                </div>
                              <?php endif; ?>

                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <?php $globalQuestionNumber++; ?>

                  <?php elseif(!$question->use_in_evaluation && $question->question_type === null && !$question->parent_id): ?>
                    
                    <div class="col-12 mb-3">
                      <div class="accordion-item border-0">
                        <h2 class="accordion-header" id="heading-<?php echo e($question->id); ?>">
                          <button class="accordion-button collapsed bg-light border rounded-3"
                                  type="button" data-bs-toggle="collapse"
                                  data-bs-target="#collapse-<?php echo e($question->id); ?>" style="padding:1.5rem;">
                            <div class="d-flex align-items-center w-100">
                              <div class="flex-grow-1">
                                <h6 class="mb-1"><?php echo e($question->question_text); ?></h6>
                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                              </div>
                              <i class="fas fa-chevron-down ms-auto"></i>
                            </div>
                          </button>
                        </h2>
                        <div id="collapse-<?php echo e($question->id); ?>" class="accordion-collapse collapse">
                          <div class="accordion-body bg-white p-4">
                            <div class="row">
                              <?php $__currentLoopData = $group->questions->where('parent_id', $question->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($child->use_in_evaluation && $child->question_type !== null): ?>
                                  <?php
                                    $ansC     = $assessment->answers->firstWhere('question_id', $child->id);
                                    $choiceC  = $ansC->answer_text ?? null;
                                    $commentC = $ansC->comment ?? null;
                                    $textC    = $ansC->answer_text ?? '';
                                    $choicesC = $child->choices;
                                    if (is_string($choicesC)) $choicesC = json_decode($choicesC, true);
                                  ?>
                                  <div class="col-12 mb-4">
                                    <div class="card border-0 shadow-sm">
                                      <div class="card-body p-4">
                                        <div class="ms-4 border-start border-primary ps-3">
                                          <h6 class="card-title mb-2"><?php echo e($child->question_text); ?></h6>

                                          <?php if($child->question_type == 'yes_no'): ?>
                                            <div class="mb-3">
                                              <label class="me-3">
                                                <input class="form-check-input yes-no-radio" type="radio"
                                                       name="answers[<?php echo e($child->id); ?>][choice]"
                                                       value="ใช่" data-question-id="<?php echo e($child->id); ?>"
                                                       <?php echo e($choiceC === 'ใช่' ? 'checked' : ''); ?>> ใช่
                                              </label>
                                              <label>
                                                <input class="form-check-input yes-no-radio" type="radio"
                                                       name="answers[<?php echo e($child->id); ?>][choice]"
                                                       value="ไม่ใช่" data-question-id="<?php echo e($child->id); ?>"
                                                       <?php echo e($choiceC === 'ไม่ใช่' ? 'checked' : ''); ?>> ไม่ใช่
                                              </label>
                                            </div>
                                            <div id="text_field_<?php echo e($child->id); ?>" class="mt-3" style="display: <?php echo e($choiceC === 'ใช่' ? 'block' : 'none'); ?>;">
                                              <label class="form-label text-muted"><i class="fas fa-comment me-1"></i>รายละเอียดเพิ่มเติม</label>
                                              <textarea name="answers[<?php echo e($child->id); ?>][details]"
                                                        class="form-control border-0 bg-light evaluation-text"
                                                        rows="3" style="resize:none;"><?php echo e($commentC); ?></textarea>
                                            </div>

                                          <?php elseif($child->question_type == 'multiple_choice'): ?>
                                            <div class="mb-3">
                                              <?php if($choicesC && is_array($choicesC)): ?>
                                                <?php $__currentLoopData = $choicesC; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                  <div class="form-check">
                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                           name="answers[<?php echo e($child->id); ?>][choice]"
                                                           id="choice_<?php echo e($child->id); ?>_<?php echo e($i); ?>"
                                                           value="<?php echo e($c); ?>" data-question-id="<?php echo e($child->id); ?>"
                                                           <?php echo e($choiceC === $c ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="choice_<?php echo e($child->id); ?>_<?php echo e($i); ?>"><?php echo e($c); ?></label>
                                                  </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                              <?php else: ?>
                                                <div class="alert alert-warning border-0">ไม่มีตัวเลือก กรุณาติดต่อผู้ดูแล</div>
                                              <?php endif; ?>
                                            </div>

                                          <?php elseif($child->question_type == 'text'): ?>
                                            <div class="mb-3">
                                              <textarea name="answers[<?php echo e($child->id); ?>][text]"
                                                        class="form-control border-0 bg-light evaluation-text"
                                                        rows="3" style="resize:none;"><?php echo e($textC); ?></textarea>
                                            </div>
                                          <?php endif; ?>

                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <?php $globalQuestionNumber++; ?>
                                <?php endif; ?>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        
        <div class="text-center mt-4">
          <div class="d-flex justify-content-center gap-3">
            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-secondary btn-lg px-4">
              <i class="fas fa-arrow-left me-2"></i> ย้อนกลับ
            </a>

            <button type="submit"
                    class="btn btn-secondary btn-lg px-4"
                    formaction="<?php echo e(route('assessments.saveDraft', $assessment->id)); ?>">
              <i class="fas fa-save me-2"></i> บันทึกฉบับร่าง
            </button>

            <button type="submit"
                    class="btn btn-success btn-lg px-5"
                    id="evaluation-submit-btn"
                    formaction="<?php echo e(route('assessments.submit', $assessment->id)); ?>"
                    style="display:none;">
              <i class="fas fa-paper-plane me-2"></i> ส่งแบบประเมิน
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const progressBar   = document.getElementById('progress-bar');
  const progressText  = document.getElementById('progress-text');
  const progressStatus= document.getElementById('progress-status');
  const submitBtn     = document.getElementById('evaluation-submit-btn');

  const yesNoNames = new Set([...document.querySelectorAll('.yes-no-radio')].map(r => r.name));
  const mcNames    = new Set([...document.querySelectorAll('.multiple-choice-radio')].map(r => r.name));
  const textAreas  = [...document.querySelectorAll('.evaluation-text[name^="answers"][name$="[text]"], .evaluation-text[name^="answers"][name$="[details]"]')];

  const total = yesNoNames.size + mcNames.size + textAreas.length;

  function updateProgress() {
    let done = 0;

    yesNoNames.forEach(name => {
      if (document.querySelector(`input[name="${CSS.escape(name)}"]:checked`)) done++;
    });
    mcNames.forEach(name => {
      if (document.querySelector(`input[name="${CSS.escape(name)}"]:checked`)) done++;
    });
    textAreas.forEach(t => { if ((t.value || '').trim() !== '') done++; });

    const pct = total ? (done/total)*100 : 0;
    progressBar.style.width = pct + '%';

    if (done === total && total > 0) {
      progressText.textContent = 'Complete!';
      progressText.className = 'badge bg-success';
      progressStatus.textContent = 'พร้อมส่งแบบประเมิน';
      submitBtn.style.display = 'inline-block';
      submitBtn.disabled = false;
    } else {
      progressText.textContent = `${done}/${total}`;
      progressText.className = 'badge bg-warning';
      progressStatus.textContent = `กรุณาตอบคำถามให้ครบถ้วน (${done}/${total})`;
      submitBtn.style.display = 'none';
    }
  }

  // toggle textarea เมื่อ yes/no
  document.querySelectorAll('.yes-no-radio').forEach(r => {
    r.addEventListener('change', function() {
      const qid = this.dataset.questionId;
      const wrap = document.getElementById(`text_field_${qid}`);
      if (wrap) {
        if (this.value === 'ใช่') { wrap.style.display = 'block'; }
        else { wrap.style.display = 'none'; const ta = wrap.querySelector('textarea'); if (ta) ta.value=''; }
      }
      updateProgress();
    });
  });

  document.querySelectorAll('.multiple-choice-radio').forEach(r => r.addEventListener('change', updateProgress));
  textAreas.forEach(t => t.addEventListener('input', updateProgress));
  updateProgress();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/assessments/edit.blade.php ENDPATH**/ ?>