<?php if($paginator->hasPages()): ?>
    <nav aria-label="Pagination Navigation" class="mt-4">
        <div class="d-flex flex-column flex-sm-row align-items-center justify-content-between">
            
            <div class="mb-3 mb-sm-0">
                <p class="text-muted mb-0">
                    แสดง <span class="fw-bold text-primary"><?php echo e($paginator->firstItem()); ?></span> 
                    ถึง <span class="fw-bold text-primary"><?php echo e($paginator->lastItem()); ?></span> 
                    จากทั้งหมด <span class="fw-bold text-primary"><?php echo e($paginator->total()); ?></span> รายการ
                </p>
            </div>

            
            <div class="d-flex align-items-center">
                
                <?php if($paginator->onFirstPage()): ?>
                    <button class="btn btn-outline-secondary btn-sm me-2" disabled>
                        <i class="fas fa-chevron-left me-1"></i>ก่อนหน้า
                    </button>
                <?php else: ?>
                    <a href="<?php echo e($paginator->previousPageUrl()); ?>" 
                       class="btn btn-outline-primary btn-sm me-2" 
                       rel="prev">
                        <i class="fas fa-chevron-left me-1"></i>ก่อนหน้า
                    </a>
                <?php endif; ?>

                
                <div class="btn-group" role="group">
                    <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if(is_string($element)): ?>
                            <button class="btn btn-outline-secondary btn-sm disabled" disabled>
                                <?php echo e($element); ?>

                            </button>
                        <?php endif; ?>

                        
                        <?php if(is_array($element)): ?>
                            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page == $paginator->currentPage()): ?>
                                    <button class="btn btn-primary btn-sm active" aria-current="page">
                                        <?php echo e($page); ?>

                                    </button>
                                <?php else: ?>
                                    <a href="<?php echo e($url); ?>" class="btn btn-outline-primary btn-sm">
                                        <?php echo e($page); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                
                <?php if($paginator->hasMorePages()): ?>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>" 
                       class="btn btn-outline-primary btn-sm ms-2" 
                       rel="next">
                        ถัดไป<i class="fas fa-chevron-right ms-1"></i>
                    </a>
                <?php else: ?>
                    <button class="btn btn-outline-secondary btn-sm ms-2" disabled>
                        ถัดไป<i class="fas fa-chevron-right ms-1"></i>
                    </button>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="d-flex d-sm-none justify-content-center mt-3">
            <div class="btn-group" role="group">
                <?php if($paginator->onFirstPage()): ?>
                    <button class="btn btn-outline-secondary btn-sm" disabled>
                        <i class="fas fa-chevron-left"></i>
                    </button>
                <?php else: ?>
                    <a href="<?php echo e($paginator->previousPageUrl()); ?>" 
                       class="btn btn-outline-primary btn-sm" 
                       rel="prev">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                <?php endif; ?>

                <span class="btn btn-outline-info btn-sm disabled">
                    หน้า <?php echo e($paginator->currentPage()); ?> จาก <?php echo e($paginator->lastPage()); ?>

                </span>

                <?php if($paginator->hasMorePages()): ?>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>" 
                       class="btn btn-outline-primary btn-sm" 
                       rel="next">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                <?php else: ?>
                    <button class="btn btn-outline-secondary btn-sm" disabled>
                        <i class="fas fa-chevron-right"></i>
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </nav>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/vendor/pagination/bootstrap-5.blade.php ENDPATH**/ ?>