<?php

// ไฟล์ทดสอบการแสดง accordion buttons สำหรับ Grand Child questions

require_once 'vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as Capsule;

// ตั้งค่าการเชื่อมต่อฐานข้อมูล
$capsule = new Capsule;

$capsule->addConnection([
    'driver'    => 'mysql',
    'host'      => '127.0.0.1',
    'port'      => '3307',
    'database'  => 'sas_log',
    'username'  => 'root',
    'password'  => '',
    'charset'   => 'utf8',
    'collation' => 'utf8_unicode_ci',
    'prefix'    => '',
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

echo "<h1>ทดสอบการแสดง Accordion Buttons สำหรับ Grand Child Questions</h1>";
echo "<style>
    .accordion-button { background-color: #fff3cd; }
    .grandchild-accordion { background-color: #d1ecf1; }
    .question-info { margin: 10px 0; padding: 10px; border: 1px solid #ddd; }
</style>";

try {
    // ดึงข้อมูลคำถามทั้งหมด
    $questions = Capsule::table('sas_questions')
        ->leftJoin('question_groups', 'sas_questions.question_group_id', '=', 'question_groups.id')
        ->leftJoin('sas_questions as parent', 'sas_questions.parent_id', '=', 'parent.id')
        ->leftJoin('sas_questions as grandparent', 'parent.parent_id', '=', 'grandparent.id')
        ->select([
            'sas_questions.id',
            'sas_questions.question_text',
            'sas_questions.question_type',
            'sas_questions.use_in_evaluation',
            'sas_questions.parent_id',
            'sas_questions.sort_order',
            'question_groups.name as group_name',
            'parent.question_text as parent_question',
            'parent.id as parent_id',
            'grandparent.question_text as grandparent_question',
            'grandparent.id as grandparent_id'
        ])
        ->orderBy('sas_questions.sort_order')
        ->get();

    // หา Parent Questions (ระดับที่ 1) ที่มี accordion buttons
    $parentQuestions = $questions->where('parent_id', null)->where('use_in_evaluation', false)->where('question_type', null);
    
    echo "<h2>Parent Questions ที่มี Accordion Buttons:</h2>";
    foreach ($parentQuestions as $parent) {
        echo "<div class='question-info'>";
        echo "<strong>Parent ID: {$parent->id}</strong><br>";
        echo "ข้อความ: {$parent->question_text}<br>";
        echo "Group: {$parent->group_name}<br>";
        
        // หา Child Questions ของ Parent นี้
        $childQuestions = $questions->where('parent_id', $parent->id);
        echo "<strong>Child Questions:</strong><br>";
        foreach ($childQuestions as $child) {
            echo "- ID: {$child->id} | {$child->question_text} | Type: " . ($child->question_type ?: 'null') . " | Use in Evaluation: " . ($child->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
            
            // หา Grand Child Questions ของ Child นี้
            $grandchildQuestions = $questions->where('parent_id', $child->id);
            foreach ($grandchildQuestions as $grandchild) {
                echo "  -- Grand Child ID: {$grandchild->id} | {$grandchild->question_text} | Type: " . ($grandchild->question_type ?: 'null') . " | Use in Evaluation: " . ($grandchild->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
            }
        }
        echo "</div>";
    }
    
    // ตรวจสอบคำถาม ID 36 และ 45 โดยเฉพาะ
    echo "<h2>ตรวจสอบคำถาม ID 36 และ 45:</h2>";
    $question36 = $questions->where('id', 36)->first();
    $question45 = $questions->where('id', 45)->first();
    
    if ($question36) {
        echo "<div class='question-info'>";
        echo "<strong>คำถาม ID 36:</strong><br>";
        echo "ข้อความ: {$question36->question_text}<br>";
        echo "Parent: {$question36->parent_text}<br>";
        echo "Grandparent: {$question36->grandparent_text}<br>";
        echo "Type: " . ($question36->question_type ?: 'null') . "<br>";
        echo "Use in Evaluation: " . ($question36->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
        echo "</div>";
    }
    
    if ($question45) {
        echo "<div class='question-info'>";
        echo "<strong>คำถาม ID 45:</strong><br>";
        echo "ข้อความ: {$question45->question_text}<br>";
        echo "Parent: {$question45->parent_text}<br>";
        echo "Grandparent: {$question45->grandparent_text}<br>";
        echo "Type: " . ($question45->question_type ?: 'null') . "<br>";
        echo "Use in Evaluation: " . ($question45->use_in_evaluation ? 'ใช่' : 'ไม่ใช่') . "<br>";
        echo "</div>";
    }
    
    // ทดสอบการจำลองการแสดงผล accordion buttons
    echo "<h2>การจำลองการแสดงผล Accordion Buttons:</h2>";
    foreach ($parentQuestions as $parent) {
        echo "<div class='accordion-button'>";
        echo "<strong>Parent Accordion: {$parent->question_text}</strong><br>";
        
        $childQuestions = $questions->where('parent_id', $parent->id);
        foreach ($childQuestions as $child) {
            if (!$child->use_in_evaluation && $child->question_type === null) {
                echo "<div class='grandchild-accordion'>";
                echo "  <strong>Grand Child Accordion: {$child->question_text}</strong><br>";
                
                $grandchildQuestions = $questions->where('parent_id', $child->id);
                foreach ($grandchildQuestions as $grandchild) {
                    if ($grandchild->use_in_evaluation && $grandchild->question_type !== null) {
                        echo "    - Evaluation Question: {$grandchild->question_text}<br>";
                    }
                }
                echo "</div>";
            }
        }
        echo "</div>";
    }

} catch (Exception $e) {
    echo "<p>เกิดข้อผิดพลาด: " . $e->getMessage() . "</p>";
}

?> 