<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgencyCustomer extends Model
{
    protected $table = 'agency_customer';
    protected $primaryKey = 'Agency_Customer_ID';
    
    protected $fillable = [
        'Customer_ID',
        'Agency_ID'
    ];

    public $timestamps = false;

    /**
     * Get the customer that owns the relationship
     */
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'Customer_ID', 'Customer_ID');
    }

    /**
     * Get the agency that owns the relationship
     */
    public function agency()
    {
        return $this->belongsTo(Agency::class, 'Agency_ID', 'Agency_ID');
    }
}
