<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Assessment extends Model
{
    use HasFactory;

    protected $table = 'assessments';

    protected $fillable = [
        'product_id',
        'question_group_id',

        // ใช้ Customer_ID แทน user_id
        'Customer_ID',

        'status',
        'started_at',
        'submitted_at',

        'CusIns_ID',
        'CusUdp_ID',
        'DtmIns',
        'DtmUpd',
    ];

    // ใช้คอลัมน์เวลาแบบกำหนดเอง
    const CREATED_AT = 'DtmIns';
    const UPDATED_AT = 'DtmUpd';

    /** ความสัมพันธ์กับ Product */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /** ความสัมพันธ์กับ QuestionGroup */
    public function questionGroup()
    {
        return $this->belongsTo(QuestionGroup::class);
    }

    /** ความสัมพันธ์กับ Answer */
    public function answers()
    {
        return $this->hasMany(Answer::class);
    }

    /**
     * ความสัมพันธ์กับผู้สร้างแบบประเมิน
     * (คงชื่อเมธอดว่า user() ไว้ เพื่อไม่ต้องแก้ view/controller อื่น ๆ)
     */
    public function user()
    {
        return $this->belongsTo(Customer::class, 'Customer_ID', 'Customer_ID');
    }
}
