<?php

return [

    'name' => env('APP_NAME', 'Laravel'),

    'env' => env('APP_ENV', 'production'),

    'debug' => (bool) env('APP_DEBUG', false),

    'url' => env('APP_URL', 'http://localhost'),

    'timezone' => env('APP_TIMEZONE', 'UTC'),

    'locale' => env('APP_LOCALE', 'en'),

    'fallback_locale' => env('APP_FALLBACK_LOCALE', 'en'),

    'faker_locale' => env('APP_FAKER_LOCALE', 'en_US'),

    'cipher' => 'AES-256-CBC',

    'key' => env('APP_KEY'),

    'previous_keys' => [
        ...array_filter(
            explode(',', env('APP_PREVIOUS_KEYS', ''))
        ),
    ],

    'maintenance' => [
        'driver' => env('APP_MAINTENANCE_DRIVER', 'file'),
        'store' => env('APP_MAINTENANCE_STORE', 'database'),
    ],

    /*
    |--------------------------------------------------------------------------
    | SSO Secret สำหรับเชื่อม ServTrack → SASLOG
    |--------------------------------------------------------------------------
    |
    | ใช้สำหรับตรวจสอบลายเซ็น payload จาก goto_saslog.php
    | กำหนดค่าในไฟล์ .env เช่น
    |   SSO_SECRET=ksu3H6kQ3cRkWc8G5g1wXv1nA2y9rU6pZb7qJ4mTt2pE0cD5uL
    |
    */
    'sso_secret_saslog' => env('SSO_SECRET', null),

];
