<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // เพิ่ม comment ให้คอลัมภ์ที่ไม่มี Foreign Key ก่อน
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT COMMENT 'รหัสคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_text TEXT COMMENT 'ข้อความคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_type ENUM('yes_no','multiple_choice','text') COMMENT 'ประเภทคำถาม (yes_no=ใช่/ไม่ใช่, multiple_choice=เลือกตอบ, text=ข้อความ)'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN choices LONGTEXT COMMENT 'ตัวเลือกคำตอบ (สำหรับคำถามประเภท multiple_choice)'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN description TEXT COMMENT 'รายละเอียดคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN use_in_evaluation TINYINT(1) DEFAULT 1 COMMENT 'ใช้ในการประเมินหรือไม่ (1=ใช้, 0=ไม่ใช้)'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN logic_operator ENUM('AND','OR') COMMENT 'ตัวดำเนินการตรรกะ (AND=และ, OR=หรือ)'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN keyword_tag VARCHAR(255) COMMENT 'แท็กคำสำคัญสำหรับคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN sort_order INT DEFAULT 0 COMMENT 'ลำดับการแสดงผลของคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'วันที่และเวลาที่แก้ไขข้อมูล'");

        // จัดการคอลัมภ์ที่มี Foreign Key Constraint
        // ลบ Foreign Key ก่อน (ใช้ชื่อที่ถูกต้อง)
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY sas_questions_question_group_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY sas_questions_parent_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY questions_cusins_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY questions_cusudp_id_foreign");
        
        // เพิ่ม comment ให้คอลัมภ์ที่มี Foreign Key
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_group_id BIGINT UNSIGNED COMMENT 'รหัสกลุ่มคำถาม'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN parent_id BIGINT UNSIGNED COMMENT 'รหัสคำถามแม่ (สำหรับคำถามย่อย)'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN CusIns_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่สร้างข้อมูล'");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN CusUdp_ID INT UNSIGNED COMMENT 'รหัสลูกค้าที่แก้ไขข้อมูล'");
        
        // เพิ่ม Foreign Key กลับมา (ใช้ชื่อและกฎเดิม)
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT sas_questions_question_group_id_foreign FOREIGN KEY (question_group_id) REFERENCES question_groups(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT sas_questions_parent_id_foreign FOREIGN KEY (parent_id) REFERENCES sas_questions(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT questions_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT questions_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // ลบ Foreign Key ก่อน (ใช้ชื่อที่ถูกต้อง)
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY sas_questions_question_group_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY sas_questions_parent_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY questions_cusins_id_foreign");
        DB::statement("ALTER TABLE sas_questions DROP FOREIGN KEY questions_cusudp_id_foreign");
        
        // ลบ comment โดยไม่ระบุ comment
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN id BIGINT UNSIGNED AUTO_INCREMENT");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_group_id BIGINT UNSIGNED");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN parent_id BIGINT UNSIGNED");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_text TEXT");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN question_type ENUM('yes_no','multiple_choice','text')");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN choices LONGTEXT");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN description TEXT");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN use_in_evaluation TINYINT(1) DEFAULT 1");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN logic_operator ENUM('AND','OR')");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN keyword_tag VARCHAR(255)");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN sort_order INT DEFAULT 0");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN DtmIns TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN DtmUpd TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN CusIns_ID INT UNSIGNED");
        DB::statement("ALTER TABLE sas_questions MODIFY COLUMN CusUdp_ID INT UNSIGNED");
        
        // เพิ่ม Foreign Key กลับมา (ใช้ชื่อและกฎเดิม)
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT sas_questions_question_group_id_foreign FOREIGN KEY (question_group_id) REFERENCES question_groups(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT sas_questions_parent_id_foreign FOREIGN KEY (parent_id) REFERENCES sas_questions(id) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT questions_cusins_id_foreign FOREIGN KEY (CusIns_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
        DB::statement("ALTER TABLE sas_questions ADD CONSTRAINT questions_cusudp_id_foreign FOREIGN KEY (CusUdp_ID) REFERENCES customer(Customer_ID) ON DELETE CASCADE");
    }
};
