<?php $__env->startSection('content'); ?>
<div class="container mt-4">
  <div class="row justify-content-center">
    <div class="col-md-8">
      <!-- Progress Bar -->
      <div class="card shadow mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">
              <i class="fas fa-tasks me-2"></i>
              <?php if(!isset($validated)): ?>
              ความคืบหน้าการกรอกข้อมูลผลิตภัณฑ์
              <?php else: ?>
              ความคืบหน้าการประเมินคู่มือ
              <?php endif; ?>
            </h6>
            <span id="progress-text" class="badge bg-primary">0/5</span>
          </div>
          <div class="progress" style="height: 10px;">
            <div id="progress-bar" class="progress-bar bg-primary" role="progressbar" style="width: 0%"></div>
          </div>
          <div id="progress-status" class="text-muted small mt-2">
            <?php if(!isset($validated)): ?>
            กรุณากรอกข้อมูลผลิตภัณฑ์ให้ครบถ้วน
            <?php else: ?>
            กรุณาตอบคำถามการประเมินให้ครบถ้วน
            <?php endif; ?>
          </div>
        </div>
      </div>

      <?php if(!isset($validated)): ?>
      <!-- ฟอร์มเพิ่มผลิตภัณฑ์ -->
      <div class="card shadow">
        <div class="card-header bg-primary text-white">
          <h4 class="mb-0">
            <i class="fas fa-plus me-2"></i>
            <?php echo e(__('เพิ่มผลิตภัณฑ์')); ?>

          </h4>
        </div>

        <div class="card-body p-4">
          <form method="POST" action="<?php echo e(route('products.store')); ?>" enctype="multipart/form-data" id="product-form">
            <?php echo csrf_field(); ?>

            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-box me-1"></i>
                    <?php echo e(__('ชื่อผลิตภัณฑ์')); ?>

                    <span class="text-danger">*</span>
                  </label>
                  <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-field"
                    name="name" required value="<?php echo e(old('name')); ?>"
                    placeholder="<?php echo e(__('กรอกชื่อผลิตภัณฑ์')); ?>" data-field="name">
                  <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    <?php echo e($message); ?>

                  </div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>

              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-tag me-1"></i>
                    <?php echo e(__('รุ่น')); ?>

                    <span class="text-danger">*</span>
                  </label>
                  <input type="text" class="form-control <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-field"
                    name="model" value="<?php echo e(old('model')); ?>"
                    placeholder="<?php echo e(__('กรอกรุ่นผลิตภัณฑ์')); ?>" data-field="model">
                  <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    <?php echo e($message); ?>

                  </div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-network-wired me-1"></i>
                    <?php echo e(__('วิธีรับข้อมูล')); ?>

                    <span class="text-danger">*</span>
                  </label>
                  <select name="log_receive_method" class="form-select <?php $__errorArgs = ['log_receive_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-field" required data-field="log_receive_method">
                    <option value=""><?php echo e(__('--เลือกวิธีรับข้อมูล--')); ?></option>
                    <option value="syslog_udp" <?php echo e(old('log_receive_method') == 'syslog_udp' ? 'selected' : ''); ?>>syslog UDP</option>
                    <option value="syslog_tcp" <?php echo e(old('log_receive_method') == 'syslog_tcp' ? 'selected' : ''); ?>>syslog TCP</option>
                    <option value="syslog_both" <?php echo e(old('log_receive_method') == 'syslog_both' ? 'selected' : ''); ?>>syslog UDP และ syslog TCP</option>
                    <option value="other" <?php echo e(old('log_receive_method') == 'other' ? 'selected' : ''); ?>><?php echo e(__('อื่นๆ')); ?></option>
                  </select>
                  <?php $__errorArgs = ['log_receive_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    <?php echo e($message); ?>

                  </div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>

              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">
                    <i class="fas fa-server me-1"></i>
                    <?php echo e(__('ประเภทผลิตภัณฑ์')); ?>

                    <span class="text-danger">*</span>
                  </label>
                  <select name="product_type" class="form-select <?php $__errorArgs = ['product_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-field" required data-field="product_type">
                    <option value=""><?php echo e(__('--เลือกประเภทผลิตภัณฑ์--')); ?></option>
                    <option value="hw_sw_log_server" <?php echo e(old('product_type') == 'hw_sw_log_server' ? 'selected' : ''); ?>><?php echo e(__('Hardware + Software Log Server')); ?></option>
                    <option value="sw_log_server" <?php echo e(old('product_type') == 'sw_log_server' ? 'selected' : ''); ?>><?php echo e(__('Software Log Server')); ?></option>
                  </select>
                  <?php $__errorArgs = ['product_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="invalid-feedback">
                    <i class="fas fa-exclamation-circle me-1"></i>
                    <?php echo e($message); ?>

                  </div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label">
                <i class="fas fa-image me-1"></i>
                <?php echo e(__('รูปภาพผลิตภัณฑ์')); ?>

                <span class="text-danger">*</span>
              </label>
              <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-field"
                name="image" accept="image/*" data-field="image">
              <div class="form-text"><?php echo e(__('รองรับไฟล์: JPEG, PNG, JPG, GIF, SVG ขนาดไม่เกิน 2MB')); ?></div>
              <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <div class="invalid-feedback">
                <i class="fas fa-exclamation-circle me-1"></i>
                <?php echo e($message); ?>

              </div>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
              <label class="form-label">
                <i class="fas fa-align-left me-1"></i>
                <?php echo e(__('คำอธิบาย')); ?>

                <span class="text-muted">(ไม่บังคับ)</span>
              </label>
              <textarea name="description" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                rows="4" placeholder="<?php echo e(__('กรอกคำอธิบายผลิตภัณฑ์ (ไม่บังคับ)')); ?>"><?php echo e(old('description')); ?></textarea>
              <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <div class="invalid-feedback">
                <i class="fas fa-exclamation-circle me-1"></i>
                <?php echo e($message); ?>

              </div>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="d-flex justify-content-end gap-2">
              <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-times me-1"></i>
                <?php echo e(__('ยกเลิก')); ?>

              </a>
              <button type="submit" class="btn btn-primary" id="submit-btn">
                <i class="fas fa-arrow-right me-1"></i>
                <?php echo e(__('ถัดไป')); ?>

              </button>
            </div>
          </form>
        </div>
      </div>

      <?php else: ?>
      <!-- ฟอร์มประเมินคู่มือ -->
      <div class="card shadow">
        <div class="card-header bg-success text-white">
          <h4 class="mb-0">
            <i class="fas fa-clipboard-check me-2"></i>
            <?php echo e(__('แบบประเมินคู่มือ')); ?>

          </h4>
        </div>

        <div class="card-body p-4 pb-0">
          <!-- แสดงข้อมูลผลิตภัณฑ์ที่กรอกไว้ -->
          <div class="alert alert-info border-0 shadow-sm mb-4">
            <div class="d-flex align-items-center">
              <i class="fas fa-info-circle fa-2x me-3 text-info"></i>
              <div>
                <h6 class="alert-heading mb-1">ข้อมูลผลิตภัณฑ์ที่กรอกไว้</h6>
                <p class="mb-1"><strong>ชื่อ:</strong> <?php echo e($validated['name']); ?></p>
                <p class="mb-1"><strong>รุ่น:</strong> <?php echo e($validated['model'] ?? 'ไม่ระบุ'); ?></p>
                <p class="mb-0"><strong>ประเภท:</strong> <?php echo e($validated['product_type'] == 'hw_sw_log_server' ? 'Hardware + Software Log Server' : 'Software Log Server'); ?></p>
              </div>
            </div>
          </div>
          
          <?php if(isset($assessment) && $assessment->status === 'draft'): ?>
          <!-- แสดงสถานะฉบับร่าง -->
          <div class="alert alert-warning border-0 shadow-sm mb-4">
            <div class="d-flex align-items-center">
              <i class="fas fa-edit fa-2x me-3 text-warning"></i>
              <div>
                <h6 class="alert-heading mb-1">ฉบับร่าง - ทำต่อจากที่ค้างไว้</h6>
                <p class="mb-1"><strong>วันที่เริ่ม:</strong> 
                  <?php if($assessment->DtmIns): ?>
                    <?php echo e($assessment->DtmIns->format('d/m/Y H:i')); ?>

                  <?php else: ?>
                    ไม่ระบุ
                  <?php endif; ?>
                </p>
                <p class="mb-0"><strong>อัปเดตล่าสุด:</strong> 
                  <?php if($assessment->DtmUpd): ?>
                    <?php echo e($assessment->DtmUpd->format('d/m/Y H:i')); ?>

                  <?php else: ?>
                    <?php echo e($assessment->DtmIns->format('d/m/Y H:i')); ?>

                  <?php endif; ?>
                </p>
              </div>
            </div>
          </div>
          <?php endif; ?>
        </div>

        <!-- คำแนะนำ -->
        <div class="alert alert-info border-0 shadow-sm m-3 mt-0">
          <div class="d-flex align-items-center">
            <i class="fas fa-info-circle fa-2x me-3 text-info"></i>
            <div>
              <h6 class="alert-heading mb-1">คำแนะนำในการประเมิน</h6>
              <p class="mb-0 small">กรุณาอ่านคำถามอย่างละเอียดและตอบตามความจริง เพื่อให้ได้ผลการประเมินที่แม่นยำ</p>
            </div>
          </div>
        </div>

        <form method="POST" action="<?php echo e(route('assessments.submit-draft')); ?>" id="assessment-form">
          <?php echo csrf_field(); ?>
          <?php if(isset($assessment) && $assessment->product_id): ?>
          <input type="hidden" name="product_id" value="<?php echo e($assessment->product_id); ?>">
          <?php endif; ?>
          
          <?php if(strtolower(Auth::user()->Level) === 'consult' && isset($selectedAgencyId)): ?>
          <input type="hidden" name="selected_agency_id" value="<?php echo e($selectedAgencyId); ?>">
          <?php endif; ?>

          <!-- แสดงคำถามโดยตรง -->
          <div class="m-3">
            <?php
              $globalQuestionNumber = 1;
            ?>
            <?php $__currentLoopData = $questionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupIndex => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-4">
                  <div class="row">
                    <?php
                        $allQuestions = \App\Models\Question::all();
                        $groupQuestions = $allQuestions->where('question_group_id', $group->id);
                    ?>
                    <?php $__currentLoopData = $groupQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $questionIndex => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($question->use_in_evaluation && !$question->parent_id && $question->question_type !== null): ?>
                    <!-- คำถามปกติที่ใช้ในการประเมิน (ไม่มี parent และ question_type ไม่เป็น null) -->
                    <div class="col-12 mb-4">
                      <div class="card border-0 shadow-sm">
                        <div class="card-body p-4">
                          <div class="d-flex align-items-start mb-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; min-width: 40px;">
                          <span class="question-number"><?php echo e($globalQuestionNumber); ?></span>
                            </div>
                            <div class="flex-grow-1">
                              <h6 class="card-title mb-2 question-label"><?php echo e($question->question_text); ?></h6>
                              <!-- ฟอร์มตอบคำถาม -->
                              <?php if($question->question_type == 'yes_no'): ?>
                                <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                <div class="mb-3">
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio" 
                                           name="answers[<?php echo e($question->id); ?>][choice]" 
                                           id="yes_<?php echo e($question->id); ?>" 
                                           value="yes" 
                                           data-question-id="<?php echo e($question->id); ?>"
                                           <?php if(isset($existingAnswers[$question->id]['choice']) && $existingAnswers[$question->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                    <label class="form-check-label" for="yes_<?php echo e($question->id); ?>">
                                      ใช่
                                    </label>
                                  </div>
                                  <div class="form-check form-check-inline">
                                    <input class="form-check-input yes-no-radio" type="radio" 
                                           name="answers[<?php echo e($question->id); ?>][choice]" 
                                           id="no_<?php echo e($question->id); ?>" 
                                           value="no" 
                                           data-question-id="<?php echo e($question->id); ?>"
                                           <?php if(isset($existingAnswers[$question->id]['choice']) && $existingAnswers[$question->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                    <label class="form-check-label" for="no_<?php echo e($question->id); ?>">
                                      ไม่ใช่
                                    </label>
                                  </div>
                                </div>
                                <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                <div id="text_field_<?php echo e($question->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$question->id]['choice']) && $existingAnswers[$question->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                  <label class="form-label text-muted">
                                    <i class="fas fa-comment me-1"></i>
                                    กรุณาระบุรายละเอียดเพิ่มเติม:
                                  </label>
                                  <textarea
                                    name="answers[<?php echo e($question->id); ?>][details]"
                                    class="form-control border-0 bg-light evaluation-field"
                                    rows="3"
                                    placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                    style="resize: none;"
                                    data-field="evaluation_<?php echo e($question->id); ?>_details"><?php echo e($existingAnswers[$question->id]['details'] ?? ''); ?></textarea>
                                </div>
                          <?php elseif($question->question_type == 'multiple_choice'): ?>
                            <!-- สำหรับคำถามแบบตัวเลือก -->
                            <div class="mb-3">
                            <?php
                                $choices = $question->choices;
                                if (is_string($choices)) {
                                    $choices = json_decode($choices, true);
                                }
                            ?>
                            <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check">
                                        <input class="form-check-input multiple-choice-radio" type="radio"
                                            name="answers[<?php echo e($question->id); ?>][choice]"
                                            id="choice_<?php echo e($question->id); ?>_<?php echo e($choiceIndex); ?>"
                                            value="<?php echo e($choice); ?>"
                                            data-question-id="<?php echo e($question->id); ?>">
                                        <label class="form-check-label" for="choice_<?php echo e($question->id); ?>_<?php echo e($choiceIndex); ?>">
                                            <?php echo e($choice); ?>

                                        </label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                <div class="alert alert-warning border-0">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                    <?php if(config('app.debug')): ?>
                                        <br><small class="text-muted">Debug: choices = <?php echo e(json_encode($question->choices)); ?></small>
                              <?php endif; ?>
                            </div>
                                <?php endif; ?>
                          </div>
                          <?php elseif($question->question_type == 'text'): ?>
                            <!-- สำหรับคำถามแบบข้อความ -->
                            <div class="mb-3">
                                <textarea
                                    name="answers[<?php echo e($question->id); ?>][text]"
                                    class="form-control border-0 bg-light evaluation-field"
                                    rows="3"
                                    placeholder="กรุณาตอบคำถาม..."
                                    style="resize: none;"
                                    data-field="evaluation_<?php echo e($question->id); ?>_text"></textarea>
                        </div>
                          <?php endif; ?>
                      </div>
                    </div>
                    </div>
                  </div>
                </div>
                <?php $globalQuestionNumber++; ?>
                <?php elseif($question->question_type === null && !$question->parent_id): ?>
                <!-- Parent Question (ระดับ 1) - แสดงเป็น accordion button เสมอ -->
                    <div class="col-12 mb-3">
                      <div class="accordion-item border-0">
                        <h2 class="accordion-header" id="heading-parent-<?php echo e($question->id); ?>">
                          <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-parent-<?php echo e($question->id); ?>" style="padding: 1.5rem;">
                            <div class="d-flex align-items-center w-100">
                              <div class="flex-grow-1">
                            <h6 class="mb-1 question-label"><?php echo e($question->question_text); ?></h6>
                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                              </div>
                              <i class="fas fa-chevron-down ms-auto"></i>
                            </div>
                          </button>
                        </h2>
                        <div id="collapse-parent-<?php echo e($question->id); ?>" class="accordion-collapse collapse" aria-labelledby="heading-parent-<?php echo e($question->id); ?>">
                          <div class="accordion-body bg-white p-4">
                            <div class="row">
                              <?php $__currentLoopData = $group->questions->where('parent_id', $question->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childIndex => $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php if($child->use_in_evaluation && $child->question_type !== null): ?>
                              <!-- Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                              <div class="col-12 mb-4">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body p-4">
                                        <div class="ms-4 border-start border-primary ps-3">
                                            <div class="d-flex align-items-start mb-3">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-2 text-dark"><?php echo e($child->question_text); ?></h6>
                                                    <!-- ฟอร์มตอบคำถาม -->
                                                    <?php if($child->question_type == 'yes_no'): ?>
                                                        <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                        <div class="mb-3">
                                                            <div class="form-check form-check-inline">
                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                    name="answers[<?php echo e($child->id); ?>][choice]"
                                                                    id="yes_<?php echo e($child->id); ?>"
                                                                    value="yes"
                                                                    data-question-id="<?php echo e($child->id); ?>"
                                                                    <?php if(isset($existingAnswers[$child->id]['choice']) && $existingAnswers[$child->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                                                <label class="form-check-label" for="yes_<?php echo e($child->id); ?>">
                                                                    ใช่
                                                                </label>
                                                            </div>
                                                            <div class="form-check form-check-inline">
                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                    name="answers[<?php echo e($child->id); ?>][choice]"
                                                                    id="no_<?php echo e($child->id); ?>"
                                                                    value="no"
                                                                    data-question-id="<?php echo e($child->id); ?>"
                                                                    <?php if(isset($existingAnswers[$child->id]['choice']) && $existingAnswers[$child->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                                                <label class="form-check-label" for="no_<?php echo e($child->id); ?>">
                                                                    ไม่ใช่
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                        <div id="text_field_<?php echo e($child->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$child->id]['choice']) && $existingAnswers[$child->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                                            <label class="form-label text-muted">
                                                                <i class="fas fa-comment me-1"></i>
                                                                กรุณาระบุรายละเอียดเพิ่มเติม:
                                                            </label>
                                                            <textarea
                                                                name="answers[<?php echo e($child->id); ?>][details]"
                                                                class="form-control border-0 bg-light evaluation-field"
                                                                rows="3"
                                                                placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                style="resize: none;"
                                                                data-field="evaluation_<?php echo e($child->id); ?>_details"><?php echo e($existingAnswers[$child->id]['details'] ?? ''); ?></textarea>
                                                        </div>
                                                    <?php elseif($child->question_type == 'multiple_choice'): ?>
                                                        <!-- สำหรับคำถามแบบตัวเลือก -->
                                                        <div class="mb-3">
                                                        <?php
                                                            $choices = $child->choices;
                                                            if (is_string($choices)) {
                                                                $choices = json_decode($choices, true);
                                                            }
                                                        ?>
                                                        <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                            <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="form-check">
                                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                                        name="answers[<?php echo e($child->id); ?>][choice]"
                                                                        id="choice_<?php echo e($child->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                        value="<?php echo e($choice); ?>"
                                                                        data-question-id="<?php echo e($child->id); ?>"
                                                                        <?php if(isset($existingAnswers[$child->id]['choice']) && $existingAnswers[$child->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                    <label class="form-check-label" for="choice_<?php echo e($child->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                        <?php echo e($choice); ?>

                                                                    </label>
                                                                </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                            <div class="alert alert-warning border-0">
                                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                                ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                <?php if(config('app.debug')): ?>
                                                                    <br><small class="text-muted">Debug: choices = <?php echo e(json_encode($child->choices)); ?></small>
                                                                <?php endif; ?>
                                                            </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php elseif($child->question_type == 'text'): ?>
                                                        <!-- สำหรับคำถามแบบข้อความ -->
                                                        <div class="mb-3">
                                                            <textarea
                                                                name="answers[<?php echo e($child->id); ?>][text]"
                                                                class="form-control border-0 bg-light evaluation-field"
                                                                rows="3"
                                                                placeholder="กรุณาตอบคำถาม..."
                                                                style="resize: none;"
                                                                data-field="evaluation_<?php echo e($child->id); ?>_text"><?php echo e($existingAnswers[$child->id]['text'] ?? ''); ?></textarea>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                              </div>
                              <?php $globalQuestionNumber++; ?>
                              <?php elseif(!$child->use_in_evaluation && $child->question_type !== null): ?>
                              <!-- Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null (เช่น multiple_choice) -->
                                        <div class="col-12 mb-4">
                                          <div class="card border-0 shadow-sm">
                                              <div class="card-body p-4">
                                        <div class="ms-4 border-start border-secondary ps-3">
                                                      <div class="d-flex align-items-start mb-3">
                                                          <div class="flex-grow-1">
                                                    <h6 class="card-title mb-2 text-dark"><?php echo e($child->question_text); ?></h6>
                                                              <!-- ฟอร์มตอบคำถาม -->
                                                    <?php if($child->question_type == 'multiple_choice'): ?>
                                                                  <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                  <div class="mb-3">
                                                                  <?php
                                                            $choices = $child->choices;
                                                                      if (is_string($choices)) {
                                                                          $choices = json_decode($choices, true);
                                                                      }
                                                                  ?>
                                                                  <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                      <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                          <div class="form-check">
                                                                    <input class="form-check-input" type="radio"
                                                                        name="answers[<?php echo e($child->id); ?>][choice]"
                                                                        id="choice_<?php echo e($child->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                        value="<?php echo e($choice); ?>"
                                                                        data-question-id="<?php echo e($child->id); ?>"
                                                                        <?php if(isset($existingAnswers[$child->id]['choice']) && $existingAnswers[$child->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                    <label class="form-check-label" for="choice_<?php echo e($child->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                  <?php echo e($choice); ?>

                                                                              </label>
                                                                          </div>
                                                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                  <?php else: ?>
                                                                      <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                      <div class="alert alert-warning border-0">
                                                                          <i class="fas fa-exclamation-triangle me-2"></i>
                                                                          ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                          <?php if(config('app.debug')): ?>
                                                                    <br><small class="text-muted">Debug: choices = <?php echo e(json_encode($child->choices)); ?></small>
                                                                          <?php endif; ?>
                                                                      </div>
                                                                      <?php endif; ?>
                                                                  </div>
                                                    <?php elseif($child->question_type == 'text'): ?>
                                                                  <!-- สำหรับคำถามแบบข้อความ -->
                                                                  <div class="mb-3">
                                                                      <textarea
                                                                name="answers[<?php echo e($child->id); ?>][text]"
                                                                class="form-control border-0 bg-light"
                                                                          rows="3"
                                                                          placeholder="กรุณาตอบคำถาม..."
                                                                style="resize: none;"
                                                                data-field="evaluation_<?php echo e($child->id); ?>_text"><?php echo e($existingAnswers[$child->id]['text'] ?? ''); ?></textarea>
                                                                  </div>
                                                              <?php endif; ?>
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                        </div>
                              <?php elseif( $child->question_type === null): ?>
                              <!-- Child Questions ที่ไม่ใช้ในการประเมินและ question_type เป็น null - แสดงเป็น accordion button -->
                                    <div class="col-12 mb-3">
                                      <div class="accordion-item border-0">
                                  <h2 class="accordion-header" id="heading-child-<?php echo e($child->id); ?>">
                                    <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-child-<?php echo e($child->id); ?>" style="padding: 1.25rem;">
                                            <div class="d-flex align-items-center w-100">
                                              <div class="flex-grow-1">
                                          <h6 class="mb-1 question-label"><?php echo e($child->question_text); ?></h6>
                                                <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                                              </div>
                                              <i class="fas fa-chevron-down ms-auto"></i>
                                            </div>
                                          </button>
                                        </h2>
                                  <div id="collapse-child-<?php echo e($child->id); ?>" class="accordion-collapse collapse" aria-labelledby="heading-child-<?php echo e($child->id); ?>">
                                          <div class="accordion-body bg-white p-4">
                                            <div class="row">
                                        <?php $__currentLoopData = $group->questions->where('parent_id', $child->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grandChildIndex => $grandChild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($grandChild->use_in_evaluation && $grandChild->question_type !== null): ?>
                                        <!-- Grand Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                                        <div class="col-12 mb-4">
                                                <div class="card border-0 shadow-sm">
                                              <div class="card-body p-4">
                                                        <div class="ms-4 border-start border-primary ps-3">
                                                      <div class="d-flex align-items-start mb-3">
                                                          <div class="flex-grow-1">
                                                              <h6 class="card-title mb-2 text-dark"><?php echo e($grandChild->question_text); ?></h6>
                                                              <!-- ฟอร์มตอบคำถาม -->
                                                              <?php if($grandChild->question_type == 'yes_no'): ?>
                                                                        <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                                        <div class="mb-3">
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                              name="answers[<?php echo e($grandChild->id); ?>][choice]"
                                                                              id="yes_<?php echo e($grandChild->id); ?>"
                                                                                    value="yes"
                                                                              data-question-id="<?php echo e($grandChild->id); ?>"
                                                                              <?php if(isset($existingAnswers[$grandChild->id]['choice']) && $existingAnswers[$grandChild->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                                                          <label class="form-check-label" for="yes_<?php echo e($grandChild->id); ?>">
                                                                                    ใช่
                                                                                </label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input yes-no-radio" type="radio"
                                                                              name="answers[<?php echo e($grandChild->id); ?>][choice]"
                                                                              id="no_<?php echo e($grandChild->id); ?>"
                                                                                    value="no"
                                                                              data-question-id="<?php echo e($grandChild->id); ?>"
                                                                              <?php if(isset($existingAnswers[$grandChild->id]['choice']) && $existingAnswers[$grandChild->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                                                          <label class="form-check-label" for="no_<?php echo e($grandChild->id); ?>">
                                                                                    ไม่ใช่
                                                                                </label>
                                                                            </div>
                                                                        </div>
                                                                        <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                                        <div id="text_field_<?php echo e($grandChild->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$grandChild->id]['choice']) && $existingAnswers[$grandChild->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                                                            <label class="form-label text-muted">
                                                                                <i class="fas fa-comment me-1"></i>
                                                                                กรุณาระบุรายละเอียดเพิ่มเติม:
                                                                            </label>
                                                                            <textarea
                                                                          name="answers[<?php echo e($grandChild->id); ?>][details]"
                                                                                class="form-control border-0 bg-light evaluation-field"
                                                                                rows="3"
                                                                                placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                                style="resize: none;"
                                                                          data-field="evaluation_<?php echo e($grandChild->id); ?>_details"><?php echo e($existingAnswers[$grandChild->id]['details'] ?? ''); ?></textarea>
                                                                        </div>
                                                              <?php elseif($grandChild->question_type == 'multiple_choice'): ?>
                                                                        <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                        <div class="mb-3">
                                                                            <?php
                                                                      $choices = $grandChild->choices;
                                                                                if (is_string($choices)) {
                                                                                    $choices = json_decode($choices, true);
                                                                                }
                                                                            ?>
                                                                            <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                                <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input multiple-choice-radio" type="radio"
                                                                                  name="answers[<?php echo e($grandChild->id); ?>][choice]"
                                                                                  id="choice_<?php echo e($grandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                        value="<?php echo e($choice); ?>"
                                                                                  data-question-id="<?php echo e($grandChild->id); ?>"
                                                                                  <?php if(isset($existingAnswers[$grandChild->id]['choice']) && $existingAnswers[$grandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                              <label class="form-check-label" for="choice_<?php echo e($grandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                        <?php echo e($choice); ?>

                                                                                    </label>
                                                                                </div>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                                <div class="alert alert-warning border-0">
                                                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                    <?php if(config('app.debug')): ?>
                                                                              <br><small class="text-muted">Debug: choices = <?php echo e(json_encode($grandChild->choices)); ?></small>
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                              <?php elseif($grandChild->question_type == 'text'): ?>
                                                                        <!-- สำหรับคำถามแบบข้อความ -->
                                                                        <div class="mb-3">
                                                                            <textarea
                                                                          name="answers[<?php echo e($grandChild->id); ?>][text]"
                                                                                class="form-control border-0 bg-light evaluation-field"
                                                                                rows="3"
                                                                                placeholder="กรุณาตอบคำถาม..."
                                                                                style="resize: none;"
                                                                          data-field="evaluation_<?php echo e($grandChild->id); ?>_text"><?php echo e($existingAnswers[$grandChild->id]['text'] ?? ''); ?></textarea>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                              </div>
                                        <?php $globalQuestionNumber++; ?>
                                    <?php elseif(!$grandChild->use_in_evaluation && $grandChild->question_type !== null): ?>
                                    <!-- Grand Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null -->
                                              <div class="col-12 mb-4">
                                                <div class="card border-0 shadow-sm">
                                                    <div class="card-body p-4">
                                              <div class="ms-4 border-start border-secondary ps-3">
                                                            <div class="d-flex align-items-start mb-3">
                                                                <div class="flex-grow-1">
                                                          <h6 class="card-title mb-2 text-dark"><?php echo e($grandChild->question_text); ?></h6>
                                                                    <!-- ฟอร์มตอบคำถาม -->
                                                          <?php if($grandChild->question_type == 'multiple_choice'): ?>
                                                                  <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                  <div class="mb-3">
                                                                            <?php
                                                                  $choices = $grandChild->choices;
                                                                                if (is_string($choices)) {
                                                                                    $choices = json_decode($choices, true);
                                                                                }
                                                                            ?>
                                                                            <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                                <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                          <div class="form-check">
                                                                              <input class="form-check-input" type="radio"
                                                                            name="answers[<?php echo e($grandChild->id); ?>][choice]"
                                                                            id="choice_<?php echo e($grandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                  value="<?php echo e($choice); ?>"
                                                                            data-question-id="<?php echo e($grandChild->id); ?>"
                                                                            <?php if(isset($existingAnswers[$grandChild->id]['choice']) && $existingAnswers[$grandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                        <label class="form-check-label" for="choice_<?php echo e($grandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                  <?php echo e($choice); ?>

                                                                              </label>
                                                                          </div>
                                                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                                <!-- แสดงข้อความเมื่อไม่มีตัวเลือก -->
                                                                                <div class="alert alert-warning border-0">
                                                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                    ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                    <?php if(config('app.debug')): ?>
                                                                          <br><small class="text-muted">Debug: choices = <?php echo e(json_encode($grandChild->choices)); ?></small>
                                                                      <?php endif; ?>
                                                                  </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                      <?php elseif($grandChild->question_type == 'text'): ?>
                                                                  <!-- สำหรับคำถามแบบข้อความ -->
                                                                  <div class="mb-3">
                                                                      <textarea
                                                                  name="answers[<?php echo e($grandChild->id); ?>][text]"
                                                                          class="form-control border-0 bg-light"
                                                                          rows="3"
                                                                          placeholder="กรุณาตอบคำถาม..."
                                                                          style="resize: none;"
                                                                          data-field="evaluation_<?php echo e($grandChild->id); ?>_text"><?php echo e($existingAnswers[$grandChild->id]['text'] ?? ''); ?></textarea>
                                                                  </div>
                                                              <?php endif; ?>
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                        </div>
                                        <?php elseif( $grandChild->question_type === null): ?>
                                        <!-- Grand Child Question (ระดับ 3) - แสดงเป็น accordion button -->
                                        <div class="col-12 mb-3">
                                          <div class="accordion-item border-0">
                                            <h2 class="accordion-header" id="heading-great-grandchild-<?php echo e($grandChild->id); ?>">
                                              <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-great-grandchild-<?php echo e($grandChild->id); ?>" style="padding: 1rem;">
                                                <div class="d-flex align-items-center w-100">
                                                  <div class="flex-grow-1">
                                                    <h6 class="mb-1 question-label"><?php echo e($grandChild->question_text); ?></h6>
                                                    <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                                                  </div>
                                                  <i class="fas fa-chevron-down ms-auto"></i>
                                                </div>
                                              </button>
                                            </h2>
                                            <div id="collapse-great-grandchild-<?php echo e($grandChild->id); ?>" class="accordion-collapse collapse" aria-labelledby="heading-great-grandchild-<?php echo e($grandChild->id); ?>">
                                              <div class="accordion-body bg-white p-4">
                                                <div class="row">
                                                  <?php $__currentLoopData = $group->questions->where('parent_id', $grandChild->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $greatGrandChildIndex => $greatGrandChild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                  <?php if($greatGrandChild->use_in_evaluation && $greatGrandChild->question_type !== null): ?>
                                                  <!-- Great Grand Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                                                  <div class="col-12 mb-4">
                                                    <div class="card border-0 shadow-sm">
                                                      <div class="card-body p-4">
                                                        <div class="ms-4 border-start border-primary ps-3">
                                                          <div class="d-flex align-items-start mb-3">
                                                            <div class="flex-grow-1">
                                                              <h6 class="card-title mb-2 text-dark"><?php echo e($greatGrandChild->question_text); ?></h6>
                                                              <!-- ฟอร์มตอบคำถาม -->
                                                              <?php if($greatGrandChild->question_type == 'yes_no'): ?>
                                                                <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                                <div class="mb-3">
                                                                  <div class="form-check form-check-inline">
                                                                    <input class="form-check-input yes-no-radio" type="radio"
                                                                      name="answers[<?php echo e($greatGrandChild->id); ?>][choice]"
                                                                      id="yes_<?php echo e($greatGrandChild->id); ?>"
                                                                      value="yes"
                                                                      data-question-id="<?php echo e($greatGrandChild->id); ?>"
                                                                      <?php if(isset($existingAnswers[$greatGrandChild->id]['choice']) && $existingAnswers[$greatGrandChild->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                                                    <label class="form-check-label" for="yes_<?php echo e($greatGrandChild->id); ?>">
                                                                      ใช่
                                                                    </label>
                                                                  </div>
                                                                  <div class="form-check form-check-inline">
                                                                    <input class="form-check-input yes-no-radio" type="radio"
                                                                      name="answers[<?php echo e($greatGrandChild->id); ?>][choice]"
                                                                      id="no_<?php echo e($greatGrandChild->id); ?>"
                                                                      value="no"
                                                                      data-question-id="<?php echo e($greatGrandChild->id); ?>"
                                                                      <?php if(isset($existingAnswers[$greatGrandChild->id]['choice']) && $existingAnswers[$greatGrandChild->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                                                    <label class="form-check-label" for="no_<?php echo e($greatGrandChild->id); ?>">
                                                                      ไม่ใช่
                                                                    </label>
                                                                  </div>
                                                                </div>
                                                                <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                                <div id="text_field_<?php echo e($greatGrandChild->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$greatGrandChild->id]['choice']) && $existingAnswers[$greatGrandChild->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                                                  <label class="form-label text-muted">
                                                                    <i class="fas fa-comment me-1"></i>
                                                                    กรุณาระบุรายละเอียดเพิ่มเติม:
                                                                  </label>
                                                                  <textarea
                                                                    name="answers[<?php echo e($greatGrandChild->id); ?>][details]"
                                                                    class="form-control border-0 bg-light evaluation-field"
                                                                    rows="3"
                                                                    placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                    style="resize: none;"
                                                                    data-field="evaluation_<?php echo e($greatGrandChild->id); ?>_details"><?php echo e($existingAnswers[$greatGrandChild->id]['details'] ?? ''); ?></textarea>
                                                                </div>
                                                              <?php elseif($greatGrandChild->question_type == 'multiple_choice'): ?>
                                                                <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                <div class="mb-3">
                                                                  <?php
                                                                    $choices = $greatGrandChild->choices;
                                                                    if (is_string($choices)) {
                                                                        $choices = json_decode($choices, true);
                                                                    }
                                                                  ?>
                                                                  <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                    <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                      <div class="form-check">
                                                                        <input class="form-check-input multiple-choice-radio" type="radio"
                                                                          name="answers[<?php echo e($greatGrandChild->id); ?>][choice]"
                                                                          id="choice_<?php echo e($greatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                          value="<?php echo e($choice); ?>"
                                                                          data-question-id="<?php echo e($greatGrandChild->id); ?>"
                                                                          <?php if(isset($existingAnswers[$greatGrandChild->id]['choice']) && $existingAnswers[$greatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                        <label class="form-check-label" for="choice_<?php echo e($greatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                          <?php echo e($choice); ?>

                                                                        </label>
                                                                      </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                  <?php else: ?>
                                                                    <div class="alert alert-warning border-0">
                                                                      <i class="fas fa-exclamation-triangle me-2"></i>
                                                                      ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                    </div>
                                                                  <?php endif; ?>
                                                                </div>
                                                              <?php elseif($greatGrandChild->question_type == 'text'): ?>
                                                                <!-- สำหรับคำถามแบบข้อความ -->
                                                                <div class="mb-3">
                                                                  <textarea
                                                                    name="answers[<?php echo e($greatGrandChild->id); ?>][text]"
                                                                    class="form-control border-0 bg-light evaluation-field"
                                                                    rows="3"
                                                                    placeholder="กรุณาตอบคำถาม..."
                                                                    style="resize: none;"
                                                                    data-field="evaluation_<?php echo e($greatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                </div>
                                                              <?php endif; ?>
                                                            </div>
                                                          </div>
                                                        </div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <?php $globalQuestionNumber++; ?>
                                                  
                                                  
                                                  <?php elseif(!$greatGrandChild->use_in_evaluation && $greatGrandChild->question_type !== null): ?>
                                                  <!-- Great Grand Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null -->
                                                  <div class="col-12 mb-4">
                                                    <div class="card border-0 shadow-sm">
                                                      <div class="card-body p-4">
                                                        <div class="ms-4 border-start border-secondary ps-3">
                                                          <div class="d-flex align-items-start mb-3">
                                                            <div class="flex-grow-1">
                                                              <h6 class="card-title mb-2 text-dark"><?php echo e($greatGrandChild->question_text); ?></h6>
                                                              <!-- ฟอร์มตอบคำถาม -->
                                                              <?php if($greatGrandChild->question_type == 'multiple_choice'): ?>
                                                                <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                <div class="mb-3">
                                                                  <?php
                                                                    $choices = $greatGrandChild->choices;
                                                                    if (is_string($choices)) {
                                                                        $choices = json_decode($choices, true);
                                                                    }
                                                                  ?>
                                                                  <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                    <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                      <div class="form-check">
                                                                        <input class="form-check-input" type="radio"
                                                                          name="answers[<?php echo e($greatGrandChild->id); ?>][choice]"
                                                                          id="choice_<?php echo e($greatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                          value="<?php echo e($choice); ?>"
                                                                          data-question-id="<?php echo e($greatGrandChild->id); ?>"
                                                                          <?php if(isset($existingAnswers[$greatGrandChild->id]['choice']) && $existingAnswers[$greatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                        <label class="form-check-label" for="choice_<?php echo e($greatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                          <?php echo e($choice); ?>

                                                                        </label>
                                                                      </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                  <?php else: ?>
                                                                    <div class="alert alert-warning border-0">
                                                                      <i class="fas fa-exclamation-triangle me-2"></i>
                                                                      ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                    </div>
                                                                  <?php endif; ?>
                                                                </div>
                                                              <?php elseif($greatGrandChild->question_type == 'text'): ?>
                                                                <!-- สำหรับคำถามแบบข้อความ -->
                                                                <div class="mb-3">
                                                                  <textarea
                                                                    name="answers[<?php echo e($greatGrandChild->id); ?>][text]"
                                                                    class="form-control border-0 bg-light"
                                                                    rows="3"
                                                                    placeholder="กรุณาตอบคำถาม..."
                                                                    style="resize: none;"
                                                                    data-field="evaluation_<?php echo e($greatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                </div>
                                                              <?php endif; ?>
                                                            </div>
                                                          </div>
                                                        </div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <?php elseif($greatGrandChild->question_type === null): ?>
                                                  <!-- Great Great Grand Child Question (ระดับ 5) - แสดงเป็น accordion button -->
                                                  <div class="col-12 mb-3">
                                                    <div class="accordion-item border-0">
                                                      <h2 class="accordion-header" id="heading-great-great-grandchild-<?php echo e($greatGrandChild->id); ?>">
                                                        <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-great-great-grandchild-<?php echo e($greatGrandChild->id); ?>" style="padding: 0.75rem;">
                                                          <div class="d-flex align-items-center w-100">
                                                            <div class="flex-grow-1">
                                                              <h6 class="mb-1 question-label"><?php echo e($greatGrandChild->question_text); ?></h6>
                                                              <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                                                            </div>
                                                            <i class="fas fa-chevron-down ms-auto"></i>
                                                          </div>
                                                        </button>
                                                      </h2>
                                                      <div id="collapse-great-great-grandchild-<?php echo e($greatGrandChild->id); ?>" class="accordion-collapse collapse" aria-labelledby="heading-great-great-grandchild-<?php echo e($greatGrandChild->id); ?>">
                                                        <div class="accordion-body bg-white p-4">
                                                          <div class="row">
                                                            <?php $__currentLoopData = $group->questions->where('parent_id', $greatGrandChild->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $greatGreatGrandChildIndex => $greatGreatGrandChild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($greatGreatGrandChild->use_in_evaluation && $greatGreatGrandChild->question_type !== null): ?>
                                                            <!-- Great Great Great Grand Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                                                            <div class="col-12 mb-4">
                                                              <div class="card border-0 shadow-sm">
                                                                <div class="card-body p-4">
                                                                  <div class="ms-4 border-start border-primary ps-3">
                                                                    <div class="d-flex align-items-start mb-3">
                                                                      <div class="flex-grow-1">
                                                                        <h6 class="card-title mb-2 text-dark"><?php echo e($greatGreatGrandChild->question_text); ?></h6>
                                                                        <!-- ฟอร์มตอบคำถาม -->
                                                                        <?php if($greatGreatGrandChild->question_type == 'yes_no'): ?>
                                                                          <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                                          <div class="mb-3">
                                                                            <div class="form-check form-check-inline">
                                                                              <input class="form-check-input yes-no-radio" type="radio"
                                                                                name="answers[<?php echo e($greatGreatGrandChild->id); ?>][choice]"
                                                                                id="yes_<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                value="yes"
                                                                                data-question-id="<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                <?php if(isset($existingAnswers[$greatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGrandChild->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                                                              <label class="form-check-label" for="yes_<?php echo e($greatGreatGrandChild->id); ?>">
                                                                                ใช่
                                                                              </label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                              <input class="form-check-input yes-no-radio" type="radio"
                                                                                name="answers[<?php echo e($greatGreatGrandChild->id); ?>][choice]"
                                                                                id="no_<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                value="no"
                                                                                data-question-id="<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                <?php if(isset($existingAnswers[$greatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGrandChild->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                                                              <label class="form-check-label" for="no_<?php echo e($greatGreatGrandChild->id); ?>">
                                                                                ไม่ใช่
                                                                              </label>
                                                                            </div>
                                                                          </div>
                                                                          <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                                          <div id="text_field_<?php echo e($greatGreatGrandChild->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$greatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGrandChild->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                                                            <label class="form-label text-muted">
                                                                              <i class="fas fa-comment me-1"></i>
                                                                              กรุณาระบุรายละเอียดเพิ่มเติม:
                                                                            </label>
                                                                            <textarea
                                                                              name="answers[<?php echo e($greatGreatGrandChild->id); ?>][details]"
                                                                              class="form-control border-0 bg-light evaluation-field"
                                                                              rows="3"
                                                                              placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                              style="resize: none;"
                                                                              data-field="evaluation_<?php echo e($greatGreatGrandChild->id); ?>_details"><?php echo e($existingAnswers[$greatGreatGrandChild->id]['details'] ?? ''); ?></textarea>
                                                                          </div>
                                                                        <?php elseif($greatGreatGrandChild->question_type == 'multiple_choice'): ?>
                                                                          <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                          <div class="mb-3">
                                                                            <?php
                                                                              $choices = $greatGreatGrandChild->choices;
                                                                              if (is_string($choices)) {
                                                                                  $choices = json_decode($choices, true);
                                                                              }
                                                                            ?>
                                                                            <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                              <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="form-check">
                                                                                  <input class="form-check-input multiple-choice-radio" type="radio"
                                                                                    name="answers[<?php echo e($greatGreatGrandChild->id); ?>][choice]"
                                                                                    id="choice_<?php echo e($greatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                    value="<?php echo e($choice); ?>"
                                                                                    data-question-id="<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                    <?php if(isset($existingAnswers[$greatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                                  <label class="form-check-label" for="choice_<?php echo e($greatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                    <?php echo e($choice); ?>

                                                                                  </label>
                                                                                </div>
                                                                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                              <div class="alert alert-warning border-0">
                                                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                              </div>
                                                                            <?php endif; ?>
                                                                          </div>
                                                                        <?php elseif($greatGreatGrandChild->question_type == 'text'): ?>
                                                                          <!-- สำหรับคำถามแบบข้อความ -->
                                                                          <div class="mb-3">
                                                                            <textarea
                                                                              name="answers[<?php echo e($greatGreatGrandChild->id); ?>][text]"
                                                                              class="form-control border-0 bg-light evaluation-field"
                                                                              rows="3"
                                                                              placeholder="กรุณาตอบคำถาม..."
                                                                              style="resize: none;"
                                                                              data-field="evaluation_<?php echo e($greatGreatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGreatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                          </div>
                                                                        <?php endif; ?>
                                                                      </div>
                                                                    </div>
                                                                  </div>
                                                                </div>
                                                              </div>
                                                            </div>
                                                            <?php $globalQuestionNumber++; ?>
                                                            
                                                            <?php elseif(!$greatGreatGrandChild->use_in_evaluation && $greatGreatGrandChild->question_type !== null): ?>
                                                            <!-- Great Great Great Grand Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null -->
                                                            <div class="col-12 mb-4">
                                                              <div class="card border-0 shadow-sm">
                                                                <div class="card-body p-4">
                                                                  <div class="ms-4 border-start border-secondary ps-3">
                                                                    <div class="d-flex align-items-start mb-3">
                                                                      <div class="flex-grow-1">
                                                                        <h6 class="card-title mb-2 text-dark"><?php echo e($greatGreatGrandChild->question_text); ?></h6>
                                                                        <!-- ฟอร์มตอบคำถาม -->
                                                                        <?php if($greatGreatGrandChild->question_type == 'multiple_choice'): ?>
                                                                          <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                          <div class="mb-3">
                                                                            <?php
                                                                              $choices = $greatGreatGrandChild->choices;
                                                                              if (is_string($choices)) {
                                                                                  $choices = json_decode($choices, true);
                                                                              }
                                                                            ?>
                                                                            <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                              <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="form-check">
                                                                                  <input class="form-check-input" type="radio"
                                                                                    name="answers[<?php echo e($greatGreatGrandChild->id); ?>][choice]"
                                                                                    id="choice_<?php echo e($greatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                    value="<?php echo e($choice); ?>"
                                                                                    data-question-id="<?php echo e($greatGreatGrandChild->id); ?>"
                                                                                    <?php if(isset($existingAnswers[$greatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                                  <label class="form-check-label" for="choice_<?php echo e($greatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                    <?php echo e($choice); ?>

                                                                                  </label>
                                                                                </div>
                                                                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                              <div class="alert alert-warning border-0">
                                                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                              </div>
                                                                            <?php endif; ?>
                                                                          </div>
                                                                        <?php elseif($greatGreatGrandChild->question_type == 'text'): ?>
                                                                          <!-- สำหรับคำถามแบบข้อความ -->
                                                                          <div class="mb-3">
                                                                            <textarea
                                                                              name="answers[<?php echo e($greatGreatGrandChild->id); ?>][text]"
                                                                              class="form-control border-0 bg-light"
                                                                              rows="3"
                                                                              placeholder="กรุณาตอบคำถาม..."
                                                                              style="resize: none;"
                                                                              data-field="evaluation_<?php echo e($greatGreatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGreatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                          </div>
                                                                        <?php endif; ?>
                                                                      </div>
                                                                    </div>
                                                                  </div>
                                                                </div>
                                                              </div>
                                                            </div>
                                                            <?php elseif(!$greatGreatGrandChild->question_type === null): ?>
                                                            <!-- Great Great Great Great Grand Child Question (ระดับ 6) - แสดงเป็น accordion button -->
                                                            <div class="col-12 mb-3">
                                                              <div class="accordion-item border-0">
                                                                <h2 class="accordion-header" id="heading-great-great-great-grandchild-<?php echo e($greatGreatGrandChild->id); ?>">
                                                                  <button class="accordion-button collapsed bg-light border rounded-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-great-great-great-grandchild-<?php echo e($greatGreatGrandChild->id); ?>" style="padding: 0.5rem;">
                                                                    <div class="d-flex align-items-center w-100">
                                                                      <div class="flex-grow-1">
                                                                        <h6 class="mb-1 question-label"><?php echo e($greatGreatGrandChild->question_text); ?></h6>
                                                                        <small class="text-muted">คลิกเพื่อดูคำถามย่อย</small>
                                                                      </div>
                                                                      <i class="fas fa-chevron-down ms-auto"></i>
                                                                    </div>
                                                                  </button>
                                                                </h2>
                                                                <div id="collapse-great-great-great-grandchild-<?php echo e($greatGreatGrandChild->id); ?>" class="accordion-collapse collapse" aria-labelledby="heading-great-great-great-grandchild-<?php echo e($greatGreatGrandChild->id); ?>">
                                                                  <div class="accordion-body bg-white p-4">
                                                                    <div class="row">
                                                                      <?php $__currentLoopData = $group->questions->where('parent_id', $greatGreatGrandChild->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $greatGreatGreatGrandChildIndex => $greatGreatGreatGrandChild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                      <?php if($greatGreatGreatGrandChild->use_in_evaluation && $greatGreatGreatGrandChild->question_type !== null): ?>
                                                                      <!-- Great Great Great Great Grand Child Questions ที่ใช้ในการประเมินและ question_type ไม่เป็น null -->
                                                                      <div class="col-12 mb-4">
                                                                        <div class="card border-0 shadow-sm">
                                                                          <div class="card-body p-4">
                                                                            <div class="ms-4 border-start border-primary ps-3">
                                                                              <div class="d-flex align-items-start mb-3">
                                                                                <div class="flex-grow-1">
                                                                                  <h6 class="card-title mb-2 text-dark"><?php echo e($greatGreatGreatGrandChild->question_text); ?></h6>
                                                                                  <!-- ฟอร์มตอบคำถาม -->
                                                                                  <?php if($greatGreatGreatGrandChild->question_type == 'yes_no'): ?>
                                                                                    <!-- สำหรับคำถามแบบ ใช่/ไม่ใช่ -->
                                                                                    <div class="mb-3">
                                                                                      <div class="form-check form-check-inline">
                                                                                        <input class="form-check-input yes-no-radio" type="radio"
                                                                                          name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][choice]"
                                                                                          id="yes_<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                          value="yes"
                                                                                          data-question-id="<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                          <?php if(isset($existingAnswers[$greatGreatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGreatGrandChild->id]['choice'] == 'ใช่'): ?> checked <?php endif; ?>>
                                                                                        <label class="form-check-label" for="yes_<?php echo e($greatGreatGreatGrandChild->id); ?>">
                                                                                          ใช่
                                                                                        </label>
                                                                                      </div>
                                                                                      <div class="form-check form-check-inline">
                                                                                        <input class="form-check-input yes-no-radio" type="radio"
                                                                                          name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][choice]"
                                                                                          id="no_<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                          value="no"
                                                                                          data-question-id="<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                          <?php if(isset($existingAnswers[$greatGreatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGreatGrandChild->id]['choice'] == 'ไม่ใช่'): ?> checked <?php endif; ?>>
                                                                                        <label class="form-check-label" for="no_<?php echo e($greatGreatGreatGrandChild->id); ?>">
                                                                                          ไม่ใช่
                                                                                        </label>
                                                                                      </div>
                                                                                    </div>
                                                                                    <!-- ฟิลด์ text ที่แสดงเมื่อเลือก "ใช่" -->
                                                                                    <div id="text_field_<?php echo e($greatGreatGreatGrandChild->id); ?>" class="mt-3" style="display: <?php if(isset($existingAnswers[$greatGreatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGreatGrandChild->id]['choice'] == 'ใช่'): ?> block <?php else: ?> none <?php endif; ?>;">
                                                                                      <label class="form-label text-muted">
                                                                                        <i class="fas fa-comment me-1"></i>
                                                                                        กรุณาระบุรายละเอียดเพิ่มเติม:
                                                                                      </label>
                                                                                      <textarea
                                                                                        name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][details]"
                                                                                        class="form-control border-0 bg-light evaluation-field"
                                                                                        rows="3"
                                                                                        placeholder="กรุณาระบุรายละเอียดเพิ่มเติม..."
                                                                                        style="resize: none;"
                                                                                        data-field="evaluation_<?php echo e($greatGreatGreatGrandChild->id); ?>_details"><?php echo e($existingAnswers[$greatGreatGreatGrandChild->id]['details'] ?? ''); ?></textarea>
                                                                                    </div>
                                                                                  <?php elseif($greatGreatGreatGrandChild->question_type == 'multiple_choice'): ?>
                                                                                    <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                                    <div class="mb-3">
                                                                                      <?php
                                                                                        $choices = $greatGreatGreatGrandChild->choices;
                                                                                        if (is_string($choices)) {
                                                                                            $choices = json_decode($choices, true);
                                                                                        }
                                                                                      ?>
                                                                                      <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                                        <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                          <div class="form-check">
                                                                                            <input class="form-check-input multiple-choice-radio" type="radio"
                                                                                              name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][choice]"
                                                                                              id="choice_<?php echo e($greatGreatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                              value="<?php echo e($choice); ?>"
                                                                                              data-question-id="<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                              <?php if(isset($existingAnswers[$greatGreatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGreatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                                            <label class="form-check-label" for="choice_<?php echo e($greatGreatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                              <?php echo e($choice); ?>

                                                                                            </label>
                                                                                          </div>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                      <?php else: ?>
                                                                                        <div class="alert alert-warning border-0">
                                                                                          <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                          ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                        </div>
                                                                                      <?php endif; ?>
                                                                                    </div>
                                                                                  <?php elseif($greatGreatGreatGrandChild->question_type == 'text'): ?>
                                                                                    <!-- สำหรับคำถามแบบข้อความ -->
                                                                                    <div class="mb-3">
                                                                                      <textarea
                                                                                        name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][text]"
                                                                                        class="form-control border-0 bg-light evaluation-field"
                                                                                        rows="3"
                                                                                        placeholder="กรุณาตอบคำถาม..."
                                                                                        style="resize: none;"
                                                                                        data-field="evaluation_<?php echo e($greatGreatGreatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGreatGreatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                                    </div>
                                                                                  <?php endif; ?>
                                                                                </div>
                                                                              </div>
                                                                            </div>
                                                                          </div>
                                                                        </div>
                                                                      </div>
                                                                      <?php $globalQuestionNumber++; ?>
                                                                      
                                                                      <?php elseif(!$greatGreatGreatGrandChild->use_in_evaluation && $greatGreatGreatGrandChild->question_type !== null): ?>
                                                                      <!-- Great Great Great Great Grand Child Questions ที่ไม่ใช้ในการประเมินแต่ question_type ไม่เป็น null -->
                                                                      <div class="col-12 mb-4">
                                                                        <div class="card border-0 shadow-sm">
                                                                          <div class="card-body p-4">
                                                                            <div class="ms-4 border-start border-secondary ps-3">
                                                                              <div class="d-flex align-items-start mb-3">
                                                                                <div class="flex-grow-1">
                                                                                  <h6 class="card-title mb-2 text-dark"><?php echo e($greatGreatGreatGrandChild->question_text); ?></h6>
                                                                                  <!-- ฟอร์มตอบคำถาม -->
                                                                                  <?php if($greatGreatGreatGrandChild->question_type == 'multiple_choice'): ?>
                                                                                    <!-- สำหรับคำถามแบบตัวเลือก -->
                                                                                    <div class="mb-3">
                                                                                      <?php
                                                                                        $choices = $greatGreatGreatGrandChild->choices;
                                                                                        if (is_string($choices)) {
                                                                                            $choices = json_decode($choices, true);
                                                                                        }
                                                                                      ?>
                                                                                      <?php if($choices && is_array($choices) && count($choices) > 0): ?>
                                                                                        <?php $__currentLoopData = $choices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choiceIndex => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                          <div class="form-check">
                                                                                            <input class="form-check-input" type="radio"
                                                                                              name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][choice]"
                                                                                              id="choice_<?php echo e($greatGreatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>"
                                                                                              value="<?php echo e($choice); ?>"
                                                                                              data-question-id="<?php echo e($greatGreatGreatGrandChild->id); ?>"
                                                                                              <?php if(isset($existingAnswers[$greatGreatGreatGrandChild->id]['choice']) && $existingAnswers[$greatGreatGreatGrandChild->id]['choice'] == $choice): ?> checked <?php endif; ?>>
                                                                                            <label class="form-check-label" for="choice_<?php echo e($greatGreatGreatGrandChild->id); ?>_<?php echo e($choiceIndex); ?>">
                                                                                              <?php echo e($choice); ?>

                                                                                            </label>
                                                                                          </div>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                      <?php else: ?>
                                                                                        <div class="alert alert-warning border-0">
                                                                                          <i class="fas fa-exclamation-triangle me-2"></i>
                                                                                          ไม่มีตัวเลือกให้เลือก กรุณาติดต่อผู้ดูแลระบบ
                                                                                        </div>
                                                                                      <?php endif; ?>
                                                                                    </div>
                                                                                  <?php elseif($greatGreatGreatGrandChild->question_type == 'text'): ?>
                                                                                    <!-- สำหรับคำถามแบบข้อความ -->
                                                                                    <div class="mb-3">
                                                                                      <textarea
                                                                                        name="answers[<?php echo e($greatGreatGreatGrandChild->id); ?>][text]"
                                                                                        class="form-control border-0 bg-light"
                                                                                        rows="3"
                                                                                        placeholder="กรุณาตอบคำถาม..."
                                                                                        style="resize: none;"
                                                                                        data-field="evaluation_<?php echo e($greatGreatGreatGrandChild->id); ?>_text"><?php echo e($existingAnswers[$greatGreatGreatGrandChild->id]['text'] ?? ''); ?></textarea>
                                                                                    </div>
                                                                                  <?php endif; ?>
                                                                                </div>
                                                                              </div>
                                                                            </div>
                                                                          </div>
                                                                        </div>
                                                                      </div>
                                                                      <?php endif; ?>
                                                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                  </div>
                                                                </div>
                                                              </div>
                                                            </div>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                          </div>
                                                        </div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <?php endif; ?>
                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <?php endif; ?>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <!-- ปุ่มส่งแบบฟอร์ม -->
          <div class="text-center mt-4">
            <div class="d-flex justify-content-center gap-3">
              <button type="button" class="btn btn-secondary btn-lg px-4" onclick="history.back()">
                <i class="fas fa-arrow-left me-2"></i>
                ย้อนกลับ
              </button>
              
              <!-- ปุ่มบันทึกฉบับร่าง -->
              <button type="submit" formaction="<?php echo e(route('assessments.store-draft')); ?>" class="btn btn-warning btn-lg px-4" id="save-draft-btn">
                <i class="fas fa-save me-2"></i>
                บันทึกฉบับร่าง
              </button>
              
              <!-- ปุ่มส่งแบบประเมิน -->
              <button type="submit" class="btn btn-success btn-lg px-5" id="evaluation-submit-btn" style="display: none;">
                <i class="fas fa-paper-plane me-2"></i>
                ส่งแบบประเมิน
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const formFields = document.querySelectorAll('.form-field');
    const evaluationFields = document.querySelectorAll('.evaluation-field');
    const progressBar = document.getElementById('progress-bar');
    const progressText = document.getElementById('progress-text');
    const progressStatus = document.getElementById('progress-status');
    const submitBtn = document.getElementById('submit-btn');
    const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
    

    // ตรวจสอบว่าอยู่ในฟอร์มไหน
    const isEvaluationForm = evaluationFields.length > 0;

    let totalFields, completedFields;

    if (isEvaluationForm) {
      // สำหรับฟอร์มประเมิน
      // นับจำนวนคำถามทั้งหมดที่ต้องตอบ
      const questionIds = new Set();
      
      // นับ radio buttons (yes_no เท่านั้น)
      const selectedRadios = document.querySelectorAll('.yes-no-radio');
      selectedRadios.forEach(radio => {
        questionIds.add(radio.getAttribute('data-question-id'));
      });

      totalFields = questionIds.size;
      completedFields = 0;
    } else {
      // สำหรับฟอร์มเพิ่มผลิตภัณฑ์
      totalFields = 5; // จำนวนฟิลด์ที่จำเป็น
      completedFields = 0;
    }

    // ฟังก์ชันตรวจสอบว่าฟิลด์มีข้อมูลหรือไม่
    function isFieldFilled(field) {
      if (field.type === 'file') {
        return field.files.length > 0;
      } else if (field.tagName === 'SELECT') {
        return field.value !== '';
      } else {
        return field.value.trim() !== '';
      }
    }

    // ฟังก์ชันอัปเดต progress
    function updateProgress() {
      if (isEvaluationForm) {
        // สำหรับฟอร์มประเมิน
        completedFields = 0;
        const answeredQuestions = new Set();
        
        // นับ radio buttons ที่เลือกแล้ว (yes_no เท่านั้น)
        const selectedRadios = document.querySelectorAll('.yes-no-radio:checked');
        selectedRadios.forEach(radio => {
          answeredQuestions.add(radio.getAttribute('data-question-id'));
        });
        
        completedFields = answeredQuestions.size;
      } else {
        // สำหรับฟอร์มเพิ่มผลิตภัณฑ์
        completedFields = 0;
        
        // นับฟิลด์ที่กรอกแล้ว
        formFields.forEach(field => {
          if (isFieldFilled(field)) {
            completedFields++;
          }
        });
      }

      const percentage = totalFields > 0 ? (completedFields / totalFields) * 100 : 0;

      // อัปเดต progress bar
      progressBar.style.width = percentage + '%';

      // อัปเดตข้อความและปุ่ม
      if (completedFields === totalFields && totalFields > 0) {
        progressText.textContent = 'Complete!';
        progressText.className = 'badge bg-success';
        if (isEvaluationForm) {
          progressStatus.textContent = 'พร้อมส่งแบบประเมิน';
          
          // ซ่อนปุ่มบันทึกฉบับร่างและแสดงปุ่มส่งแบบประเมิน
          const saveDraftBtn = document.getElementById('save-draft-btn');
          const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
          
          if (saveDraftBtn) {
            saveDraftBtn.style.display = 'none';
          }
          if (evaluationSubmitBtn) {
            evaluationSubmitBtn.style.display = 'inline-block';
            evaluationSubmitBtn.disabled = false;
          }
        } else {
          progressStatus.textContent = 'พร้อมส่งข้อมูลผลิตภัณฑ์';
          if (submitBtn) {
            submitBtn.disabled = false;
          }
        }
      } else {
        progressText.textContent = `${completedFields}/${totalFields}`;
        progressText.className = 'badge bg-warning';
        if (isEvaluationForm) {
          progressStatus.textContent = `กรุณาตอบคำถามให้ครบถ้วน (${completedFields}/${totalFields})`;
          
          // แสดงปุ่มบันทึกฉบับร่างและซ่อนปุ่มส่งแบบประเมิน
          const saveDraftBtn = document.getElementById('save-draft-btn');
          const evaluationSubmitBtn = document.getElementById('evaluation-submit-btn');
          
          if (saveDraftBtn) {
            saveDraftBtn.style.display = 'inline-block';
            saveDraftBtn.disabled = false;
          }
          if (evaluationSubmitBtn) {
            evaluationSubmitBtn.style.display = 'none';
          }
        } else {
          progressStatus.textContent = `กรุณากรอกข้อมูลผลิตภัณฑ์ให้ครบถ้วน (${completedFields}/${totalFields})`;
          if (submitBtn) {
            submitBtn.disabled = true;
          }
        }
      }
    }

    // เพิ่ม event listener สำหรับฟิลด์
    if (isEvaluationForm) {
      evaluationFields.forEach(field => {
        field.addEventListener('input', updateProgress);
        field.addEventListener('change', updateProgress);
      });
    } else {
      formFields.forEach(field => {
        field.addEventListener('input', updateProgress);
        field.addEventListener('change', updateProgress);
      });
    }

    // จัดการการแสดง/ซ่อนฟิลด์ text สำหรับคำถามแบบ yes_no
    const yesNoRadios = document.querySelectorAll('.yes-no-radio');
    yesNoRadios.forEach(radio => {
      radio.addEventListener('change', function() {
        const questionId = this.getAttribute('data-question-id');
        const textField = document.getElementById(`text_field_${questionId}`);
        const detailsField = document.querySelector(`textarea[name="answers[${questionId}][details]"]`);

        if (this.value === 'yes') {
          // แสดงฟิลด์ text เมื่อเลือก "ใช่" (ไม่บังคับกรอก)
          textField.style.display = 'block';
          if (detailsField) {
            detailsField.required = false; // ไม่บังคับกรอก
            detailsField.classList.add('evaluation-field');
          }
        } else {
          // ซ่อนฟิลด์ text เมื่อเลือก "ไม่ใช่"
          textField.style.display = 'none';
          if (detailsField) {
            detailsField.required = false;
            detailsField.value = '';
            detailsField.classList.remove('evaluation-field');
          }
        }

        // อัปเดต progress
        updateProgress();
      });
    });

    // เพิ่ม event listener สำหรับ radio buttons เพื่อนับ progress
    yesNoRadios.forEach(radio => {
      radio.addEventListener('change', updateProgress);
    });

    // ตรวจสอบสถานะเริ่มต้น
    updateProgress();

    // Accordion Button Animation
    const accordionButtons = document.querySelectorAll('.accordion-button');
    
    accordionButtons.forEach(button => {
      button.addEventListener('click', function(e) {
        // หยุดการทำงานของ event listener อื่นๆ ที่อาจขัดแย้ง
        e.stopPropagation();
        
        // หาลูกศรที่อยู่ในปุ่มนี้เท่านั้น
        const icon = this.querySelector('.fas.fa-chevron-down');
        if (icon) {
          // หมุนไอคอนเมื่อคลิกที่ไหนก็ได้ในปุ่ม
          if (this.classList.contains('collapsed')) {
            // เมื่อ accordion ปิด (collapsed) ลูกศรชี้ลง
            icon.style.transform = 'rotate(0deg)';
          } else {
            // เมื่อ accordion เปิด (expanded) ลูกศรชี้ขึ้น
            icon.style.transform = 'rotate(180deg)';
          }
        }
      });
    });

    // เพิ่ม event listener สำหรับ accordion collapse เพื่อ sync animation
    const accordionCollapses = document.querySelectorAll('.accordion-collapse');
    accordionCollapses.forEach(collapse => {
      collapse.addEventListener('show.bs.collapse', function() {
        // หาปุ่มที่เกี่ยวข้องกับ accordion นี้เท่านั้น
        const button = document.querySelector(`[data-bs-target="#${this.id}"]`);
        if (button) {
          const icon = button.querySelector('.fas.fa-chevron-down');
          if (icon) {
            // เมื่อ accordion เปิด ลูกศรชี้ขึ้น
            icon.style.transform = 'rotate(180deg)';
          }
        }
      });
      
      collapse.addEventListener('hide.bs.collapse', function() {
        // หาปุ่มที่เกี่ยวข้องกับ accordion นี้เท่านั้น
        const button = document.querySelector(`[data-bs-target="#${this.id}"]`);
        if (button) {
          const icon = button.querySelector('.fas.fa-chevron-down');
          if (icon) {
            // เมื่อ accordion ปิด ลูกศรชี้ลง
            icon.style.transform = 'rotate(0deg)';
          }
        }
      });
    });

    // เพิ่ม CSS สำหรับ accordion animation
    const accordionStyle = document.createElement('style');
    accordionStyle.textContent = `
      .accordion-button .fas.fa-chevron-down {
        transition: transform 0.3s ease;
      }
      
      .accordion-button:not(.collapsed) .fas.fa-chevron-down {
        transform: rotate(180deg);
      }
      
      .accordion-button.collapsed .fas.fa-chevron-down {
        transform: rotate(0deg);
      }
      
      .accordion-collapse {
        transition: all 0.3s ease;
      }
      
      .accordion-button:hover {
        transform: translateY(-1px);
        transition: all 0.2s ease;
      }
      
      .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
      }
    `;
    document.head.appendChild(accordionStyle);
  });
</script>
<?php $__env->stopSection(); ?>

<!-- {{ old('...') }} คือ ฟังก์ชันช่วยของ Laravel ที่ใช้ใน Blade Template สำหรับ คืนค่า ค่าที่ผู้ใช้เคยกรอกไว้ ก่อนหน้า(ในกรณีที่ submit form แล้วเกิด validation error)-->
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel-project\resources\views/assessments/manual.blade.php ENDPATH**/ ?>